/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.core;

import java.util.function.Function;
import java.util.function.Supplier;
import me.desht.modularrouters.block.BlockItemRouter;
import me.desht.modularrouters.block.BlockTemplateFrame;
import me.desht.modularrouters.core.ModItems;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = new DeferredRegister(ForgeRegistries.BLOCKS, "modularrouters");
    public static final DeferredRegister<Item> ITEMS = ModItems.ITEMS;
    public static final RegistryObject<BlockItemRouter> ITEM_ROUTER = ModBlocks.register("item_router", BlockItemRouter::new);
    public static final RegistryObject<BlockTemplateFrame> TEMPLATE_FRAME = ModBlocks.registerNoItem("template_frame", BlockTemplateFrame::new);

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<? extends T> sup) {
        return ModBlocks.register(name, sup, ModBlocks::itemDefault);
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<? extends T> sup, Function<RegistryObject<T>, Supplier<? extends Item>> itemCreator) {
        RegistryObject<? extends T> ret = ModBlocks.registerNoItem(name, sup);
        ITEMS.register(name, itemCreator.apply(ret));
        return ret;
    }

    private static <T extends Block> RegistryObject<T> registerNoItem(String name, Supplier<? extends T> sup) {
        return BLOCKS.register(name, sup);
    }

    private static Supplier<BlockItem> itemDefault(RegistryObject<? extends Block> block) {
        return ModBlocks.item(block, ModItems.MR_CREATIVE_TAB);
    }

    private static Supplier<BlockItem> item(RegistryObject<? extends Block> block, ItemGroup itemGroup) {
        return () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(itemGroup));
    }
}

