/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.solarflux.block;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.NetworkHooks;
import tk.zeitheron.solarflux.block.SolarPanelTile;
import tk.zeitheron.solarflux.items.UpgradeItem;
import tk.zeitheron.solarflux.panels.SolarPanel;

public class SolarPanelBlock
extends ContainerBlock {
    public final SolarPanel panel;

    public SolarPanelBlock(SolarPanel panel) {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_226896_b_().harvestLevel(1).harvestTool(ToolType.PICKAXE).func_200943_b(1.5f).func_208770_d().func_200947_a(SoundType.field_185852_e));
        this.panel = panel;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (stack.func_77942_o()) {
            SolarPanelTile spt = null;
            TileEntity tile = worldIn.func_175625_s(pos);
            if (tile instanceof SolarPanelTile) {
                spt = (SolarPanelTile)tile;
            } else {
                spt = (SolarPanelTile)this.func_196283_a_((IBlockReader)worldIn);
                worldIn.func_175690_a(pos, (TileEntity)spt);
            }
            spt.loadFromItem(stack);
        }
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        if (!this.canHarvestBlock(state, (IBlockReader)worldIn, pos, player)) {
            super.func_176208_a(worldIn, pos, state, player);
            return;
        }
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof SolarPanelTile) {
            SolarPanelTile te = (SolarPanelTile)tileentity;
            if (!worldIn.field_72995_K) {
                ItemEntity itementity = new ItemEntity(worldIn, (double)pos.func_177958_n() + 0.5, (double)((float)pos.func_177956_o() + this.panel.delegateData.height / 2.0f), (double)pos.func_177952_p() + 0.5, te.generateItem(this.panel));
                itementity.func_174869_p();
                worldIn.func_217376_c((Entity)itementity);
            }
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }

    public boolean func_220081_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        SolarPanelTile spt;
        TileEntity tile = world.func_175625_s(pos);
        SolarPanelTile solarPanelTile = spt = tile instanceof SolarPanelTile ? (SolarPanelTile)tile : null;
        if (spt != null) {
            return spt.getShape(this);
        }
        return VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)this.panel.networkData.height, (double)1.0);
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        SolarPanelTile spt;
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
        TileEntity tile = worldIn.func_175625_s(pos);
        SolarPanelTile solarPanelTile = spt = tile instanceof SolarPanelTile ? (SolarPanelTile)tile : null;
        if (spt != null) {
            spt.resetVoxelShape();
        }
    }

    public VoxelShape recalcShape(IBlockReader world, BlockPos pos) {
        VoxelShape baseShape = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)this.panel.networkData.height, (double)1.0);
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>(8);
        boolean west = false;
        boolean east = false;
        boolean north = false;
        boolean south = false;
        float h = this.panel.getPanelData().height;
        float h2 = h + 0.015625f;
        west = world.func_180495_p(pos.func_177976_e()).func_177230_c() != this;
        if (west) {
            shapes.add(VoxelShapes.func_197873_a((double)0.0, (double)h, (double)0.0625, (double)0.0625, (double)h2, (double)0.9375));
        }
        if (east = world.func_180495_p(pos.func_177974_f()).func_177230_c() != this) {
            shapes.add(VoxelShapes.func_197873_a((double)0.9375, (double)h, (double)0.0625, (double)1.0, (double)h2, (double)0.9375));
        }
        if (north = world.func_180495_p(pos.func_177978_c()).func_177230_c() != this) {
            shapes.add(VoxelShapes.func_197873_a((double)0.0625, (double)h, (double)0.0, (double)0.9375, (double)h2, (double)0.0625));
        }
        if (south = world.func_180495_p(pos.func_177968_d()).func_177230_c() != this) {
            shapes.add(VoxelShapes.func_197873_a((double)0.0625, (double)h, (double)0.9375, (double)0.9375, (double)h2, (double)1.0));
        }
        if (west || north || world.func_180495_p(pos.func_177976_e().func_177978_c()).func_177230_c() != this) {
            shapes.add(VoxelShapes.func_197873_a((double)0.0, (double)h, (double)0.0, (double)0.0625, (double)h2, (double)0.0625));
        }
        if (east || north || world.func_180495_p(pos.func_177974_f().func_177978_c()).func_177230_c() != this) {
            shapes.add(VoxelShapes.func_197873_a((double)0.9375, (double)h, (double)0.0, (double)1.0, (double)h2, (double)0.0625));
        }
        if (south || east || world.func_180495_p(pos.func_177968_d().func_177974_f()).func_177230_c() != this) {
            shapes.add(VoxelShapes.func_197873_a((double)0.9375, (double)h, (double)0.9375, (double)1.0, (double)h2, (double)1.0));
        }
        if (west || south || world.func_180495_p(pos.func_177976_e().func_177968_d()).func_177230_c() != this) {
            shapes.add(VoxelShapes.func_197873_a((double)0.0, (double)h, (double)0.9375, (double)0.0625, (double)h2, (double)1.0));
        }
        return VoxelShapes.func_216384_a((VoxelShape)baseShape, (VoxelShape[])shapes.toArray(new VoxelShape[shapes.size()]));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        SolarPanelTile tbs;
        TileEntity te = worldIn.func_175625_s(pos);
        SolarPanelTile solarPanelTile = tbs = te instanceof SolarPanelTile ? (SolarPanelTile)te : null;
        if (player instanceof ServerPlayerEntity && tbs != null) {
            ItemStack held = player.func_184586_b(handIn);
            if (!held.func_190926_b() && held.func_77973_b() instanceof UpgradeItem) {
                int amt = tbs.getUpgrades(held.func_77973_b());
                UpgradeItem iu = (UpgradeItem)held.func_77973_b();
                if (amt < held.func_77976_d() && iu.canInstall(tbs, held, tbs.upgradeInventory)) {
                    boolean installed = false;
                    for (int i = 0; i < tbs.upgradeInventory.getSlots(); ++i) {
                        ItemStack stack = tbs.upgradeInventory.getStackInSlot(i);
                        if (stack.func_77969_a(held) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)held)) {
                            int allow = Math.min(held.func_77976_d() - tbs.getUpgrades(iu), Math.min(iu.getItemStackLimit(stack) - stack.func_190916_E(), held.func_190916_E()));
                            stack.func_190917_f(allow);
                            held.func_190918_g(allow);
                            installed = true;
                            break;
                        }
                        if (!stack.func_190926_b()) continue;
                        int allow = Math.min(held.func_77976_d() - tbs.getUpgrades(iu), held.func_190916_E());
                        ItemStack copy = held.func_77946_l();
                        held.func_190918_g(allow);
                        copy.func_190920_e(allow);
                        tbs.upgradeInventory.setStackInSlot(i, copy);
                        installed = true;
                        break;
                    }
                    if (installed) {
                        worldIn.func_184133_a(null, pos, SoundEvents.field_187689_f, SoundCategory.BLOCKS, 0.1f, 1.0f);
                        return ActionResultType.SUCCESS;
                    }
                }
            }
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)tbs, buf -> buf.func_179255_a(pos));
        }
        return ActionResultType.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        return adjacentBlockState.func_177230_c() == state.func_177230_c() && side != Direction.UP;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof SolarPanelTile) {
            SolarPanelTile sp = (SolarPanelTile)tile;
            long cap = sp.capacity.getValueL();
            return cap > 0L ? (int)Math.round(15.0 * (double)sp.energy / (double)cap) : 0;
        }
        return 0;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        SolarPanelTile tile = new SolarPanelTile();
        tile.setDelegate(this.panel);
        return tile;
    }
}

