/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.registry;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.ComposterBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.EntityOptions;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.potion.Effect;
import net.minecraft.potion.PotionBrewing;
import net.minecraft.server.DebugLoggingPrintStream;
import net.minecraft.util.LoggingPrintStream;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.world.biome.Biome;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Bootstrap {
    public static final PrintStream field_179872_a = System.out;
    private static boolean field_151355_a;
    private static final Logger field_179871_c;

    public static void func_151354_b() {
        if (!field_151355_a) {
            field_151355_a = true;
            if (Registry.field_212617_f.func_195866_d()) {
                throw new IllegalStateException("Unable to load registries");
            }
            FireBlock.func_149843_e();
            ComposterBlock.func_220297_d();
            if (EntityType.func_200718_a(EntityType.field_200729_aH) == null) {
                throw new IllegalStateException("Failed loading EntityTypes");
            }
            PotionBrewing.func_185207_a();
            EntityOptions.func_197445_a();
            IDispenseItemBehavior.func_218401_c();
            ArgumentTypes.func_197483_a();
        }
    }

    private static <T> void func_218819_a(Registry<T> p_218819_0_, Function<T, String> p_218819_1_, Set<String> p_218819_2_) {
        LanguageMap languagemap = LanguageMap.func_74808_a();
        p_218819_0_.iterator().forEachRemaining(p_218818_3_ -> {
            String s = (String)p_218819_1_.apply(p_218818_3_);
            if (!languagemap.func_210813_b(s)) {
                p_218819_2_.add(s);
            }
        });
    }

    public static Set<String> func_218816_b() {
        TreeSet<String> set = new TreeSet<String>();
        Bootstrap.func_218819_a(Registry.field_212629_r, EntityType::func_210760_d, set);
        Bootstrap.func_218819_a(Registry.field_212631_t, Effect::func_76393_a, set);
        Bootstrap.func_218819_a(Registry.field_212630_s, Item::func_77658_a, set);
        Bootstrap.func_218819_a(Registry.field_212628_q, Enchantment::func_77320_a, set);
        Bootstrap.func_218819_a(Registry.field_212624_m, Biome::func_210773_k, set);
        Bootstrap.func_218819_a(Registry.field_212618_g, Block::func_149739_a, set);
        Bootstrap.func_218819_a(Registry.field_212623_l, p_218820_0_ -> "stat." + p_218820_0_.toString().replace(':', '.'), set);
        return set;
    }

    public static void func_218821_c() {
        if (!field_151355_a) {
            throw new IllegalArgumentException("Not bootstrapped");
        }
        if (SharedConstants.field_206244_b) {
            Bootstrap.func_218816_b().forEach(p_218817_0_ -> field_179871_c.error("Missing translations: " + p_218817_0_));
        }
    }

    private static void func_179868_d() {
        if (field_179871_c.isDebugEnabled()) {
            System.setErr((PrintStream)new DebugLoggingPrintStream("STDERR", (OutputStream)System.err));
            System.setOut((PrintStream)new DebugLoggingPrintStream("STDOUT", (OutputStream)field_179872_a));
        } else {
            System.setErr((PrintStream)new LoggingPrintStream("STDERR", (OutputStream)System.err));
            System.setOut((PrintStream)new LoggingPrintStream("STDOUT", (OutputStream)field_179872_a));
        }
    }

    public static void func_179870_a(String message) {
        field_179872_a.println(message);
    }

    static {
        field_179871_c = LogManager.getLogger();
    }
}

