/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.arguments.BlockPredicateArgument;
import net.minecraft.command.arguments.BlockStateParser;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.enchantment.UnbreakingEnchantment;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.NetworkTagManager;
import net.minecraft.tags.Tag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.extensions.IForgeItemStack;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.IRegistryDelegate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ItemStack
extends CapabilityProvider<ItemStack>
implements IForgeItemStack {
    private static final Logger field_199558_c = LogManager.getLogger();
    public static final ItemStack field_190927_a = new ItemStack((IItemProvider)null);
    public static final DecimalFormat field_111284_a = ItemStack.func_208306_D();
    private int field_77994_a;
    private int field_77992_b;
    @Deprecated
    private final Item field_151002_e;
    private CompoundNBT field_77990_d;
    private boolean field_190928_g;
    private ItemFrameEntity field_82843_f;
    private CachedBlockInfo field_179552_h;
    private boolean field_179553_i;
    private CachedBlockInfo field_179550_j;
    private boolean field_179551_k;
    private IRegistryDelegate<Item> delegate;
    private CompoundNBT capNBT;

    private static DecimalFormat func_208306_D() {
        DecimalFormat decimalformat = new DecimalFormat("#.##");
        decimalformat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT));
        return decimalformat;
    }

    public ItemStack(IItemProvider itemIn) {
        this(itemIn, 1);
    }

    public ItemStack(IItemProvider itemIn, int count) {
        this(itemIn, count, null);
    }

    public ItemStack(IItemProvider itemIn, int count, @Nullable CompoundNBT capNBT) {
        super(ItemStack.class);
        this.capNBT = capNBT;
        this.field_151002_e = itemIn == null ? null : itemIn.func_199767_j();
        this.field_77994_a = count;
        if (this.field_151002_e != null && this.field_151002_e.func_77645_m()) {
            this.func_196085_b(this.func_77952_i());
        }
        this.func_190923_F();
        this.forgeInit();
    }

    private void func_190923_F() {
        this.field_190928_g = false;
        this.field_190928_g = this.func_190926_b();
    }

    private ItemStack(CompoundNBT compound) {
        super(ItemStack.class);
        this.capNBT = compound.func_74764_b("ForgeCaps") ? compound.func_74775_l("ForgeCaps") : null;
        this.field_151002_e = (Item)((Object)Registry.field_212630_s.func_82594_a(new ResourceLocation(compound.func_74779_i("id"))));
        this.field_77994_a = compound.func_74771_c("Count");
        if (compound.func_150297_b("tag", 10)) {
            this.field_77990_d = compound.func_74775_l("tag");
            this.func_77973_b().func_179215_a(compound);
        }
        if (this.func_77973_b().func_77645_m()) {
            this.func_196085_b(this.func_77952_i());
        }
        this.func_190923_F();
        this.forgeInit();
    }

    public static ItemStack func_199557_a(CompoundNBT compound) {
        try {
            return new ItemStack(compound);
        }
        catch (RuntimeException runtimeexception) {
            field_199558_c.debug("Tried to load invalid item: {}", (Object)compound, (Object)runtimeexception);
            return field_190927_a;
        }
    }

    public boolean func_190926_b() {
        if (this == field_190927_a) {
            return true;
        }
        if (this.getItemRaw() != null && this.getItemRaw() != Items.field_190931_a) {
            return this.field_77994_a <= 0;
        }
        return true;
    }

    public ItemStack func_77979_a(int amount) {
        int i = Math.min(amount, this.field_77994_a);
        ItemStack itemstack = this.func_77946_l();
        itemstack.func_190920_e(i);
        this.func_190918_g(i);
        return itemstack;
    }

    public Item func_77973_b() {
        return this.field_190928_g || this.delegate == null ? Items.field_190931_a : (Item)((Object)this.delegate.get());
    }

    public ActionResultType func_196084_a(ItemUseContext context) {
        if (!context.field_196006_g.field_72995_K) {
            return ForgeHooks.onPlaceItemIntoWorld((ItemUseContext)context);
        }
        return this.onItemUse(context, c -> this.func_77973_b().func_195939_a(context));
    }

    public ActionResultType onItemUseFirst(ItemUseContext context) {
        return this.onItemUse(context, c -> this.func_77973_b().onItemUseFirst(this, context));
    }

    private ActionResultType onItemUse(ItemUseContext context, Function<ItemUseContext, ActionResultType> callback) {
        PlayerEntity playerentity = context.func_195999_j();
        BlockPos blockpos = context.func_195995_a();
        CachedBlockInfo cachedblockinfo = new CachedBlockInfo((IWorldReader)context.func_195991_k(), blockpos, false);
        if (playerentity != null && !playerentity.field_71075_bZ.field_75099_e && !this.func_206847_b(context.func_195991_k().func_205772_D(), cachedblockinfo)) {
            return ActionResultType.PASS;
        }
        Item item = this.func_77973_b();
        ActionResultType actionresulttype = callback.apply(context);
        if (playerentity != null && actionresulttype == ActionResultType.SUCCESS) {
            playerentity.func_71029_a(Stats.field_75929_E.func_199076_b(item));
        }
        return actionresulttype;
    }

    public float func_150997_a(BlockState blockIn) {
        return this.func_77973_b().func_150893_a(this, blockIn);
    }

    public ActionResult<ItemStack> func_77957_a(World worldIn, PlayerEntity playerIn, Hand hand) {
        return this.func_77973_b().func_77659_a(worldIn, playerIn, hand);
    }

    public ItemStack func_77950_b(World worldIn, LivingEntity entityLiving) {
        return this.func_77973_b().func_77654_b(this, worldIn, entityLiving);
    }

    public CompoundNBT func_77955_b(CompoundNBT nbt) {
        CompoundNBT cnbt;
        ResourceLocation resourcelocation = Registry.field_212630_s.func_177774_c((Object)this.func_77973_b());
        nbt.func_74778_a("id", resourcelocation == null ? "minecraft:air" : resourcelocation.toString());
        nbt.func_74774_a("Count", (byte)this.field_77994_a);
        if (this.field_77990_d != null) {
            nbt.func_218657_a("tag", this.field_77990_d.func_74737_b());
        }
        if ((cnbt = this.serializeCaps()) != null && !cnbt.isEmpty()) {
            nbt.func_218657_a("ForgeCaps", cnbt);
        }
        return nbt;
    }

    public int func_77976_d() {
        return this.func_77973_b().getItemStackLimit(this);
    }

    public boolean func_77985_e() {
        return this.func_77976_d() > 1 && (!this.func_77984_f() || !this.func_77951_h());
    }

    public boolean func_77984_f() {
        if (!this.field_190928_g && this.func_77973_b().getMaxDamage(this) > 0) {
            CompoundNBT compoundnbt = this.func_77978_p();
            return compoundnbt == null || !compoundnbt.func_74767_n("Unbreakable");
        }
        return false;
    }

    public boolean func_77951_h() {
        return this.func_77984_f() && this.func_77973_b().isDamaged(this);
    }

    public int func_77952_i() {
        return this.func_77973_b().getDamage(this);
    }

    public void func_196085_b(int damage) {
        this.func_77973_b().setDamage(this, damage);
    }

    public int func_77958_k() {
        return this.func_77973_b().getMaxDamage(this);
    }

    public boolean func_96631_a(int amount, Random rand, @Nullable ServerPlayerEntity damager) {
        if (!this.func_77984_f()) {
            return false;
        }
        if (amount > 0) {
            int i = EnchantmentHelper.func_77506_a(Enchantments.field_185307_s, this);
            int j = 0;
            for (int k = 0; i > 0 && k < amount; ++k) {
                if (!UnbreakingEnchantment.func_92097_a((ItemStack)this, (int)i, (Random)rand)) continue;
                ++j;
            }
            if ((amount -= j) <= 0) {
                return false;
            }
        }
        if (damager != null && amount != 0) {
            CriteriaTriggers.field_193132_s.func_193158_a(damager, this, this.func_77952_i() + amount);
        }
        int l = this.func_77952_i() + amount;
        this.func_196085_b(l);
        return l >= this.func_77958_k();
    }

    public <T extends LivingEntity> void func_222118_a(int amount, T entityIn, Consumer<T> onBroken) {
        if (!(entityIn.field_70170_p.field_72995_K || entityIn instanceof PlayerEntity && ((PlayerEntity)entityIn).field_71075_bZ.field_75098_d || !this.func_77984_f() || !this.func_96631_a(amount = this.func_77973_b().damageItem(this, amount, entityIn, onBroken), entityIn.func_70681_au(), entityIn instanceof ServerPlayerEntity ? (ServerPlayerEntity)entityIn : null))) {
            onBroken.accept(entityIn);
            Item item = this.func_77973_b();
            this.func_190918_g(1);
            if (entityIn instanceof PlayerEntity) {
                ((PlayerEntity)entityIn).func_71029_a(Stats.field_199088_e.func_199076_b(item));
            }
            this.func_196085_b(0);
        }
    }

    public void func_77961_a(LivingEntity entityIn, PlayerEntity playerIn) {
        Item item = this.func_77973_b();
        if (item.func_77644_a(this, entityIn, playerIn)) {
            playerIn.func_71029_a(Stats.field_75929_E.func_199076_b(item));
        }
    }

    public void func_179548_a(World worldIn, BlockState blockIn, BlockPos pos, PlayerEntity playerIn) {
        Item item = this.func_77973_b();
        if (item.func_179218_a(this, worldIn, blockIn, pos, playerIn)) {
            playerIn.func_71029_a(Stats.field_75929_E.func_199076_b(item));
        }
    }

    public boolean func_150998_b(BlockState blockIn) {
        return this.func_77973_b().canHarvestBlock(this, blockIn);
    }

    public boolean func_111282_a(PlayerEntity playerIn, LivingEntity entityIn, Hand hand) {
        return this.func_77973_b().func_111207_a(this, playerIn, entityIn, hand);
    }

    public ItemStack func_77946_l() {
        if (this.func_190926_b()) {
            return field_190927_a;
        }
        ItemStack itemstack = new ItemStack(this.func_77973_b(), this.field_77994_a, this.serializeCaps());
        itemstack.func_190915_d(this.func_190921_D());
        if (this.field_77990_d != null) {
            itemstack.field_77990_d = this.field_77990_d.func_74737_b();
        }
        return itemstack;
    }

    public static boolean func_77970_a(ItemStack stackA, ItemStack stackB) {
        if (stackA.func_190926_b() && stackB.func_190926_b()) {
            return true;
        }
        if (!stackA.func_190926_b() && !stackB.func_190926_b()) {
            if (stackA.field_77990_d == null && stackB.field_77990_d != null) {
                return false;
            }
            return stackA.field_77990_d == null || stackA.field_77990_d.equals(stackB.field_77990_d) && stackA.areCapsCompatible(stackB);
        }
        return false;
    }

    public static boolean func_77989_b(ItemStack stackA, ItemStack stackB) {
        if (stackA.func_190926_b() && stackB.func_190926_b()) {
            return true;
        }
        return !stackA.func_190926_b() && !stackB.func_190926_b() ? stackA.func_77959_d(stackB) : false;
    }

    private boolean func_77959_d(ItemStack other) {
        if (this.field_77994_a != other.field_77994_a) {
            return false;
        }
        if (this.func_77973_b() != other.func_77973_b()) {
            return false;
        }
        if (this.field_77990_d == null && other.field_77990_d != null) {
            return false;
        }
        return this.field_77990_d == null || this.field_77990_d.equals(other.field_77990_d) && this.areCapsCompatible(other);
    }

    public static boolean func_179545_c(ItemStack stackA, ItemStack stackB) {
        if (stackA == stackB) {
            return true;
        }
        return !stackA.func_190926_b() && !stackB.func_190926_b() ? stackA.func_77969_a(stackB) : false;
    }

    public static boolean func_185132_d(ItemStack stackA, ItemStack stackB) {
        if (stackA == stackB) {
            return true;
        }
        return !stackA.func_190926_b() && !stackB.func_190926_b() ? stackA.func_185136_b(stackB) : false;
    }

    public boolean func_77969_a(ItemStack other) {
        return !other.func_190926_b() && this.func_77973_b() == other.func_77973_b();
    }

    public boolean func_185136_b(ItemStack stack) {
        if (!this.func_77984_f()) {
            return this.func_77969_a(stack);
        }
        return !stack.func_190926_b() && this.func_77973_b() == stack.func_77973_b();
    }

    public String func_77977_a() {
        return this.func_77973_b().func_77667_c(this);
    }

    public String toString() {
        return this.field_77994_a + " " + (Object)((Object)this.func_77973_b());
    }

    public void func_77945_a(World worldIn, Entity entityIn, int inventorySlot, boolean isCurrentItem) {
        if (this.field_77992_b > 0) {
            --this.field_77992_b;
        }
        if (this.func_77973_b() != null) {
            this.func_77973_b().func_77663_a(this, worldIn, entityIn, inventorySlot, isCurrentItem);
        }
    }

    public void func_77980_a(World worldIn, PlayerEntity playerIn, int amount) {
        playerIn.func_71064_a(Stats.field_188066_af.func_199076_b(this.func_77973_b()), amount);
        this.func_77973_b().func_77622_d(this, worldIn, playerIn);
    }

    public int func_77988_m() {
        return this.func_77973_b().func_77626_a(this);
    }

    public UseAction func_77975_n() {
        return this.func_77973_b().func_77661_b(this);
    }

    public void func_77974_b(World worldIn, LivingEntity entityLiving, int timeLeft) {
        this.func_77973_b().func_77615_a(this, worldIn, entityLiving, timeLeft);
    }

    public boolean func_222122_m() {
        return this.func_77973_b().func_219970_i(this);
    }

    public boolean func_77942_o() {
        return !this.field_190928_g && this.field_77990_d != null && !this.field_77990_d.isEmpty();
    }

    @Nullable
    public CompoundNBT func_77978_p() {
        return this.field_77990_d;
    }

    public CompoundNBT func_196082_o() {
        if (this.field_77990_d == null) {
            this.func_77982_d(new CompoundNBT());
        }
        return this.field_77990_d;
    }

    public CompoundNBT func_190925_c(String key) {
        if (this.field_77990_d != null && this.field_77990_d.func_150297_b(key, 10)) {
            return this.field_77990_d.func_74775_l(key);
        }
        CompoundNBT compoundnbt = new CompoundNBT();
        this.func_77983_a(key, compoundnbt);
        return compoundnbt;
    }

    @Nullable
    public CompoundNBT func_179543_a(String key) {
        return this.field_77990_d != null && this.field_77990_d.func_150297_b(key, 10) ? this.field_77990_d.func_74775_l(key) : null;
    }

    public void func_196083_e(String p_196083_1_) {
        if (this.field_77990_d != null && this.field_77990_d.func_74764_b(p_196083_1_)) {
            this.field_77990_d.func_82580_o(p_196083_1_);
            if (this.field_77990_d.isEmpty()) {
                this.field_77990_d = null;
            }
        }
    }

    public ListNBT func_77986_q() {
        return this.field_77990_d != null ? this.field_77990_d.func_150295_c("Enchantments", 10) : new ListNBT();
    }

    public void func_77982_d(@Nullable CompoundNBT nbt) {
        this.field_77990_d = nbt;
        if (this.func_77973_b().func_77645_m()) {
            this.func_196085_b(this.func_77952_i());
        }
    }

    public ITextComponent func_200301_q() {
        CompoundNBT compoundnbt = this.func_179543_a("display");
        if (compoundnbt != null && compoundnbt.func_150297_b("Name", 8)) {
            try {
                ITextComponent itextcomponent = ITextComponent.Serializer.func_150699_a((String)compoundnbt.func_74779_i("Name"));
                if (itextcomponent != null) {
                    return itextcomponent;
                }
                compoundnbt.func_82580_o("Name");
            }
            catch (JsonParseException var3) {
                compoundnbt.func_82580_o("Name");
            }
        }
        return this.func_77973_b().func_200295_i(this);
    }

    public ItemStack func_200302_a(@Nullable ITextComponent name) {
        CompoundNBT compoundnbt = this.func_190925_c("display");
        if (name != null) {
            compoundnbt.func_74778_a("Name", ITextComponent.Serializer.func_150696_a((ITextComponent)name));
        } else {
            compoundnbt.func_82580_o("Name");
        }
        return this;
    }

    public void func_135074_t() {
        CompoundNBT compoundnbt = this.func_179543_a("display");
        if (compoundnbt != null) {
            compoundnbt.func_82580_o("Name");
            if (compoundnbt.isEmpty()) {
                this.func_196083_e("display");
            }
        }
        if (this.field_77990_d != null && this.field_77990_d.isEmpty()) {
            this.field_77990_d = null;
        }
    }

    public boolean func_82837_s() {
        CompoundNBT compoundnbt = this.func_179543_a("display");
        return compoundnbt != null && compoundnbt.func_150297_b("Name", 8);
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<ITextComponent> func_82840_a(@Nullable PlayerEntity playerIn, ITooltipFlag advanced) {
        ListNBT listnbt2;
        ListNBT listnbt1;
        ArrayList list = Lists.newArrayList();
        ITextComponent itextcomponent = new StringTextComponent("").func_150257_a(this.func_200301_q()).func_211708_a(this.func_77953_t().field_77937_e);
        if (this.func_82837_s()) {
            itextcomponent.func_211708_a(TextFormatting.ITALIC);
        }
        list.add(itextcomponent);
        if (!advanced.func_194127_a() && !this.func_82837_s() && this.func_77973_b() == Items.field_151098_aY) {
            list.add(new StringTextComponent("#" + FilledMapItem.func_195949_f(this)).func_211708_a(TextFormatting.GRAY));
        }
        int i = 0;
        if (this.func_77942_o() && this.field_77990_d.func_150297_b("HideFlags", 99)) {
            i = this.field_77990_d.func_74762_e("HideFlags");
        }
        if ((i & 0x20) == 0) {
            this.func_77973_b().func_77624_a(this, playerIn == null ? null : playerIn.field_70170_p, list, advanced);
        }
        if (this.func_77942_o()) {
            if ((i & 1) == 0) {
                ItemStack.func_222120_a(list, this.func_77986_q());
            }
            if (this.field_77990_d.func_150297_b("display", 10)) {
                CompoundNBT compoundnbt = this.field_77990_d.func_74775_l("display");
                if (compoundnbt.func_150297_b("color", 3)) {
                    if (advanced.func_194127_a()) {
                        list.add(new TranslationTextComponent("item.color", String.format("#%06X", compoundnbt.func_74762_e("color"))).func_211708_a(TextFormatting.GRAY));
                    } else {
                        list.add(new TranslationTextComponent("item.dyed", new Object[0]).func_211709_a(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC}));
                    }
                }
                if (compoundnbt.func_150299_b("Lore") == 9) {
                    ListNBT listnbt = compoundnbt.func_150295_c("Lore", 8);
                    for (int j = 0; j < listnbt.size(); ++j) {
                        String s = listnbt.func_150307_f(j);
                        try {
                            ITextComponent itextcomponent1 = ITextComponent.Serializer.func_150699_a((String)s);
                            if (itextcomponent1 == null) continue;
                            list.add(TextComponentUtils.func_211401_a((ITextComponent)itextcomponent1, (Style)new Style().func_150238_a(TextFormatting.DARK_PURPLE).func_150217_b(Boolean.valueOf(true))));
                            continue;
                        }
                        catch (JsonParseException var19) {
                            compoundnbt.func_82580_o("Lore");
                        }
                    }
                }
            }
        }
        for (EquipmentSlotType equipmentslottype : EquipmentSlotType.values()) {
            Multimap<String, AttributeModifier> multimap = this.func_111283_C(equipmentslottype);
            if (multimap.isEmpty() || (i & 2) != 0) continue;
            list.add(new StringTextComponent(""));
            list.add(new TranslationTextComponent("item.modifiers." + equipmentslottype.func_188450_d(), new Object[0]).func_211708_a(TextFormatting.GRAY));
            for (Map.Entry entry : multimap.entries()) {
                AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                double d0 = attributemodifier.func_111164_d();
                boolean flag = false;
                if (playerIn != null) {
                    if (attributemodifier.func_111167_a() == Item.field_111210_e) {
                        d0 += playerIn.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b();
                        d0 += (double)EnchantmentHelper.func_152377_a(this, CreatureAttribute.field_223222_a_);
                        flag = true;
                    } else if (attributemodifier.func_111167_a() == Item.field_185050_h) {
                        d0 += playerIn.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111125_b();
                        flag = true;
                    }
                }
                double d1 = attributemodifier.func_220375_c() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier.func_220375_c() != AttributeModifier.Operation.MULTIPLY_TOTAL ? d0 : d0 * 100.0;
                if (flag) {
                    list.add(new StringTextComponent(" ").func_150257_a((ITextComponent)new TranslationTextComponent("attribute.modifier.equals." + attributemodifier.func_220375_c().func_220371_a(), new Object[]{field_111284_a.format(d1), new TranslationTextComponent("attribute.name." + (String)entry.getKey(), new Object[0])})).func_211708_a(TextFormatting.DARK_GREEN));
                    continue;
                }
                if (d0 > 0.0) {
                    list.add(new TranslationTextComponent("attribute.modifier.plus." + attributemodifier.func_220375_c().func_220371_a(), new Object[]{field_111284_a.format(d1), new TranslationTextComponent("attribute.name." + (String)entry.getKey(), new Object[0])}).func_211708_a(TextFormatting.BLUE));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                list.add(new TranslationTextComponent("attribute.modifier.take." + attributemodifier.func_220375_c().func_220371_a(), new Object[]{field_111284_a.format(d1 *= -1.0), new TranslationTextComponent("attribute.name." + (String)entry.getKey(), new Object[0])}).func_211708_a(TextFormatting.RED));
            }
        }
        if (this.func_77942_o() && this.func_77978_p().func_74767_n("Unbreakable") && (i & 4) == 0) {
            list.add(new TranslationTextComponent("item.unbreakable", new Object[0]).func_211708_a(TextFormatting.BLUE));
        }
        if (this.func_77942_o() && this.field_77990_d.func_150297_b("CanDestroy", 9) && (i & 8) == 0 && !(listnbt1 = this.field_77990_d.func_150295_c("CanDestroy", 8)).isEmpty()) {
            list.add(new StringTextComponent(""));
            list.add(new TranslationTextComponent("item.canBreak", new Object[0]).func_211708_a(TextFormatting.GRAY));
            for (int k = 0; k < listnbt1.size(); ++k) {
                list.addAll(ItemStack.func_206845_f(listnbt1.func_150307_f(k)));
            }
        }
        if (this.func_77942_o() && this.field_77990_d.func_150297_b("CanPlaceOn", 9) && (i & 0x10) == 0 && !(listnbt2 = this.field_77990_d.func_150295_c("CanPlaceOn", 8)).isEmpty()) {
            list.add(new StringTextComponent(""));
            list.add(new TranslationTextComponent("item.canPlace", new Object[0]).func_211708_a(TextFormatting.GRAY));
            for (int l = 0; l < listnbt2.size(); ++l) {
                list.addAll(ItemStack.func_206845_f(listnbt2.func_150307_f(l)));
            }
        }
        if (advanced.func_194127_a()) {
            if (this.func_77951_h()) {
                list.add(new TranslationTextComponent("item.durability", this.func_77958_k() - this.func_77952_i(), this.func_77958_k()));
            }
            list.add(new StringTextComponent(Registry.field_212630_s.func_177774_c((Object)this.func_77973_b()).toString()).func_211708_a(TextFormatting.DARK_GRAY));
            if (this.func_77942_o()) {
                list.add(new TranslationTextComponent("item.nbt_tags", this.func_77978_p().func_150296_c().size()).func_211708_a(TextFormatting.DARK_GRAY));
            }
        }
        ForgeEventFactory.onItemTooltip((ItemStack)this, (PlayerEntity)playerIn, (List)list, (ITooltipFlag)advanced);
        return list;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void func_222120_a(List<ITextComponent> p_222120_0_, ListNBT p_222120_1_) {
        for (int i = 0; i < p_222120_1_.size(); ++i) {
            CompoundNBT compoundnbt = p_222120_1_.func_150305_b(i);
            Registry.field_212628_q.func_218349_b(ResourceLocation.func_208304_a((String)compoundnbt.func_74779_i("id"))).ifPresent(p_222123_2_ -> p_222120_0_.add(p_222123_2_.func_200305_d(compoundnbt.func_74762_e("lvl"))));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Collection<ITextComponent> func_206845_f(String stateString) {
        try {
            boolean flag1;
            BlockStateParser blockstateparser = new BlockStateParser(new StringReader(stateString), true).func_197243_a(true);
            BlockState blockstate = blockstateparser.func_197249_b();
            ResourceLocation resourcelocation = blockstateparser.func_199829_d();
            boolean flag = blockstate != null;
            boolean bl = flag1 = resourcelocation != null;
            if (flag || flag1) {
                Collection<Block> collection;
                if (flag) {
                    return Lists.newArrayList((Iterable)blockstate.func_177230_c().func_200291_n().func_211708_a(TextFormatting.DARK_GRAY));
                }
                Tag<Block> tag = BlockTags.func_199896_a().func_199910_a(resourcelocation);
                if (tag != null && !(collection = tag.func_199885_a()).isEmpty()) {
                    return collection.stream().map(Block::func_200291_n).map(p_222119_0_ -> p_222119_0_.func_211708_a(TextFormatting.DARK_GRAY)).collect(Collectors.toList());
                }
            }
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return Lists.newArrayList((Iterable)new StringTextComponent("missingno").func_211708_a(TextFormatting.DARK_GRAY));
    }

    public boolean func_77962_s() {
        return this.func_77973_b().func_77636_d(this);
    }

    public Rarity func_77953_t() {
        return this.func_77973_b().func_77613_e(this);
    }

    public boolean func_77956_u() {
        if (!this.func_77973_b().func_77616_k(this)) {
            return false;
        }
        return !this.func_77948_v();
    }

    public void func_77966_a(Enchantment ench, int level) {
        this.func_196082_o();
        if (!this.field_77990_d.func_150297_b("Enchantments", 9)) {
            this.field_77990_d.func_218657_a("Enchantments", (INBT)new ListNBT());
        }
        ListNBT listnbt = this.field_77990_d.func_150295_c("Enchantments", 10);
        CompoundNBT compoundnbt = new CompoundNBT();
        compoundnbt.func_74778_a("id", String.valueOf(Registry.field_212628_q.func_177774_c(ench)));
        compoundnbt.func_74777_a("lvl", (byte)level);
        listnbt.add((Object)compoundnbt);
    }

    public boolean func_77948_v() {
        if (this.field_77990_d != null && this.field_77990_d.func_150297_b("Enchantments", 9)) {
            return !this.field_77990_d.func_150295_c("Enchantments", 10).isEmpty();
        }
        return false;
    }

    public void func_77983_a(String key, INBT value) {
        this.func_196082_o().func_218657_a(key, value);
    }

    public boolean func_82839_y() {
        return this.field_82843_f != null;
    }

    public void func_82842_a(@Nullable ItemFrameEntity frame) {
        this.field_82843_f = frame;
    }

    @Nullable
    public ItemFrameEntity func_82836_z() {
        return this.field_190928_g ? null : this.field_82843_f;
    }

    public int func_82838_A() {
        return this.func_77942_o() && this.field_77990_d.func_150297_b("RepairCost", 3) ? this.field_77990_d.func_74762_e("RepairCost") : 0;
    }

    public void func_82841_c(int cost) {
        this.func_196082_o().func_74768_a("RepairCost", cost);
    }

    public Multimap<String, AttributeModifier> func_111283_C(EquipmentSlotType equipmentSlot) {
        Multimap multimap;
        if (this.func_77942_o() && this.field_77990_d.func_150297_b("AttributeModifiers", 9)) {
            multimap = HashMultimap.create();
            ListNBT listnbt = this.field_77990_d.func_150295_c("AttributeModifiers", 10);
            for (int i = 0; i < listnbt.size(); ++i) {
                CompoundNBT compoundnbt = listnbt.func_150305_b(i);
                AttributeModifier attributemodifier = SharedMonsterAttributes.func_111259_a(compoundnbt);
                if (attributemodifier == null || compoundnbt.func_150297_b("Slot", 8) && !compoundnbt.func_74779_i("Slot").equals(equipmentSlot.func_188450_d()) || attributemodifier.func_111167_a().getLeastSignificantBits() == 0L || attributemodifier.func_111167_a().getMostSignificantBits() == 0L) continue;
                multimap.put((Object)compoundnbt.func_74779_i("AttributeName"), (Object)attributemodifier);
            }
        } else {
            multimap = this.func_77973_b().getAttributeModifiers(equipmentSlot, this);
        }
        multimap.values().forEach(p_226631_0_ -> p_226631_0_.func_111168_a(false));
        return multimap;
    }

    public void func_185129_a(String attributeName, AttributeModifier modifier, @Nullable EquipmentSlotType equipmentSlot) {
        this.func_196082_o();
        if (!this.field_77990_d.func_150297_b("AttributeModifiers", 9)) {
            this.field_77990_d.func_218657_a("AttributeModifiers", (INBT)new ListNBT());
        }
        ListNBT listnbt = this.field_77990_d.func_150295_c("AttributeModifiers", 10);
        CompoundNBT compoundnbt = SharedMonsterAttributes.func_111262_a(modifier);
        compoundnbt.func_74778_a("AttributeName", attributeName);
        if (equipmentSlot != null) {
            compoundnbt.func_74778_a("Slot", equipmentSlot.func_188450_d());
        }
        listnbt.add((Object)compoundnbt);
    }

    public ITextComponent func_151000_E() {
        ITextComponent itextcomponent = new StringTextComponent("").func_150257_a(this.func_200301_q());
        if (this.func_82837_s()) {
            itextcomponent.func_211708_a(TextFormatting.ITALIC);
        }
        ITextComponent itextcomponent1 = TextComponentUtils.func_197676_a((ITextComponent)itextcomponent);
        if (!this.field_190928_g) {
            CompoundNBT compoundnbt = this.func_77955_b(new CompoundNBT());
            itextcomponent1.func_211708_a(this.func_77953_t().field_77937_e).func_211710_a(p_226632_1_ -> p_226632_1_.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_ITEM, (ITextComponent)new StringTextComponent(compoundnbt.toString()))));
        }
        return itextcomponent1;
    }

    private static boolean func_206846_a(CachedBlockInfo p_206846_0_, @Nullable CachedBlockInfo p_206846_1_) {
        if (p_206846_1_ != null && p_206846_0_.func_177509_a() == p_206846_1_.func_177509_a()) {
            if (p_206846_0_.func_177507_b() == null && p_206846_1_.func_177507_b() == null) {
                return true;
            }
            return p_206846_0_.func_177507_b() != null && p_206846_1_.func_177507_b() != null ? Objects.equals(p_206846_0_.func_177507_b().func_189515_b(new CompoundNBT()), p_206846_1_.func_177507_b().func_189515_b(new CompoundNBT())) : false;
        }
        return false;
    }

    public boolean func_206848_a(NetworkTagManager p_206848_1_, CachedBlockInfo p_206848_2_) {
        if (ItemStack.func_206846_a(p_206848_2_, this.field_179552_h)) {
            return this.field_179553_i;
        }
        this.field_179552_h = p_206848_2_;
        if (this.func_77942_o() && this.field_77990_d.func_150297_b("CanDestroy", 9)) {
            ListNBT listnbt = this.field_77990_d.func_150295_c("CanDestroy", 8);
            for (int i = 0; i < listnbt.size(); ++i) {
                String s = listnbt.func_150307_f(i);
                try {
                    Predicate predicate = BlockPredicateArgument.func_199824_a().parse(new StringReader(s)).create(p_206848_1_);
                    if (predicate.test(p_206848_2_)) {
                        this.field_179553_i = true;
                        return true;
                    }
                    continue;
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
            }
        }
        this.field_179553_i = false;
        return false;
    }

    public boolean func_206847_b(NetworkTagManager p_206847_1_, CachedBlockInfo p_206847_2_) {
        if (ItemStack.func_206846_a(p_206847_2_, this.field_179550_j)) {
            return this.field_179551_k;
        }
        this.field_179550_j = p_206847_2_;
        if (this.func_77942_o() && this.field_77990_d.func_150297_b("CanPlaceOn", 9)) {
            ListNBT listnbt = this.field_77990_d.func_150295_c("CanPlaceOn", 8);
            for (int i = 0; i < listnbt.size(); ++i) {
                String s = listnbt.func_150307_f(i);
                try {
                    Predicate predicate = BlockPredicateArgument.func_199824_a().parse(new StringReader(s)).create(p_206847_1_);
                    if (predicate.test(p_206847_2_)) {
                        this.field_179551_k = true;
                        return true;
                    }
                    continue;
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
            }
        }
        this.field_179551_k = false;
        return false;
    }

    public int func_190921_D() {
        return this.field_77992_b;
    }

    public void func_190915_d(int animations) {
        this.field_77992_b = animations;
    }

    public int func_190916_E() {
        return this.field_190928_g ? 0 : this.field_77994_a;
    }

    public void func_190920_e(int count) {
        this.field_77994_a = count;
        this.func_190923_F();
    }

    public void func_190917_f(int count) {
        this.func_190920_e(this.field_77994_a + count);
    }

    public void func_190918_g(int count) {
        this.func_190917_f(-count);
    }

    public void func_222121_b(World worldIn, LivingEntity livingEntityIn, int countIn) {
        this.func_77973_b().func_219972_a(worldIn, livingEntityIn, this, countIn);
    }

    public boolean func_222117_E() {
        return this.func_77973_b().func_219971_r();
    }

    public void deserializeNBT(CompoundNBT nbt) {
        ItemStack itemStack = ItemStack.func_199557_a(nbt);
        this.getStack().func_77982_d(itemStack.func_77978_p());
        if (itemStack.capNBT != null) {
            this.deserializeCaps(itemStack.capNBT);
        }
    }

    private void forgeInit() {
        Item item = this.getItemRaw();
        if (item != null) {
            this.delegate = item.delegate;
            ICapabilityProvider provider = item.initCapabilities(this, this.capNBT);
            this.gatherCapabilities(provider);
            if (this.capNBT != null) {
                this.deserializeCaps(this.capNBT);
            }
        }
    }

    @Nullable
    private Item getItemRaw() {
        return this.field_151002_e;
    }

    public SoundEvent func_226629_F_() {
        return this.func_77973_b().func_225520_U__();
    }

    public SoundEvent func_226630_G_() {
        return this.func_77973_b().func_225519_S__();
    }
}

