/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CommandBlockBlock;
import net.minecraft.block.JigsawBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.StructureBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.util.ClientRecipeBook;
import net.minecraft.client.util.PosAndRotation;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CClickWindowPacket;
import net.minecraft.network.play.client.CCreativeInventoryActionPacket;
import net.minecraft.network.play.client.CEnchantItemPacket;
import net.minecraft.network.play.client.CHeldItemChangePacket;
import net.minecraft.network.play.client.CPickItemPacket;
import net.minecraft.network.play.client.CPlaceRecipePacket;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.network.play.client.CPlayerTryUseItemOnBlockPacket;
import net.minecraft.network.play.client.CPlayerTryUseItemPacket;
import net.minecraft.network.play.client.CUseEntityPacket;
import net.minecraft.stats.StatisticsManager;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class PlayerController {
    private static final Logger field_225325_a = LogManager.getLogger();
    private final Minecraft field_78776_a;
    private final ClientPlayNetHandler field_78774_b;
    private BlockPos field_178895_c = new BlockPos(-1, -1, -1);
    private ItemStack field_85183_f = ItemStack.field_190927_a;
    private float field_78770_f;
    private float field_78780_h;
    private int field_78781_i;
    private boolean field_78778_j;
    private GameType field_78779_k = GameType.SURVIVAL;
    private final Object2ObjectLinkedOpenHashMap<Pair<BlockPos, CPlayerDiggingPacket.Action>, PosAndRotation> field_225326_k = new Object2ObjectLinkedOpenHashMap();
    private int field_78777_l;

    public PlayerController(Minecraft mcIn, ClientPlayNetHandler netHandler) {
        this.field_78776_a = mcIn;
        this.field_78774_b = netHandler;
    }

    public static void func_178891_a(Minecraft mcIn, PlayerController playerController, BlockPos pos, Direction facing) {
        if (!mcIn.field_71441_e.func_175719_a(mcIn.field_71439_g, pos, facing)) {
            playerController.func_187103_a(pos);
        }
    }

    public void func_78748_a(PlayerEntity player) {
        this.field_78779_k.func_77147_a(player.field_71075_bZ);
    }

    public void func_78746_a(GameType type) {
        this.field_78779_k = type;
        this.field_78779_k.func_77147_a(this.field_78776_a.field_71439_g.field_71075_bZ);
    }

    public boolean func_78755_b() {
        return this.field_78779_k.func_77144_e();
    }

    public boolean func_187103_a(BlockPos pos) {
        if (this.field_78776_a.field_71439_g.func_184614_ca().onBlockStartBreak(pos, this.field_78776_a.field_71439_g)) {
            return false;
        }
        if (this.field_78776_a.field_71439_g.func_223729_a(this.field_78776_a.field_71441_e, pos, this.field_78779_k)) {
            return false;
        }
        ClientWorld world = this.field_78776_a.field_71441_e;
        BlockState blockstate = world.func_180495_p(pos);
        if (!this.field_78776_a.field_71439_g.func_184614_ca().func_77973_b().func_195938_a(blockstate, world, pos, this.field_78776_a.field_71439_g)) {
            return false;
        }
        Block block = blockstate.func_177230_c();
        if ((block instanceof CommandBlockBlock || block instanceof StructureBlock || block instanceof JigsawBlock) && !this.field_78776_a.field_71439_g.func_195070_dx()) {
            return false;
        }
        if (blockstate.isAir((IBlockReader)((Object)world), pos)) {
            return false;
        }
        block.func_176208_a(world, pos, blockstate, this.field_78776_a.field_71439_g);
        IFluidState ifluidstate = world.func_204610_c(pos);
        boolean flag = world.func_180501_a(pos, ifluidstate.func_206883_i(), 11);
        if (flag) {
            block.func_176206_d(world, pos, blockstate);
        }
        return flag;
    }

    public boolean func_180511_b(BlockPos loc, Direction face) {
        if (this.field_78776_a.field_71439_g.func_223729_a(this.field_78776_a.field_71441_e, loc, this.field_78779_k)) {
            return false;
        }
        if (!this.field_78776_a.field_71441_e.func_175723_af().func_177746_a(loc)) {
            return false;
        }
        if (this.field_78779_k.func_77145_d()) {
            BlockState blockstate = this.field_78776_a.field_71441_e.func_180495_p(loc);
            this.field_78776_a.func_193032_ao().func_193294_a(this.field_78776_a.field_71441_e, loc, blockstate, 1.0f);
            this.func_225324_a(CPlayerDiggingPacket.Action.START_DESTROY_BLOCK, loc, face);
            if (!ForgeHooks.onLeftClickBlock((PlayerEntity)this.field_78776_a.field_71439_g, (BlockPos)loc, (Direction)face).isCanceled()) {
                PlayerController.func_178891_a(this.field_78776_a, this, loc, face);
            }
            this.field_78781_i = 5;
        } else if (!this.field_78778_j || !this.func_178893_a(loc)) {
            boolean flag;
            if (this.field_78778_j) {
                this.func_225324_a(CPlayerDiggingPacket.Action.ABORT_DESTROY_BLOCK, this.field_178895_c, face);
            }
            PlayerInteractEvent.LeftClickBlock event = ForgeHooks.onLeftClickBlock((PlayerEntity)this.field_78776_a.field_71439_g, (BlockPos)loc, (Direction)face);
            BlockState blockstate1 = this.field_78776_a.field_71441_e.func_180495_p(loc);
            this.field_78776_a.func_193032_ao().func_193294_a(this.field_78776_a.field_71441_e, loc, blockstate1, 0.0f);
            this.func_225324_a(CPlayerDiggingPacket.Action.START_DESTROY_BLOCK, loc, face);
            boolean bl = flag = !blockstate1.isAir((IBlockReader)((Object)this.field_78776_a.field_71441_e), loc);
            if (flag && this.field_78770_f == 0.0f && event.getUseBlock() != Event.Result.DENY) {
                blockstate1.func_196942_a(this.field_78776_a.field_71441_e, loc, this.field_78776_a.field_71439_g);
            }
            if (event.getUseItem() == Event.Result.DENY) {
                return true;
            }
            if (flag && blockstate1.func_185903_a(this.field_78776_a.field_71439_g, (IBlockReader)((Object)this.field_78776_a.field_71439_g.field_70170_p), loc) >= 1.0f) {
                this.func_187103_a(loc);
            } else {
                this.field_78778_j = true;
                this.field_178895_c = loc;
                this.field_85183_f = this.field_78776_a.field_71439_g.func_184614_ca();
                this.field_78770_f = 0.0f;
                this.field_78780_h = 0.0f;
                this.field_78776_a.field_71441_e.func_175715_c(this.field_78776_a.field_71439_g.func_145782_y(), this.field_178895_c, (int)(this.field_78770_f * 10.0f) - 1);
            }
        }
        return true;
    }

    public void func_78767_c() {
        if (this.field_78778_j) {
            BlockState blockstate = this.field_78776_a.field_71441_e.func_180495_p(this.field_178895_c);
            this.field_78776_a.func_193032_ao().func_193294_a(this.field_78776_a.field_71441_e, this.field_178895_c, blockstate, -1.0f);
            this.func_225324_a(CPlayerDiggingPacket.Action.ABORT_DESTROY_BLOCK, this.field_178895_c, Direction.DOWN);
            this.field_78778_j = false;
            this.field_78770_f = 0.0f;
            this.field_78776_a.field_71441_e.func_175715_c(this.field_78776_a.field_71439_g.func_145782_y(), this.field_178895_c, -1);
            this.field_78776_a.field_71439_g.func_184821_cY();
        }
    }

    public boolean func_180512_c(BlockPos posBlock, Direction directionFacing) {
        this.func_78750_j();
        if (this.field_78781_i > 0) {
            --this.field_78781_i;
            return true;
        }
        if (this.field_78779_k.func_77145_d() && this.field_78776_a.field_71441_e.func_175723_af().func_177746_a(posBlock)) {
            this.field_78781_i = 5;
            BlockState blockstate1 = this.field_78776_a.field_71441_e.func_180495_p(posBlock);
            this.field_78776_a.func_193032_ao().func_193294_a(this.field_78776_a.field_71441_e, posBlock, blockstate1, 1.0f);
            this.func_225324_a(CPlayerDiggingPacket.Action.START_DESTROY_BLOCK, posBlock, directionFacing);
            if (!ForgeHooks.onLeftClickBlock((PlayerEntity)this.field_78776_a.field_71439_g, (BlockPos)posBlock, (Direction)directionFacing).isCanceled()) {
                PlayerController.func_178891_a(this.field_78776_a, this, posBlock, directionFacing);
            }
            return true;
        }
        if (this.func_178893_a(posBlock)) {
            BlockState blockstate = this.field_78776_a.field_71441_e.func_180495_p(posBlock);
            if (blockstate.isAir((IBlockReader)((Object)this.field_78776_a.field_71441_e), posBlock)) {
                this.field_78778_j = false;
                return false;
            }
            this.field_78770_f += blockstate.func_185903_a(this.field_78776_a.field_71439_g, (IBlockReader)((Object)this.field_78776_a.field_71439_g.field_70170_p), posBlock);
            if (this.field_78780_h % 4.0f == 0.0f) {
                SoundType soundtype = blockstate.getSoundType(this.field_78776_a.field_71441_e, posBlock, this.field_78776_a.field_71439_g);
                this.field_78776_a.func_147118_V().func_147682_a((ISound)new SimpleSound(soundtype.func_185846_f(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 8.0f, soundtype.func_185847_b() * 0.5f, posBlock));
            }
            this.field_78780_h += 1.0f;
            this.field_78776_a.func_193032_ao().func_193294_a(this.field_78776_a.field_71441_e, posBlock, blockstate, MathHelper.func_76131_a((float)this.field_78770_f, (float)0.0f, (float)1.0f));
            if (ForgeHooks.onLeftClickBlock((PlayerEntity)this.field_78776_a.field_71439_g, (BlockPos)posBlock, (Direction)directionFacing).getUseItem() == Event.Result.DENY) {
                return true;
            }
            if (this.field_78770_f >= 1.0f) {
                this.field_78778_j = false;
                this.func_225324_a(CPlayerDiggingPacket.Action.STOP_DESTROY_BLOCK, posBlock, directionFacing);
                this.func_187103_a(posBlock);
                this.field_78770_f = 0.0f;
                this.field_78780_h = 0.0f;
                this.field_78781_i = 5;
            }
            this.field_78776_a.field_71441_e.func_175715_c(this.field_78776_a.field_71439_g.func_145782_y(), this.field_178895_c, (int)(this.field_78770_f * 10.0f) - 1);
            return true;
        }
        return this.func_180511_b(posBlock, directionFacing);
    }

    public float func_78757_d() {
        float attrib = (float)this.field_78776_a.field_71439_g.func_110148_a(PlayerEntity.REACH_DISTANCE).func_111126_e();
        return this.field_78779_k.func_77145_d() ? attrib : attrib - 0.5f;
    }

    public void func_78765_e() {
        this.func_78750_j();
        if (this.field_78774_b.func_147298_b().func_150724_d()) {
            this.field_78774_b.func_147298_b().func_74428_b();
        } else {
            this.field_78774_b.func_147298_b().func_179293_l();
        }
    }

    private boolean func_178893_a(BlockPos pos) {
        boolean flag;
        ItemStack itemstack = this.field_78776_a.field_71439_g.func_184614_ca();
        boolean bl = flag = this.field_85183_f.func_190926_b() && itemstack.func_190926_b();
        if (!this.field_85183_f.func_190926_b() && !itemstack.func_190926_b()) {
            flag = !this.field_85183_f.shouldCauseBlockBreakReset(itemstack);
        }
        return pos.equals((Object)this.field_178895_c) && flag;
    }

    private void func_78750_j() {
        int i = this.field_78776_a.field_71439_g.field_71071_by.field_70461_c;
        if (i != this.field_78777_l) {
            this.field_78777_l = i;
            this.field_78774_b.func_147297_a((IPacket<?>)new CHeldItemChangePacket(this.field_78777_l));
        }
    }

    public ActionResultType func_217292_a(ClientPlayerEntity p_217292_1_, ClientWorld p_217292_2_, Hand p_217292_3_, BlockRayTraceResult p_217292_4_) {
        ActionResultType actionresulttype;
        boolean flag1;
        ActionResultType result;
        this.func_78750_j();
        BlockPos blockpos = p_217292_4_.func_216350_a();
        if (!this.field_78776_a.field_71441_e.func_175723_af().func_177746_a(blockpos)) {
            return ActionResultType.FAIL;
        }
        ItemStack itemstack = p_217292_1_.func_184586_b(p_217292_3_);
        PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((PlayerEntity)p_217292_1_, (Hand)p_217292_3_, (BlockPos)blockpos, (Direction)p_217292_4_.func_216354_b());
        if (event.isCanceled()) {
            this.field_78774_b.func_147297_a((IPacket<?>)new CPlayerTryUseItemOnBlockPacket(p_217292_3_, p_217292_4_));
            return event.getCancellationResult();
        }
        if (this.field_78779_k == GameType.SPECTATOR) {
            this.field_78774_b.func_147297_a((IPacket<?>)new CPlayerTryUseItemOnBlockPacket(p_217292_3_, p_217292_4_));
            return ActionResultType.SUCCESS;
        }
        ItemUseContext itemusecontext = new ItemUseContext((PlayerEntity)p_217292_1_, p_217292_3_, p_217292_4_);
        if (event.getUseItem() != Event.Result.DENY && (result = itemstack.onItemUseFirst(itemusecontext)) != ActionResultType.PASS) {
            this.field_78774_b.func_147297_a((IPacket<?>)new CPlayerTryUseItemOnBlockPacket(p_217292_3_, p_217292_4_));
            return result;
        }
        boolean flag = !p_217292_1_.func_184614_ca().doesSneakBypassUse(p_217292_2_, blockpos, p_217292_1_) || !p_217292_1_.func_184592_cb().doesSneakBypassUse(p_217292_2_, blockpos, p_217292_1_);
        boolean bl = flag1 = p_217292_1_.func_226563_dT_() && flag;
        if (event.getUseBlock() != Event.Result.DENY && !flag1 && (actionresulttype = p_217292_2_.func_180495_p(blockpos).func_227031_a_(p_217292_2_, p_217292_1_, p_217292_3_, p_217292_4_)).func_226246_a_()) {
            this.field_78774_b.func_147297_a((IPacket<?>)new CPlayerTryUseItemOnBlockPacket(p_217292_3_, p_217292_4_));
            return actionresulttype;
        }
        this.field_78774_b.func_147297_a((IPacket<?>)new CPlayerTryUseItemOnBlockPacket(p_217292_3_, p_217292_4_));
        if (event.getUseItem() == Event.Result.DENY) {
            return ActionResultType.PASS;
        }
        if (!itemstack.func_190926_b() && !p_217292_1_.func_184811_cZ().func_185141_a(itemstack.func_77973_b())) {
            ActionResultType actionresulttype1;
            if (this.field_78779_k.func_77145_d()) {
                int i = itemstack.func_190916_E();
                actionresulttype1 = itemstack.func_196084_a(itemusecontext);
                itemstack.func_190920_e(i);
            } else {
                actionresulttype1 = itemstack.func_196084_a(itemusecontext);
            }
            return actionresulttype1;
        }
        return ActionResultType.PASS;
    }

    public ActionResultType func_187101_a(PlayerEntity player, World worldIn, Hand hand) {
        if (this.field_78779_k == GameType.SPECTATOR) {
            return ActionResultType.PASS;
        }
        this.func_78750_j();
        this.field_78774_b.func_147297_a((IPacket<?>)new CPlayerTryUseItemPacket(hand));
        ItemStack itemstack = player.func_184586_b(hand);
        if (player.func_184811_cZ().func_185141_a(itemstack.func_77973_b())) {
            return ActionResultType.PASS;
        }
        ActionResultType cancelResult = ForgeHooks.onItemRightClick((PlayerEntity)player, (Hand)hand);
        if (cancelResult != null) {
            return cancelResult;
        }
        int i = itemstack.func_190916_E();
        ActionResult<ItemStack> actionresult = itemstack.func_77957_a(worldIn, player, hand);
        ItemStack itemstack1 = (ItemStack)((Object)actionresult.func_188398_b());
        if (itemstack1 != itemstack || itemstack1.func_190916_E() != i) {
            player.func_184611_a(hand, itemstack1);
            if (itemstack1.func_190926_b()) {
                ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)player, (ItemStack)itemstack, (Hand)hand);
            }
        }
        return actionresult.func_188397_a();
    }

    public ClientPlayerEntity func_199681_a(ClientWorld p_199681_1_, StatisticsManager p_199681_2_, ClientRecipeBook p_199681_3_) {
        return new ClientPlayerEntity(this.field_78776_a, p_199681_1_, this.field_78774_b, p_199681_2_, p_199681_3_);
    }

    public void func_78764_a(PlayerEntity playerIn, Entity targetEntity) {
        this.func_78750_j();
        this.field_78774_b.func_147297_a((IPacket<?>)new CUseEntityPacket(targetEntity));
        if (this.field_78779_k != GameType.SPECTATOR) {
            playerIn.func_71059_n(targetEntity);
            playerIn.func_184821_cY();
        }
    }

    public ActionResultType func_187097_a(PlayerEntity player, Entity target, Hand hand) {
        this.func_78750_j();
        this.field_78774_b.func_147297_a((IPacket<?>)new CUseEntityPacket(target, hand));
        if (this.field_78779_k == GameType.SPECTATOR) {
            return ActionResultType.PASS;
        }
        ActionResultType cancelResult = ForgeHooks.onInteractEntity((PlayerEntity)player, (Entity)target, (Hand)hand);
        if (cancelResult != null) {
            return cancelResult;
        }
        return this.field_78779_k == GameType.SPECTATOR ? ActionResultType.PASS : player.func_190775_a(target, hand);
    }

    public ActionResultType func_187102_a(PlayerEntity player, Entity target, EntityRayTraceResult ray, Hand hand) {
        this.func_78750_j();
        Vec3d vec3d = ray.func_216347_e().func_178786_a(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
        this.field_78774_b.func_147297_a((IPacket<?>)new CUseEntityPacket(target, hand, vec3d));
        if (this.field_78779_k == GameType.SPECTATOR) {
            return ActionResultType.PASS;
        }
        ActionResultType cancelResult = ForgeHooks.onInteractEntityAt((PlayerEntity)player, (Entity)target, (RayTraceResult)ray, (Hand)hand);
        if (cancelResult != null) {
            return cancelResult;
        }
        return this.field_78779_k == GameType.SPECTATOR ? ActionResultType.PASS : target.func_184199_a(player, vec3d, hand);
    }

    public ItemStack func_187098_a(int windowId, int slotId, int mouseButton, ClickType type, PlayerEntity player) {
        short short1 = player.field_71070_bA.func_75136_a(player.field_71071_by);
        ItemStack itemstack = player.field_71070_bA.func_184996_a(slotId, mouseButton, type, player);
        this.field_78774_b.func_147297_a(new CClickWindowPacket(windowId, slotId, mouseButton, type, itemstack, short1));
        return itemstack;
    }

    public void func_203413_a(int p_203413_1_, IRecipe<?> p_203413_2_, boolean p_203413_3_) {
        this.field_78774_b.func_147297_a((IPacket<?>)new CPlaceRecipePacket(p_203413_1_, p_203413_2_, p_203413_3_));
    }

    public void func_78756_a(int windowID, int button) {
        this.field_78774_b.func_147297_a((IPacket<?>)new CEnchantItemPacket(windowID, button));
    }

    public void func_78761_a(ItemStack itemStackIn, int slotId) {
        if (this.field_78779_k.func_77145_d()) {
            this.field_78774_b.func_147297_a(new CCreativeInventoryActionPacket(slotId, itemStackIn));
        }
    }

    public void func_78752_a(ItemStack itemStackIn) {
        if (this.field_78779_k.func_77145_d() && !itemStackIn.func_190926_b()) {
            this.field_78774_b.func_147297_a(new CCreativeInventoryActionPacket(-1, itemStackIn));
        }
    }

    public void func_78766_c(PlayerEntity playerIn) {
        this.func_78750_j();
        this.field_78774_b.func_147297_a((IPacket<?>)new CPlayerDiggingPacket(CPlayerDiggingPacket.Action.RELEASE_USE_ITEM, BlockPos.field_177992_a, Direction.DOWN));
        playerIn.func_184597_cx();
    }

    public boolean func_78763_f() {
        return this.field_78779_k.func_77144_e();
    }

    public boolean func_78762_g() {
        return !this.field_78779_k.func_77145_d();
    }

    public boolean func_78758_h() {
        return this.field_78779_k.func_77145_d();
    }

    public boolean func_78749_i() {
        return this.field_78779_k.func_77145_d();
    }

    public boolean func_110738_j() {
        return this.field_78776_a.field_71439_g.func_184218_aH() && this.field_78776_a.field_71439_g.func_184187_bx() instanceof AbstractHorseEntity;
    }

    public boolean func_178887_k() {
        return this.field_78779_k == GameType.SPECTATOR;
    }

    public GameType func_178889_l() {
        return this.field_78779_k;
    }

    public boolean func_181040_m() {
        return this.field_78778_j;
    }

    public void func_187100_a(int index) {
        this.field_78774_b.func_147297_a((IPacket<?>)new CPickItemPacket(index));
    }

    private void func_225324_a(CPlayerDiggingPacket.Action p_225324_1_, BlockPos p_225324_2_, Direction p_225324_3_) {
        ClientPlayerEntity clientplayerentity = this.field_78776_a.field_71439_g;
        this.field_225326_k.put((Object)Pair.of((Object)p_225324_2_, (Object)p_225324_1_), (Object)new PosAndRotation(clientplayerentity.func_213303_ch(), clientplayerentity.field_70125_A, clientplayerentity.field_70177_z));
        this.field_78774_b.func_147297_a((IPacket<?>)new CPlayerDiggingPacket(p_225324_1_, p_225324_2_, p_225324_3_));
    }

    public void func_225323_a(ClientWorld p_225323_1_, BlockPos p_225323_2_, BlockState p_225323_3_, CPlayerDiggingPacket.Action p_225323_4_, boolean p_225323_5_) {
        PosAndRotation posandrotation = (PosAndRotation)this.field_225326_k.remove((Object)Pair.of((Object)p_225323_2_, (Object)p_225323_4_));
        if (posandrotation == null || !p_225323_5_ || p_225323_4_ != CPlayerDiggingPacket.Action.START_DESTROY_BLOCK && p_225323_1_.func_180495_p(p_225323_2_) != p_225323_3_) {
            p_225323_1_.func_195597_b(p_225323_2_, p_225323_3_);
            if (posandrotation != null) {
                Vec3d vec3d = posandrotation.func_224783_a();
                this.field_78776_a.field_71439_g.func_70080_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, posandrotation.func_224785_c(), posandrotation.func_224784_b());
            }
        }
        while (this.field_225326_k.size() >= 50) {
            Pair pair = (Pair)this.field_225326_k.firstKey();
            this.field_225326_k.removeFirst();
            field_225325_a.error("Too many unacked block actions, dropping " + pair);
        }
    }
}

