/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.lib;

import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.api.crop.CropTextures;
import com.blakebr0.mysticalagriculture.api.crop.CropTier;
import com.blakebr0.mysticalagriculture.api.crop.CropType;
import com.blakebr0.mysticalagriculture.api.crop.ICrop;
import com.blakebr0.mysticalagriculture.api.lib.LazyIngredient;
import com.blakebr0.mysticalagriculture.api.registry.ICropRegistry;
import com.blakebr0.mysticalagriculture.api.util.ExperienceCapsuleUtils;
import com.blakebr0.mysticalagriculture.api.util.MobSoulUtils;
import com.blakebr0.mysticalagriculture.block.ModBlocks;
import com.blakebr0.mysticalagriculture.item.ModItems;
import com.blakebr0.mysticalagriculture.lib.ModMobSoulTypes;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.block.CropsBlock;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;

public class ModCrops {
    private static final CropTextures ELEMENTAL_CROP_TEXTURES = new CropTextures(CropTextures.FLOWER_INGOT_BLANK, CropTextures.ESSENCE_FLAME_BLANK);
    private static final CropTextures ROCK_CROP_TEXTURES = new CropTextures(CropTextures.FLOWER_ROCK_BLANK, CropTextures.ESSENCE_ROCK_BLANK);
    private static final CropTextures INGOT_CROP_TEXTURES = new CropTextures(CropTextures.FLOWER_INGOT_BLANK, CropTextures.ESSENCE_INGOT_BLANK);
    private static final CropTextures DUST_CROP_TEXTURES = new CropTextures(CropTextures.FLOWER_DUST_BLANK, CropTextures.ESSENCE_DUST_BLANK);
    public static final Crop AIR = new Crop(new ResourceLocation("mysticalagriculture", "air"), CropTier.ELEMENTAL, CropType.RESOURCE, ELEMENTAL_CROP_TEXTURES, 14341709, LazyIngredient.item("mysticalagriculture:air_agglomeratio"));
    public static final Crop EARTH = new Crop(new ResourceLocation("mysticalagriculture", "earth"), CropTier.ELEMENTAL, CropType.RESOURCE, ELEMENTAL_CROP_TEXTURES, 5560909, LazyIngredient.item("mysticalagriculture:earth_agglomeratio"));
    public static final Crop WATER = new Crop(new ResourceLocation("mysticalagriculture", "water"), CropTier.ELEMENTAL, CropType.RESOURCE, ELEMENTAL_CROP_TEXTURES, 5078746, LazyIngredient.item("mysticalagriculture:water_agglomeratio"));
    public static final Crop FIRE = new Crop(new ResourceLocation("mysticalagriculture", "fire"), CropTier.ELEMENTAL, CropType.RESOURCE, ELEMENTAL_CROP_TEXTURES, 0xDA4D4D, LazyIngredient.item("mysticalagriculture:fire_agglomeratio"));
    public static final Crop INFERIUM = new Crop(new ResourceLocation("mysticalagriculture", "inferium"), CropTier.ONE, CropType.RESOURCE, LazyIngredient.EMPTY);
    public static final Crop STONE = new Crop(new ResourceLocation("mysticalagriculture", "stone"), CropTier.ONE, CropType.RESOURCE, ROCK_CROP_TEXTURES, 0x7F7F7F, LazyIngredient.tag("forge:stone"));
    public static final Crop DIRT = new Crop(new ResourceLocation("mysticalagriculture", "dirt"), CropTier.ONE, CropType.RESOURCE, LazyIngredient.item("minecraft:dirt"));
    public static final Crop WOOD = new Crop(new ResourceLocation("mysticalagriculture", "wood"), CropTier.ONE, CropType.RESOURCE, LazyIngredient.tag("minecraft:logs"));
    public static final Crop ICE = new Crop(new ResourceLocation("mysticalagriculture", "ice"), CropTier.ONE, CropType.RESOURCE, LazyIngredient.item("minecraft:ice"));
    public static final Crop NATURE = new Crop(new ResourceLocation("mysticalagriculture", "nature"), CropTier.TWO, CropType.RESOURCE, LazyIngredient.item("mysticalagriculture:nature_agglomeratio"));
    public static final Crop DYE = new Crop(new ResourceLocation("mysticalagriculture", "dye"), CropTier.TWO, CropType.RESOURCE, LazyIngredient.item("mysticalagriculture:dye_agglomeratio"));
    public static final Crop NETHER = new Crop(new ResourceLocation("mysticalagriculture", "nether"), CropTier.TWO, CropType.RESOURCE, ROCK_CROP_TEXTURES, 0x723232, LazyIngredient.item("mysticalagriculture:nether_agglomeratio"));
    public static final Crop COAL = new Crop(new ResourceLocation("mysticalagriculture", "coal"), CropTier.TWO, CropType.RESOURCE, LazyIngredient.item("minecraft:coal"));
    public static final Crop CORAL = new Crop(new ResourceLocation("mysticalagriculture", "coral"), CropTier.TWO, CropType.RESOURCE, LazyIngredient.item("mysticalagriculture:coral_agglomeratio"));
    public static final Crop PIG = new Crop(new ResourceLocation("mysticalagriculture", "pig"), CropTier.TWO, CropType.MOB, LazyIngredient.item("mysticalagriculture:soul_jar", MobSoulUtils.makeTag(ModMobSoulTypes.PIG_SOUL_TYPE)));
    public static final Crop CHICKEN = new Crop(new ResourceLocation("mysticalagriculture", "chicken"), CropTier.TWO, CropType.MOB, LazyIngredient.item("mysticalagriculture:soul_jar", MobSoulUtils.makeTag(ModMobSoulTypes.CHICKEN_SOUL_TYPE)));
    public static final Crop COW = new Crop(new ResourceLocation("mysticalagriculture", "cow"), CropTier.TWO, CropType.MOB, LazyIngredient.item("mysticalagriculture:soul_jar", MobSoulUtils.makeTag(ModMobSoulTypes.COW_SOUL_TYPE)));
    public static final Crop SHEEP = new Crop(new ResourceLocation("mysticalagriculture", "sheep"), CropTier.TWO, CropType.MOB, LazyIngredient.item("mysticalagriculture:soul_jar", MobSoulUtils.makeTag(ModMobSoulTypes.SHEEP_SOUL_TYPE)));
    public static final Crop SQUID = new Crop(new ResourceLocation("mysticalagriculture", "squid"), CropTier.TWO, CropType.MOB, LazyIngredient.item("mysticalagriculture:soul_jar", MobSoulUtils.makeTag(ModMobSoulTypes.SQUID_SOUL_TYPE)));
    public static final Crop FISH = new Crop(new ResourceLocation("mysticalagriculture", "fish"), CropTier.TWO, CropType.MOB, LazyIngredient.item("mysticalagriculture:soul_jar", MobSoulUtils.makeTag(ModMobSoulTypes.FISH_SOUL_TYPE)));
    public static final Crop SLIME = new Crop(new ResourceLocation("mysticalagriculture", "slime"), CropTier.TWO, CropType.MOB, LazyIngredient.item("mysticalagriculture:soul_jar", MobSoulUtils.makeTag(ModMobSoulTypes.SLIME_SOUL_TYPE)));
    public static final Crop TURTLE = new Crop(new ResourceLocation("mysticalagriculture", "turtle"), CropTier.TWO, CropType.MOB, LazyIngredient.item("mysticalagriculture:soul_jar", MobSoulUtils.makeTag(ModMobSoulTypes.TURTLE_SOUL_TYPE)));
    public static final Crop IRON = new Crop(new ResourceLocation("mysticalagriculture", "iron"), CropTier.THREE, CropType.RESOURCE, LazyIngredient.tag("forge:ingots/iron"));
    public static final Crop NETHER_QUARTZ = new Crop(new ResourceLocation("mysticalagriculture", "nether_quartz"), CropTier.THREE, CropType.RESOURCE, LazyIngredient.tag("forge:gems/quartz"));
    public static final Crop GLOWSTONE = new Crop(new ResourceLocation("mysticalagriculture", "glowstone"), CropTier.THREE, CropType.RESOURCE, LazyIngredient.tag("forge:dusts/glowstone"));
    public static final Crop REDSTONE = new Crop(new ResourceLocation("mysticalagriculture", "redstone"), CropTier.THREE, CropType.RESOURCE, LazyIngredient.tag("forge:dusts/redstone"));
    public static final Crop OBSIDIAN = new Crop(new ResourceLocation("mysticalagriculture", "obsidian"), CropTier.THREE, CropType.RESOURCE, ROCK_CROP_TEXTURES, 2563645, LazyIngredient.item("minecraft:obsidian"));
    public static final Crop PRISMARINE = new Crop(new ResourceLocation("mysticalagriculture", "prismarine"), CropTier.THREE, CropType.RESOURCE, LazyIngredient.item("mysticalagriculture:prismarine_agglomeratio"));
    public static final Crop ZOMBIE = new Crop(new ResourceLocation("mysticalagriculture", "zombie"), CropTier.THREE, CropType.MOB, LazyIngredient.item("mysticalagriculture:soul_jar", MobSoulUtils.makeTag(ModMobSoulTypes.ZOMBIE_SOUL_TYPE)));
    public static final Crop SKELETON = new Crop(new ResourceLocation("mysticalagriculture", "skeleton"), CropTier.THREE, CropType.MOB, LazyIngredient.item("mysticalagriculture:soul_jar", MobSoulUtils.makeTag(ModMobSoulTypes.SKELETON_SOUL_TYPE)));
    public static final Crop CREEPER = new Crop(new ResourceLocation("mysticalagriculture", "creeper"), CropTier.THREE, CropType.MOB, LazyIngredient.item("mysticalagriculture:soul_jar", MobSoulUtils.makeTag(ModMobSoulTypes.CREEPER_SOUL_TYPE)));
    public static final Crop SPIDER = new Crop(new ResourceLocation("mysticalagriculture", "spider"), CropTier.THREE, CropType.MOB, LazyIngredient.item("mysticalagriculture:soul_jar", MobSoulUtils.makeTag(ModMobSoulTypes.SPIDER_SOUL_TYPE)));
    public static final Crop RABBIT = new Crop(new ResourceLocation("mysticalagriculture", "rabbit"), CropTier.THREE, CropType.MOB, LazyIngredient.item("mysticalagriculture:soul_jar", MobSoulUtils.makeTag(ModMobSoulTypes.RABBIT_SOUL_TYPE)));
    public static final Crop GOLD = new Crop(new ResourceLocation("mysticalagriculture", "gold"), CropTier.FOUR, CropType.RESOURCE, LazyIngredient.tag("forge:ingots/gold"));
    public static final Crop LAPIS_LAZULI = new Crop(new ResourceLocation("mysticalagriculture", "lapis_lazuli"), CropTier.FOUR, CropType.RESOURCE, LazyIngredient.tag("forge:gems/lapis"));
    public static final Crop END = new Crop(new ResourceLocation("mysticalagriculture", "end"), CropTier.FOUR, CropType.RESOURCE, ROCK_CROP_TEXTURES, 15660724, LazyIngredient.item("mysticalagriculture:end_agglomeratio"));
    public static final Crop EXPERIENCE = new Crop(new ResourceLocation("mysticalagriculture", "experience"), CropTier.FOUR, CropType.RESOURCE, LazyIngredient.item("mysticalagriculture:experience_capsule", ExperienceCapsuleUtils.makeTag(1200)));
    public static final Crop BLAZE = new Crop(new ResourceLocation("mysticalagriculture", "blaze"), CropTier.FOUR, CropType.MOB, LazyIngredient.item("mysticalagriculture:soul_jar", MobSoulUtils.makeTag(ModMobSoulTypes.BLAZE_SOUL_TYPE)));
    public static final Crop GHAST = new Crop(new ResourceLocation("mysticalagriculture", "ghast"), CropTier.FOUR, CropType.MOB, LazyIngredient.item("mysticalagriculture:soul_jar", MobSoulUtils.makeTag(ModMobSoulTypes.GHAST_SOUL_TYPE)));
    public static final Crop ENDERMAN = new Crop(new ResourceLocation("mysticalagriculture", "enderman"), CropTier.FOUR, CropType.MOB, LazyIngredient.item("mysticalagriculture:soul_jar", MobSoulUtils.makeTag(ModMobSoulTypes.ENDERMAN_SOUL_TYPE)));
    public static final Crop DIAMOND = new Crop(new ResourceLocation("mysticalagriculture", "diamond"), CropTier.FIVE, CropType.RESOURCE, LazyIngredient.tag("forge:gems/diamond"));
    public static final Crop EMERALD = new Crop(new ResourceLocation("mysticalagriculture", "emerald"), CropTier.FIVE, CropType.RESOURCE, LazyIngredient.tag("forge:gems/emerald"));
    public static final Crop WITHER_SKELETON = new Crop(new ResourceLocation("mysticalagriculture", "wither_skeleton"), CropTier.FIVE, CropType.MOB, LazyIngredient.item("mysticalagriculture:soul_jar", MobSoulUtils.makeTag(ModMobSoulTypes.WITHER_SKELETON_SOUL_TYPE)));
    public static final Crop RUBBER = new Crop(new ResourceLocation("mysticalagriculture", "rubber"), CropTier.TWO, CropType.RESOURCE, LazyIngredient.tag("forge:rubber"));
    public static final Crop SILICON = new Crop(new ResourceLocation("mysticalagriculture", "silicon"), CropTier.TWO, CropType.RESOURCE, LazyIngredient.tag("forge:silicon"));
    public static final Crop SULFUR = new Crop(new ResourceLocation("mysticalagriculture", "sulfur"), CropTier.TWO, CropType.RESOURCE, DUST_CROP_TEXTURES, 16637003, LazyIngredient.tag("forge:dusts/sulfur"));
    public static final Crop ALUMINUM = new Crop(new ResourceLocation("mysticalagriculture", "aluminum"), CropTier.TWO, CropType.RESOURCE, INGOT_CROP_TEXTURES, 10790577, LazyIngredient.tag("forge:ingots/aluminum"));
    public static final Crop COPPER = new Crop(new ResourceLocation("mysticalagriculture", "copper"), CropTier.TWO, CropType.RESOURCE, INGOT_CROP_TEXTURES, 16025346, LazyIngredient.tag("forge:ingots/copper"));
    public static final Crop SALTPETER = new Crop(new ResourceLocation("mysticalagriculture", "saltpeter"), CropTier.TWO, CropType.RESOURCE, DUST_CROP_TEXTURES, 13221565, LazyIngredient.tag("forge:dusts/saltpeter"));
    public static final Crop TIN = new Crop(new ResourceLocation("mysticalagriculture", "tin"), CropTier.THREE, CropType.RESOURCE, INGOT_CROP_TEXTURES, 10141142, LazyIngredient.tag("forge:ingots/tin"));
    public static final Crop BRONZE = new Crop(new ResourceLocation("mysticalagriculture", "bronze"), CropTier.THREE, CropType.RESOURCE, INGOT_CROP_TEXTURES, 13208658, LazyIngredient.tag("forge:ingots/bronze"));
    public static final Crop ZINC = new Crop(new ResourceLocation("mysticalagriculture", "zinc"), CropTier.THREE, CropType.RESOURCE, INGOT_CROP_TEXTURES, 15330279, LazyIngredient.tag("forge:ingots/zinc"));
    public static final Crop BRASS = new Crop(new ResourceLocation("mysticalagriculture", "brass"), CropTier.THREE, CropType.RESOURCE, INGOT_CROP_TEXTURES, 14330444, LazyIngredient.tag("forge:ingots/brass"));
    public static final Crop SILVER = new Crop(new ResourceLocation("mysticalagriculture", "silver"), CropTier.THREE, CropType.RESOURCE, INGOT_CROP_TEXTURES, 11131877, LazyIngredient.tag("forge:ingots/silver"));
    public static final Crop LEAD = new Crop(new ResourceLocation("mysticalagriculture", "lead"), CropTier.THREE, CropType.RESOURCE, INGOT_CROP_TEXTURES, 6779283, LazyIngredient.tag("forge:ingots/lead"));
    public static final Crop GRAPHITE = new Crop(new ResourceLocation("mysticalagriculture", "graphite"), CropTier.THREE, CropType.RESOURCE, INGOT_CROP_TEXTURES, 0x545454, LazyIngredient.tag("forge:ingots/graphite"));
    public static final Crop STEEL = new Crop(new ResourceLocation("mysticalagriculture", "steel"), CropTier.FOUR, CropType.RESOURCE, INGOT_CROP_TEXTURES, 0x737373, LazyIngredient.tag("forge:ingots/steel"));
    public static final Crop NICKEL = new Crop(new ResourceLocation("mysticalagriculture", "nickel"), CropTier.FOUR, CropType.RESOURCE, INGOT_CROP_TEXTURES, 14208147, LazyIngredient.tag("forge:ingots/nickel"));
    public static final Crop CONSTANTAN = new Crop(new ResourceLocation("mysticalagriculture", "constantan"), CropTier.FOUR, CropType.RESOURCE, INGOT_CROP_TEXTURES, 14065738, LazyIngredient.tag("forge:ingots/constantan"));
    public static final Crop ELECTRUM = new Crop(new ResourceLocation("mysticalagriculture", "electrum"), CropTier.FOUR, CropType.RESOURCE, INGOT_CROP_TEXTURES, 14007119, LazyIngredient.tag("forge:ingots/electrum"));
    public static final Crop INVAR = new Crop(new ResourceLocation("mysticalagriculture", "invar"), CropTier.FOUR, CropType.RESOURCE, INGOT_CROP_TEXTURES, 11384754, LazyIngredient.tag("forge:ingots/invar"));
    public static final Crop MITHRIL = new Crop(new ResourceLocation("mysticalagriculture", "mithril"), CropTier.FOUR, CropType.RESOURCE, INGOT_CROP_TEXTURES, 6658747, LazyIngredient.tag("forge:ingots/mithril"));
    public static final Crop TUNGSTEN = new Crop(new ResourceLocation("mysticalagriculture", "tungsten"), CropTier.FOUR, CropType.RESOURCE, INGOT_CROP_TEXTURES, 0x616669, LazyIngredient.tag("forge:ingots/tungsten"));
    public static final Crop TITANIUM = new Crop(new ResourceLocation("mysticalagriculture", "titanium"), CropTier.FOUR, CropType.RESOURCE, INGOT_CROP_TEXTURES, 13685210, LazyIngredient.tag("forge:ingots/titanium"));
    public static final Crop URANIUM = new Crop(new ResourceLocation("mysticalagriculture", "uranium"), CropTier.FOUR, CropType.RESOURCE, INGOT_CROP_TEXTURES, 6336017, LazyIngredient.tag("forge:ingots/uranium"));
    public static final Crop CHROME = new Crop(new ResourceLocation("mysticalagriculture", "chrome"), CropTier.FOUR, CropType.RESOURCE, INGOT_CROP_TEXTURES, 13482429, LazyIngredient.tag("forge:ingots/chrome"));
    public static final Crop PLATINUM = new Crop(new ResourceLocation("mysticalagriculture", "platinum"), CropTier.TWO, CropType.RESOURCE, INGOT_CROP_TEXTURES, 7334639, LazyIngredient.tag("forge:ingots/platinum"));
    public static final Crop IRIDIUM = new Crop(new ResourceLocation("mysticalagriculture", "iridium"), CropTier.TWO, CropType.RESOURCE, INGOT_CROP_TEXTURES, 13092316, LazyIngredient.tag("forge:ingots/iridium"));
    public static final Crop MYSTICAL_FLOWER = new Crop(new ResourceLocation("mysticalagriculture", "mystical_flower"), CropTier.TWO, CropType.RESOURCE, LazyIngredient.EMPTY);
    public static final Crop MANASTEEL = new Crop(new ResourceLocation("mysticalagriculture", "manasteel"), CropTier.THREE, CropType.RESOURCE, LazyIngredient.item("botania:manasteel_ingot"));
    public static final Crop ELEMENTIUM = new Crop(new ResourceLocation("mysticalagriculture", "elementium"), CropTier.FOUR, CropType.RESOURCE, LazyIngredient.item("botania:elementium_ingot"));
    public static final Crop TERRASTEEL = new Crop(new ResourceLocation("mysticalagriculture", "terrasteel"), CropTier.FIVE, CropType.RESOURCE, LazyIngredient.item("botania:terrasteel_ingot"));
    public static final Crop OSMIUM = new Crop(new ResourceLocation("mysticalagriculture", "osmium"), CropTier.FOUR, CropType.RESOURCE, LazyIngredient.tag("forge:ingots/osmium"));
    public static final Crop REFINED_GLOWSTONE = new Crop(new ResourceLocation("mysticalagriculture", "refined_glowstone"), CropTier.FOUR, CropType.RESOURCE, LazyIngredient.tag("forge:ingots/refined_glowstone"));
    public static final Crop REFINED_OBSIDIAN = new Crop(new ResourceLocation("mysticalagriculture", "refined_obsidian"), CropTier.FOUR, CropType.RESOURCE, LazyIngredient.tag("forge:ingots/refined_obsidian"));
    public static final Crop ENDER_BIOTITE = new Crop(new ResourceLocation("mysticalagriculture", "ender_biotite"), CropTier.THREE, CropType.RESOURCE, LazyIngredient.item("quark:biotite"));
    public static final Crop QUARTZ_ENRICHED_IRON = new Crop(new ResourceLocation("mysticalagriculture", "quartz_enriched_iron"), CropTier.THREE, CropType.RESOURCE, LazyIngredient.item("refinedstorage:quartz_enriched_iron"));

    public static void onRegisterCrops(ICropRegistry registry) {
        INFERIUM.setCrop((Supplier<? extends CropsBlock>)ModBlocks.INFERIUM_CROP).setEssence((Supplier<? extends Item>)ModItems.INFERIUM_ESSENCE);
        registry.register(AIR);
        registry.register(EARTH);
        registry.register(WATER);
        registry.register(FIRE);
        registry.register(INFERIUM);
        registry.register(STONE);
        registry.register(DIRT);
        registry.register(WOOD);
        registry.register(ICE);
        registry.register(NATURE);
        registry.register(DYE);
        registry.register(NETHER);
        registry.register(COAL);
        registry.register(CORAL);
        registry.register(PIG);
        registry.register(CHICKEN);
        registry.register(COW);
        registry.register(SHEEP);
        registry.register(SQUID);
        registry.register(FISH);
        registry.register(SLIME);
        registry.register(TURTLE);
        registry.register(IRON);
        registry.register(NETHER_QUARTZ);
        registry.register(GLOWSTONE);
        registry.register(REDSTONE);
        registry.register(OBSIDIAN);
        registry.register(PRISMARINE);
        registry.register(ZOMBIE);
        registry.register(SKELETON);
        registry.register(CREEPER);
        registry.register(SPIDER);
        registry.register(RABBIT);
        registry.register(GOLD);
        registry.register(LAPIS_LAZULI);
        registry.register(END);
        registry.register(EXPERIENCE);
        registry.register(BLAZE);
        registry.register(GHAST);
        registry.register(ENDERMAN);
        registry.register(DIAMOND);
        registry.register(EMERALD);
        registry.register(WITHER_SKELETON);
        registry.register(RUBBER);
        registry.register(SILICON);
        registry.register(SULFUR);
        registry.register(ALUMINUM);
        registry.register(COPPER);
        registry.register(SALTPETER);
        registry.register(TIN);
        registry.register(BRONZE);
        registry.register(ZINC);
        registry.register(BRASS);
        registry.register(SILVER);
        registry.register(LEAD);
        registry.register(GRAPHITE);
        registry.register(STEEL);
        registry.register(NICKEL);
        registry.register(CONSTANTAN);
        registry.register(ELECTRUM);
        registry.register(INVAR);
        registry.register(MITHRIL);
        registry.register(TUNGSTEN);
        registry.register(TITANIUM);
        registry.register(URANIUM);
        registry.register(CHROME);
        registry.register(PLATINUM);
        registry.register(IRIDIUM);
        registry.register(ModCrops.withRequiredMods(MYSTICAL_FLOWER, "botania"));
        registry.register(ModCrops.withRequiredMods(MANASTEEL, "botania"));
        registry.register(ModCrops.withRequiredMods(ELEMENTIUM, "botania"));
        registry.register(ModCrops.withRequiredMods(TERRASTEEL, "botania"));
        registry.register(ModCrops.withRequiredMods(OSMIUM, "mekanism"));
        registry.register(ModCrops.withRequiredMods(REFINED_GLOWSTONE, "mekanism"));
        registry.register(ModCrops.withRequiredMods(REFINED_OBSIDIAN, "mekanism"));
        registry.register(ModCrops.withRequiredMods(ENDER_BIOTITE, "quark"));
        registry.register(ModCrops.withRequiredMods(QUARTZ_ENRICHED_IRON, "refinedstorage"));
    }

    private static ICrop withRequiredMods(ICrop crop, String ... mods) {
        boolean enabled = Arrays.stream(mods).anyMatch(arg_0 -> ((ModList)ModList.get()).isLoaded(arg_0));
        return crop.setEnabled(enabled);
    }
}

