/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.block.redstone.graph;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Iterator;
import me.jellysquid.mods.lithium.common.block.redstone.RedstoneBlockAccess;
import me.jellysquid.mods.lithium.common.block.redstone.graph.UpdateNode;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class UpdateGraph
implements Iterable<UpdateNode> {
    private final World world;
    private final Long2ObjectOpenHashMap<UpdateNode> nodesByPosition = new Long2ObjectOpenHashMap();
    private final RedstoneBlockAccess blockAccess;

    public UpdateGraph(World world) {
        this.world = world;
        this.blockAccess = new RedstoneBlockAccess(world);
    }

    public UpdateNode get(BlockPos pos) {
        return (UpdateNode)this.nodesByPosition.get(pos.func_218275_a());
    }

    public UpdateNode getOrCreateNode(BlockPos pos) {
        return (UpdateNode)this.nodesByPosition.computeIfAbsent(pos.func_218275_a(), id -> new UpdateNode(this, BlockPos.func_218283_e((long)id)));
    }

    public World getWorld() {
        return this.world;
    }

    public RedstoneBlockAccess getBlockAccess() {
        return this.blockAccess;
    }

    @Override
    public Iterator<UpdateNode> iterator() {
        return this.nodesByPosition.values().iterator();
    }

    public void clear() {
        this.nodesByPosition.clear();
        this.blockAccess.clear();
    }
}

