/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.container;

import java.util.Objects;
import java.util.function.Predicate;
import mcjty.lib.container.SlotType;
import net.minecraft.item.ItemStack;

public class SlotDefinition {
    private final SlotType type;
    private final Predicate<ItemStack> validItems;

    SlotDefinition(SlotType type, ItemStack ... itemStacks) {
        this.type = type;
        this.validItems = stack -> {
            for (ItemStack itemStack : itemStacks) {
                if (itemStack.func_77973_b() != stack.func_77973_b()) continue;
                return true;
            }
            return false;
        };
    }

    SlotDefinition(SlotType type, Class<?> itemClass) {
        this.type = type;
        this.validItems = stack -> itemClass != null && itemClass.isInstance(stack.func_77973_b());
    }

    SlotDefinition(SlotType type, Predicate<ItemStack> validItems) {
        this.type = type;
        this.validItems = validItems;
    }

    public static SlotDefinition specific(ItemStack ... stacks) {
        return new SlotDefinition(SlotType.SLOT_SPECIFICITEM, stacks);
    }

    public static SlotDefinition specific(Predicate<ItemStack> validItems) {
        return new SlotDefinition(SlotType.SLOT_SPECIFICITEM, validItems);
    }

    public static SlotDefinition output() {
        return new SlotDefinition(SlotType.SLOT_OUTPUT, new ItemStack[0]);
    }

    public static SlotDefinition input() {
        return new SlotDefinition(SlotType.SLOT_INPUT, new ItemStack[0]);
    }

    public static SlotDefinition container() {
        return new SlotDefinition(SlotType.SLOT_CONTAINER, new ItemStack[0]);
    }

    public static SlotDefinition ghost() {
        return new SlotDefinition(SlotType.SLOT_GHOST, new ItemStack[0]);
    }

    public static SlotDefinition ghostOut() {
        return new SlotDefinition(SlotType.SLOT_GHOSTOUT, new ItemStack[0]);
    }

    public static SlotDefinition craftResult() {
        return new SlotDefinition(SlotType.SLOT_CRAFTRESULT, new ItemStack[0]);
    }

    public SlotType getType() {
        return this.type;
    }

    public boolean itemStackMatches(ItemStack stack) {
        return this.validItems.test(stack);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlotDefinition that = (SlotDefinition)o;
        return this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type});
    }
}

