/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.container;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.container.SlotFactory;
import mcjty.lib.container.SlotRanges;
import mcjty.lib.container.SlotType;
import net.minecraft.item.ItemStack;

public class ContainerFactory {
    private Map<Integer, SlotDefinition> indexToType = new HashMap<Integer, SlotDefinition>();
    private Map<SlotDefinition, SlotRanges> slotRangesMap = new HashMap<SlotDefinition, SlotRanges>();
    private List<SlotFactory> slots = new ArrayList<SlotFactory>();
    public static final String CONTAINER_CONTAINER = "container";
    public static final String CONTAINER_PLAYER = "player";
    private final int containerSlots;

    public ContainerFactory(int containerSlots) {
        this.containerSlots = containerSlots;
    }

    public int getContainerSlots() {
        return this.containerSlots;
    }

    public Map<SlotDefinition, SlotRanges> getSlotRangesMap() {
        return this.slotRangesMap;
    }

    public Iterable<SlotFactory> getSlots() {
        return this.slots;
    }

    public SlotType getSlotType(int index) {
        SlotDefinition slotDefinition = this.indexToType.get(index);
        if (slotDefinition == null) {
            return SlotType.SLOT_UNKNOWN;
        }
        return slotDefinition.getType();
    }

    public boolean isContainerSlot(int index) {
        return this.getSlotType(index) == SlotType.SLOT_CONTAINER;
    }

    public boolean isOutputSlot(int index) {
        return this.getSlotType(index) == SlotType.SLOT_OUTPUT;
    }

    public boolean isInputSlot(int index) {
        return this.getSlotType(index) == SlotType.SLOT_INPUT;
    }

    public boolean isGhostSlot(int index) {
        return this.getSlotType(index) == SlotType.SLOT_GHOST;
    }

    public boolean isGhostOutputSlot(int index) {
        return this.getSlotType(index) == SlotType.SLOT_GHOSTOUT;
    }

    public boolean isCraftResultSlot(int index) {
        return this.getSlotType(index) == SlotType.SLOT_CRAFTRESULT;
    }

    public boolean isPlayerInventorySlot(int index) {
        return this.getSlotType(index) == SlotType.SLOT_PLAYERINV;
    }

    public boolean isSpecificItemSlot(int index) {
        return this.getSlotType(index) == SlotType.SLOT_SPECIFICITEM;
    }

    public boolean isPlayerHotbarSlot(int index) {
        return this.getSlotType(index) == SlotType.SLOT_PLAYERHOTBAR;
    }

    public ContainerFactory slot(SlotDefinition slotDefinition, String inventoryName, int index, int x, int y) {
        SlotFactory slotFactory = new SlotFactory(slotDefinition, inventoryName, index, x, y);
        int slotIndex = this.slots.size();
        this.slots.add(slotFactory);
        SlotRanges slotRanges = this.slotRangesMap.get(slotDefinition);
        if (slotRanges == null) {
            slotRanges = new SlotRanges(slotDefinition);
            this.slotRangesMap.put(slotDefinition, slotRanges);
        }
        slotRanges.addSingle(slotIndex);
        this.indexToType.put(slotIndex, slotDefinition);
        return this;
    }

    public ContainerFactory range(SlotDefinition slotDefinition, String inventoryName, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.slot(slotDefinition, inventoryName, index, x, y);
            x += dx;
            ++index;
        }
        return this;
    }

    public ContainerFactory box(SlotDefinition slotDefinition, String inventoryName, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            this.range(slotDefinition, inventoryName, index, x, y, horAmount, dx);
            index += horAmount;
            y += dy;
        }
        return this;
    }

    public ContainerFactory box(SlotDefinition slotDefinition, String inventoryName, int index, int x, int y, int horAmount, int verAmount) {
        return this.box(slotDefinition, inventoryName, index, x, y, horAmount, 18, verAmount, 18);
    }

    public ContainerFactory playerSlots(int leftCol, int topRow) {
        this.box(new SlotDefinition(SlotType.SLOT_PLAYERINV, new ItemStack[0]), CONTAINER_PLAYER, 9, leftCol, topRow, 9, 3);
        this.range(new SlotDefinition(SlotType.SLOT_PLAYERHOTBAR, new ItemStack[0]), CONTAINER_PLAYER, 0, leftCol, topRow += 58, 9, 18);
        return this;
    }
}

