/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.StringUtils;
import net.minecraftforge.fml.loading.moddiscovery.InvalidModFileException;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.MavenVersionAdapter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.apache.maven.artifact.versioning.VersionRange;

public class ModFileInfo
implements IModFileInfo {
    private static final Logger LOGGER = LogManager.getLogger();
    private final UnmodifiableConfig config;
    private final ModFile modFile;
    private final URL issueURL;
    private final String modLoader;
    private final VersionRange modLoaderVersion;
    private final boolean showAsResourcePack;
    private final List<IModInfo> mods;
    private final Map<String, Object> properties;

    ModFileInfo(ModFile modFile, UnmodifiableConfig config) {
        this.modFile = modFile;
        this.config = config;
        this.modLoader = (String)config.getOptional("modLoader").orElseThrow(() -> new InvalidModFileException("Missing ModLoader in file", this));
        this.modLoaderVersion = config.getOptional("loaderVersion").map(MavenVersionAdapter::createFromVersionSpec).orElseThrow(() -> new InvalidModFileException("Missing ModLoader version in file", this));
        this.showAsResourcePack = (Boolean)config.getOrElse("showAsResourcePack", (Object)false);
        this.properties = config.getOptional("properties").map(UnmodifiableConfig::valueMap).orElse(Collections.emptyMap());
        this.modFile.setFileProperties(this.properties);
        if (config.contains("mods") && !(config.get("mods") instanceof Collection)) {
            throw new InvalidModFileException("Mods list is not a list.", this);
        }
        ArrayList modConfigs = (ArrayList)config.getOrElse("mods", ArrayList::new);
        if (modConfigs.isEmpty()) {
            throw new InvalidModFileException("Missing mods list", this);
        }
        this.mods = modConfigs.stream().map(mi -> new ModInfo(this, (UnmodifiableConfig)mi)).collect(Collectors.toList());
        this.issueURL = config.getOptional("issueTrackerURL").map(StringUtils::toURL).orElse(null);
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = this.modFile::getFileName;
        supplierArray[1] = () -> this.mods.stream().map(IModInfo::getModId).collect(Collectors.joining(",", "{", "}"));
        supplierArray[2] = () -> this.mods.stream().map(IModInfo::getVersion).map(Objects::toString).collect(Collectors.joining(",", "{", "}"));
        LOGGER.debug(LogMarkers.LOADING, "Found valid mod file {} with {} mods - versions {}", supplierArray);
    }

    public List<IModInfo> getMods() {
        return this.mods;
    }

    public ModFile getFile() {
        return this.modFile;
    }

    public UnmodifiableConfig getConfig() {
        return this.config;
    }

    public String getModLoader() {
        return this.modLoader;
    }

    public VersionRange getModLoaderVersion() {
        return this.modLoaderVersion;
    }

    public Map<String, Object> getFileProperties() {
        return this.properties;
    }

    public Optional<Manifest> getManifest() {
        return this.modFile.getLocator().findManifest(this.modFile.getFilePath());
    }

    public boolean showAsResourcePack() {
        return this.showAsResourcePack;
    }
}

