/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.forge.clothconfig2.impl.builders;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import me.shedaniel.forge.clothconfig2.api.AbstractConfigListEntry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class FieldBuilder<T, A extends AbstractConfigListEntry> {
    private final String fieldNameKey;
    private final String resetButtonKey;
    protected boolean requireRestart = false;
    @Nullable
    protected Supplier<T> defaultValue = null;
    @Nullable
    protected Function<T, Optional<String>> errorSupplier;

    protected FieldBuilder(String resetButtonKey, String fieldNameKey) {
        this.resetButtonKey = Objects.requireNonNull(resetButtonKey);
        this.fieldNameKey = Objects.requireNonNull(fieldNameKey);
    }

    @Nullable
    public final Supplier<T> getDefaultValue() {
        return this.defaultValue;
    }

    @Deprecated
    public final AbstractConfigListEntry buildEntry() {
        return this.build();
    }

    public abstract A build();

    public final String getFieldNameKey() {
        return this.fieldNameKey;
    }

    public final String getResetButtonKey() {
        return this.resetButtonKey;
    }

    public boolean isRequireRestart() {
        return this.requireRestart;
    }

    public void requireRestart(boolean requireRestart) {
        this.requireRestart = requireRestart;
    }
}

