/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier1;

import com.bluepowermod.container.ContainerBuffer;
import com.bluepowermod.tile.BPTileEntityType;
import com.bluepowermod.tile.TileBase;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class TileBuffer
extends TileBase
implements ISidedInventory,
INamedContainerProvider {
    public static final int SLOTS = 21;
    private final NonNullList<ItemStack> allInventories = NonNullList.func_191197_a((int)21, (Object)ItemStack.field_190927_a);

    public TileBuffer() {
        super(BPTileEntityType.BUFFER);
    }

    @Override
    public void func_145839_a(CompoundNBT tCompound) {
        super.func_145839_a(tCompound);
        for (int i = 0; i < 20; ++i) {
            CompoundNBT tc = tCompound.func_74775_l("inventory" + i);
            this.allInventories.set(i, (Object)ItemStack.func_199557_a((CompoundNBT)tc));
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tCompound) {
        super.func_189515_b(tCompound);
        for (int i = 0; i < 20; ++i) {
            CompoundNBT tc = new CompoundNBT();
            ((ItemStack)this.allInventories.get(i)).func_77955_b(tc);
            tCompound.func_218657_a("inventory" + i, (INBT)tc);
        }
        return tCompound;
    }

    public int func_70302_i_() {
        return this.allInventories.size();
    }

    public ItemStack func_70301_a(int i) {
        return (ItemStack)this.allInventories.get(i);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (!itemStack.func_190926_b()) {
            if (itemStack.func_190916_E() <= amount) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
            } else if ((itemStack = itemStack.func_77979_a(amount)).func_190916_E() == 0) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int i) {
        return this.func_70301_a(i);
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.allInventories.set(i, (Object)itemStack);
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(PlayerEntity player) {
        return player.func_180425_c().func_218141_a((Vec3i)this.field_174879_c, 64.0);
    }

    public void func_174889_b(PlayerEntity player) {
    }

    public void func_174886_c(PlayerEntity player) {
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        return true;
    }

    @Override
    public NonNullList<ItemStack> getDrops() {
        NonNullList<ItemStack> drops = super.getDrops();
        for (ItemStack stack : this.allInventories) {
            if (stack.func_190926_b()) continue;
            drops.add((Object)stack);
        }
        return drops;
    }

    public int[] func_180463_a(Direction side) {
        int var1 = side.ordinal();
        Direction dir = this.getFacingDirection();
        if (side == dir) {
            int[] allSlots = new int[this.allInventories.size()];
            for (int i = 0; i < allSlots.length; ++i) {
                allSlots[i] = i;
            }
            return allSlots;
        }
        if (var1 > dir.func_176734_d().ordinal()) {
            --var1;
        }
        int[] slots = new int[4];
        for (int i = 0; i < 4; ++i) {
            slots[i] = var1 + i * 5;
        }
        return slots;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, Direction direction) {
        return true;
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public boolean func_191420_l() {
        return this.allInventories.size() == 0;
    }

    public void func_174888_l() {
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent("buffer");
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory inventory, PlayerEntity playerEntity) {
        return new ContainerBuffer(id, inventory, (IInventory)this);
    }
}

