/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items.gadgets.modes;

import com.direwolf20.buildinggadgets.common.items.gadgets.modes.AbstractMode;
import com.direwolf20.buildinggadgets.common.items.gadgets.modes.GridMode;
import com.direwolf20.buildinggadgets.common.items.gadgets.modes.HorizontalColumnMode;
import com.direwolf20.buildinggadgets.common.items.gadgets.modes.SurfaceMode;
import com.direwolf20.buildinggadgets.common.items.gadgets.modes.VerticalColumnMode;
import java.util.Arrays;

public enum ExchangingModes {
    SURFACE(new SurfaceMode(true), "surface"),
    GRID(new GridMode(true), "grid"),
    VERTICAL_COLUMN(new VerticalColumnMode(true), "vertical_column"),
    HORIZONTAL_COLUMN(new HorizontalColumnMode(true), "horizontal_column");

    AbstractMode mode;
    String name;

    private ExchangingModes(AbstractMode mode, String name) {
        this.mode = mode;
        this.name = name;
    }

    public AbstractMode getMode() {
        return this.mode;
    }

    public String getName() {
        return this.name;
    }

    public String getTranslationKey() {
        return "buildinggadgets.modes." + this.name;
    }

    public String getIcon() {
        return "textures/gui/mode/" + this.name + ".png";
    }

    public static ExchangingModes getFromName(String name) {
        return Arrays.stream(ExchangingModes.values()).filter(e -> e.toString().equals(name)).findFirst().orElse(SURFACE);
    }
}

