/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.capability;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.building.BlockData;
import com.direwolf20.buildinggadgets.common.building.IBlockProvider;
import com.direwolf20.buildinggadgets.common.building.SingleTypeProvider;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;

public final class CapabilityBlockProvider {
    @CapabilityInject(value=IBlockProvider.class)
    public static Capability<IBlockProvider> BLOCK_PROVIDER = null;
    private static IBlockProvider DEFAULT_AIR_PROVIDER = new SingleTypeProvider(BlockData.AIR);

    public static IBlockProvider getDefaultAirProvider() {
        return DEFAULT_AIR_PROVIDER;
    }

    private CapabilityBlockProvider() {
    }

    public static void register() {
        BuildingGadgets.LOG.debug("Registering BlockProvider Capability");
        CapabilityManager.INSTANCE.register(IBlockProvider.class, (Capability.IStorage)new Capability.IStorage<IBlockProvider>(){

            public void readNBT(Capability<IBlockProvider> capability, IBlockProvider instance, Direction side, INBT nbt) {
                instance.deserialize((CompoundNBT)nbt);
            }

            @Nonnull
            public INBT writeNBT(Capability<IBlockProvider> capability, IBlockProvider provider, Direction facing) {
                return provider.serialize();
            }
        }, () -> DEFAULT_AIR_PROVIDER);
    }
}

