/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.client.particles.laserparticle;

import com.direwolf20.mininggadgets.client.particles.laserparticle.LaserParticleData;
import com.direwolf20.mininggadgets.common.items.MiningGadget;
import com.direwolf20.mininggadgets.common.items.gadget.MiningProperties;
import com.direwolf20.mininggadgets.common.tiles.RenderBlockTileEntity;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.BreakingParticle;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class LaserParticle
extends BreakingParticle {
    private float f;
    private float f1;
    private float f2;
    private float f3;
    private float f4;
    private float f5;
    private BlockState blockState;
    private UUID playerUUID;
    private double sourceX;
    private double sourceY;
    private double sourceZ;
    private int speedModifier;
    private boolean voiding = false;
    private float originalSize;
    public static IParticleFactory<LaserParticleData> FACTORY = (data, world, x, y, z, xSpeed, ySpeed, zSpeed) -> new LaserParticle(world, x, y, z, xSpeed, ySpeed, zSpeed, data.size, data.r, data.g, data.b, data.depthTest, data.maxAgeMul, data.state);
    private boolean depthTest;
    private final float moteParticleScale;
    private final int moteHalfLife;

    public LaserParticle(World world, double d, double d1, double d2, double xSpeed, double ySpeed, double zSpeed, float size, float red, float green, float blue, boolean depthTest, float maxAgeMul, BlockState blockState) {
        this(world, d, d1, d2, xSpeed, ySpeed, zSpeed, size, red, green, blue, depthTest, maxAgeMul);
        this.blockState = blockState;
        this.func_217567_a(Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(blockState));
    }

    public LaserParticle(World world, double d, double d1, double d2, double xSpeed, double ySpeed, double zSpeed, float size, float red, float green, float blue, boolean depthTest, float maxAgeMul) {
        super(world, d, d1, d2, ItemStack.field_190927_a);
        this.field_187129_i = xSpeed;
        this.field_187130_j = ySpeed;
        this.field_187131_k = zSpeed;
        this.field_70552_h = red;
        this.field_70553_i = green;
        this.field_70551_j = blue;
        this.field_70545_g = 0.0f;
        this.field_70544_f *= size;
        this.originalSize = this.field_70544_f;
        this.moteParticleScale = this.field_70544_f;
        this.field_70547_e = Math.round(maxAgeMul);
        this.depthTest = depthTest;
        this.moteHalfLife = this.field_70547_e / 2;
        this.func_187115_a(0.001f, 0.001f);
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        RenderBlockTileEntity te = (RenderBlockTileEntity)world.func_175625_s(new BlockPos(this.field_187126_f, this.field_187127_g, this.field_187128_h));
        if (te != null) {
            this.playerUUID = te.getPlayerUUID();
            this.voiding = !te.getBlockAllowed();
        }
        this.sourceX = d;
        this.sourceY = d1;
        this.sourceZ = d2;
        this.field_190017_n = false;
    }

    public void func_225606_a_(IVertexBuilder builder, ActiveRenderInfo activeRenderInfo, float partialTicks) {
        super.func_225606_a_(builder, activeRenderInfo, partialTicks);
    }

    public boolean particleToPlayer(PlayerEntity player) {
        TileEntity te;
        boolean partToPlayer = false;
        BlockPos sourcePos = new BlockPos(this.sourceX, this.sourceY, this.sourceZ);
        if (this.field_187122_b.func_180495_p(sourcePos) != this.blockState) {
            partToPlayer = true;
        }
        if ((te = this.field_187122_b.func_175625_s(sourcePos)) != null && te instanceof RenderBlockTileEntity && ((RenderBlockTileEntity)te).getTicksSinceMine() >= 5) {
            partToPlayer = false;
        }
        return partToPlayer;
    }

    public void func_189213_a() {
        double moveZ;
        double moveY;
        double moveX;
        int speedAdjust;
        if (this.playerUUID == null) {
            this.func_187112_i();
            return;
        }
        PlayerEntity player = this.field_187122_b.func_217371_b(this.playerUUID);
        if (player == null) {
            this.func_187112_i();
            return;
        }
        Vec3d playerPos = player.func_213303_ch().func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
        Vec3d blockPos = new Vec3d(this.sourceX, this.sourceY, this.sourceZ);
        Vec3d look = player.func_70040_Z();
        Vec3d right = new Vec3d(-look.field_72449_c, 0.0, look.field_72450_a).func_72432_b();
        Vec3d forward = look;
        Vec3d down = right.func_72431_c(forward);
        right = right.func_186678_a((double)0.65f);
        forward = forward.func_186678_a((double)0.85f);
        down = down.func_186678_a(-0.35);
        Vec3d laserPos = playerPos.func_178787_e(right);
        laserPos = laserPos.func_178787_e(forward);
        laserPos = laserPos.func_178787_e(down);
        Vec3d partPos = new Vec3d(this.field_187126_f, this.field_187127_g, this.field_187128_h);
        Vec3d targetDirection = new Vec3d(laserPos.func_82615_a() - this.field_187126_f, laserPos.func_82617_b() - this.field_187127_g, laserPos.func_82616_c() - this.field_187128_h);
        double totalDistance = blockPos.func_72438_d(laserPos);
        if (this.particleToPlayer(player)) {
            ++this.speedModifier;
            speedAdjust = 30 - this.speedModifier <= 0 ? 1 : 30 - this.speedModifier;
            double distance = laserPos.func_72438_d(partPos);
            if (distance < 0.25) {
                this.func_187112_i();
            }
            if (this.field_70546_d > 5) {
                float spinSpeed = MathHelper.func_219799_g((float)(1.0f - (float)distance / (float)totalDistance), (float)1.1f, (float)0.05f);
                targetDirection = targetDirection.func_178787_e(targetDirection.func_72431_c(look).func_186678_a((double)spinSpeed).func_216372_d(3.0, 3.0, 3.0));
            }
            this.field_70544_f *= MathHelper.func_219799_g((float)(1.0f - (float)distance / (float)totalDistance), (float)1.05f, (float)0.85f);
            moveX = targetDirection.func_82615_a() / (double)speedAdjust;
            moveY = targetDirection.func_82617_b() / (double)speedAdjust;
            moveZ = targetDirection.func_82616_c() / (double)speedAdjust;
            ItemStack heldItem = MiningGadget.getGadget(player);
            if (heldItem.func_77973_b() instanceof MiningGadget && MiningProperties.getRange(heldItem) > 1 && this.field_70546_d < 5) {
                int compressionFactor = 7;
                moveX *= (1.0 - Math.abs(look.field_72450_a)) * (double)compressionFactor;
                moveY *= (1.0 - Math.abs(look.field_72448_b)) * (double)compressionFactor;
                moveZ *= (1.0 - Math.abs(look.field_72449_c)) * (double)compressionFactor;
            }
        } else {
            this.speedModifier = 0;
            speedAdjust = 20 - this.speedModifier <= 0 ? 1 : 20 - this.speedModifier;
            double distance = blockPos.func_72438_d(partPos);
            if (distance < 0.75) {
                this.func_187112_i();
            }
            moveX = (this.sourceX - this.field_187126_f) / (double)speedAdjust;
            moveY = (this.sourceY - this.field_187127_g) / (double)speedAdjust;
            moveZ = (this.sourceZ - this.field_187128_h) / (double)speedAdjust;
        }
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.voiding && this.field_70546_d > 10 && this.field_70546_d <= 15) {
            float darkness;
            this.field_70552_h = darkness = MathHelper.func_219799_g((float)((float)(this.field_70546_d - 10) / 5.0f), (float)1.0f, (float)0.0f);
            this.field_70553_i = darkness;
            this.field_70551_j = darkness;
        }
        if (this.voiding && this.field_70546_d > 15 && this.field_70546_d <= 25) {
            float fade = MathHelper.func_219799_g((float)(((float)this.field_70546_d - 15.0f) / 10.0f), (float)1.0f, (float)0.0f);
            this.field_70544_f = this.originalSize * fade;
        }
        this.func_187110_a(moveX, moveY, moveZ);
    }

    public void setGravity(float value) {
        this.field_70545_g = value;
    }

    public void setSpeed(float mx, float my, float mz) {
        this.field_187129_i = mx;
        this.field_187130_j = my;
        this.field_187131_k = mz;
    }
}

