/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.compat.ironchest;

import java.lang.reflect.Field;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.ModBlocks;
import net.blay09.mods.refinedrelocation.SortingChestType;
import net.blay09.mods.refinedrelocation.api.Capabilities;
import net.blay09.mods.refinedrelocation.api.ISortingUpgradable;
import net.blay09.mods.refinedrelocation.block.SortingChestBlock;
import net.blay09.mods.refinedrelocation.tile.SortingChestTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IClearable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IronChestAddon {
    private static final Logger logger = LogManager.getLogger();
    private Class<?> ironChestTileEntity;
    private Class<?> chestUpgradeItem;
    private Field lidAngleField;
    private Field chestUpgradeType;

    public IronChestAddon() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        try {
            this.ironChestTileEntity = Class.forName("com.progwml6.ironchest.common.block.tileentity.GenericIronChestTileEntity");
            this.lidAngleField = this.ironChestTileEntity.getDeclaredField("lidAngle");
            this.lidAngleField.setAccessible(true);
            this.chestUpgradeItem = Class.forName("com.progwml6.ironchest.common.item.ChestUpgradeItem");
            this.chestUpgradeType = this.chestUpgradeItem.getDeclaredField("type");
            this.chestUpgradeType.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            logger.error("Could not setup IronChests compat - some features may not work as expected!", (Throwable)e);
        }
    }

    @SubscribeEvent
    public void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        SortingChestType targetType;
        SortingChestType sourceType;
        String upgradeName;
        ItemStack itemStack = event.getItemStack();
        String registryName = Objects.toString(itemStack.func_77973_b().getRegistryName());
        if (!registryName.startsWith("ironchest:") || !registryName.contains("upgrade")) {
            return;
        }
        if (this.chestUpgradeType == null || this.chestUpgradeItem == null) {
            logger.error("Could not upgrade sorting chest because IronChest compat did not setup correctly");
            return;
        }
        if (event.getWorld().field_72995_K || itemStack.func_190926_b() || !this.chestUpgradeItem.isAssignableFrom(itemStack.func_77973_b().getClass())) {
            return;
        }
        try {
            upgradeName = ((Enum)this.chestUpgradeType.get(itemStack.func_77973_b())).name();
        }
        catch (IllegalAccessException e) {
            logger.error("Could not upgrade sorting chest because IronChest compat did not setup correctly", (Throwable)e);
            return;
        }
        switch (upgradeName) {
            case "WOOD_TO_IRON": {
                sourceType = SortingChestType.WOOD;
                targetType = SortingChestType.IRON;
                break;
            }
            case "IRON_TO_GOLD": {
                sourceType = SortingChestType.IRON;
                targetType = SortingChestType.GOLD;
                break;
            }
            case "GOLD_TO_DIAMOND": {
                sourceType = SortingChestType.GOLD;
                targetType = SortingChestType.DIAMOND;
                break;
            }
            default: {
                return;
            }
        }
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        BlockState state = world.func_180495_p(pos);
        if (!(state.func_177230_c() instanceof SortingChestBlock)) {
            return;
        }
        if (((SortingChestBlock)state.func_177230_c()).getChestType() != sourceType) {
            return;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof SortingChestTileEntity)) {
            return;
        }
        SortingChestTileEntity tileSortingChest = (SortingChestTileEntity)tileEntity;
        if (tileSortingChest.getNumPlayersUsing() > 0) {
            return;
        }
        Direction facing = (Direction)state.func_177229_b(SortingChestBlock.FACING);
        CompoundNBT serialized = tileEntity.func_189515_b(new CompoundNBT());
        IClearable.func_213131_a((Object)tileEntity);
        BlockState newState = (BlockState)ModBlocks.sortingChests[targetType.ordinal()].func_176223_P().func_206870_a(SortingChestBlock.FACING, (Comparable)facing);
        world.func_175656_a(pos, newState);
        TileEntity newTileEntity = world.func_175625_s(pos);
        if (newTileEntity instanceof SortingChestTileEntity) {
            newTileEntity.func_145839_a(serialized);
        }
        if (!event.getPlayer().field_71075_bZ.field_75098_d) {
            itemStack.func_190918_g(1);
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<TileEntity> event) {
        if (this.ironChestTileEntity != null && this.ironChestTileEntity.isAssignableFrom(((TileEntity)event.getObject()).getClass())) {
            event.addCapability(new ResourceLocation("refinedrelocation", "sorting_upgradable"), (ICapabilityProvider)new IronChestCapabilityProvider());
        }
    }

    private class IronChestCapabilityProvider
    implements ICapabilityProvider,
    ISortingUpgradable {
        private IronChestCapabilityProvider() {
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return Capabilities.SORTING_UPGRADABLE.orEmpty(cap, LazyOptional.of(() -> this));
        }

        @Override
        public boolean applySortingUpgrade(TileEntity tileEntity, ItemStack itemStack, PlayerEntity player, World world, BlockPos pos, Direction side, double hitX, double hitY, double hitZ, Hand hand) {
            SortingChestType chestType;
            String registryName;
            try {
                if (IronChestAddon.this.lidAngleField == null || IronChestAddon.this.lidAngleField.getFloat(tileEntity) > 0.0f) {
                    return false;
                }
            }
            catch (IllegalAccessException e) {
                logger.error("Failed to upgrade chest due to incompatibility", (Throwable)e);
                return false;
            }
            BlockState state = world.func_180495_p(pos);
            switch (registryName = Objects.toString(state.func_177230_c().getRegistryName())) {
                case "ironchest:iron_chest": {
                    chestType = SortingChestType.IRON;
                    break;
                }
                case "ironchest:gold_chest": {
                    chestType = SortingChestType.GOLD;
                    break;
                }
                case "ironchest:diamond_chest": {
                    chestType = SortingChestType.DIAMOND;
                    break;
                }
                default: {
                    return false;
                }
            }
            CompoundNBT storedData = tileEntity.func_189515_b(new CompoundNBT());
            Direction facing = (Direction)state.func_177229_b((IProperty)HorizontalBlock.field_185512_D);
            SortingChestBlock sortingChestBlock = ModBlocks.sortingChests[chestType.ordinal()];
            IClearable.func_213131_a((Object)tileEntity);
            world.func_175656_a(pos, (BlockState)sortingChestBlock.func_176223_P().func_206870_a(SortingChestBlock.FACING, (Comparable)facing));
            SortingChestTileEntity sortingChest = (SortingChestTileEntity)world.func_175625_s(pos);
            if (sortingChest != null) {
                sortingChest.restoreItems(storedData.func_150295_c("Items", 10));
            }
            return true;
        }
    }
}

