/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.client.gui.element;

import java.util.List;
import net.blay09.mods.refinedrelocation.api.RefinedRelocationAPI;
import net.blay09.mods.refinedrelocation.client.gui.GuiTextures;
import net.blay09.mods.refinedrelocation.client.gui.base.ITickableElement;
import net.blay09.mods.refinedrelocation.client.gui.base.ITooltipElement;
import net.blay09.mods.refinedrelocation.client.gui.base.element.GuiImageButton;
import net.blay09.mods.refinedrelocation.client.gui.element.GuiFilterSlot;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public class GuiDeleteFilterButton
extends GuiImageButton
implements ITickableElement,
ITooltipElement {
    private static boolean shiftGuard;
    private final GuiFilterSlot parentSlot;

    public GuiDeleteFilterButton(int x, int y, GuiFilterSlot parentSlot) {
        super(x, y, 8, 8, GuiTextures.DELETE_FILTER, it -> {});
        this.parentSlot = parentSlot;
        this.visible = false;
    }

    @Override
    public void tick() {
        this.visible = this.parentSlot.hasFilter();
        boolean isShiftDown = Screen.hasShiftDown();
        boolean bl = this.active = !shiftGuard && isShiftDown;
        if (!isShiftDown) {
            shiftGuard = false;
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOver(mouseX, mouseY) && !this.active) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.visible && mouseX >= (double)this.x && mouseY >= (double)this.y && mouseX < (double)(this.x + this.width) && mouseY < (double)(this.y + this.height);
    }

    public void onClick(double mouseX, double mouseY) {
        shiftGuard = true;
        RefinedRelocationAPI.sendContainerMessageToServer("DeleteFilter", this.parentSlot.getFilterIndex());
    }

    @Override
    public void addTooltip(List<String> list) {
        list.add(TextFormatting.RED + I18n.func_135052_a((String)"gui.refinedrelocation:root_filter.delete_filter", (Object[])new Object[0]));
        if (!this.active) {
            list.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"gui.refinedrelocation:root_filter.hold_shift_to_delete", (Object[])new Object[0]));
        } else {
            list.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"gui.refinedrelocation:root_filter.delete_cannot_be_undone", (Object[])new Object[0]));
        }
    }
}

