/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.client.gui.base.element;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.blay09.mods.refinedrelocation.client.gui.base.element.IScrollTarget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import org.lwjgl.glfw.GLFW;

public class MultiLineTextFieldWidget
extends TextFieldWidget
implements IScrollTarget {
    private static final int ENABLED_COLOR = 0xE0E0E0;
    private static final int DISABLED_COLOR = 0x707070;
    private static final int PADDING = 2;
    private final FontRenderer fontRenderer;
    private int scrollOffset;
    private int cursorCounter;
    private String[] renderCache;
    private int lastRowCount;
    private float ticksSinceLastHistory;
    private List<String> history = new ArrayList<String>();
    private List<String> redoHistory = new ArrayList<String>();
    private Map<String, String> debugRenders = new HashMap<String, String>();

    public MultiLineTextFieldWidget(int x, int y, int width, int height) {
        super(Minecraft.func_71410_x().field_71466_p, x, y, width, height, "");
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
    }

    private int getStartOfLine(int position, int iterations) {
        String text = this.func_146179_b();
        int startOfLine = position;
        for (int i = 0; i < iterations; ++i) {
            startOfLine = text.lastIndexOf(10, startOfLine - 1);
        }
        return startOfLine != -1 ? startOfLine + 1 : 0;
    }

    private int getEndOfLine(int position, int iteration) {
        String text = this.func_146179_b();
        int endOfLine = position - 1;
        for (int i = 0; i < iteration; ++i) {
            if ((endOfLine = text.indexOf(10, endOfLine + 1)) != -1) continue;
            return text.length();
        }
        return endOfLine != -1 ? endOfLine : text.length();
    }

    private int getLineLength(int position) {
        return this.getEndOfLine(position, 1) - this.getStartOfLine(position, 1);
    }

    private int getStartOfWord(int position) {
        String text = this.func_146179_b();
        if (text.isEmpty()) {
            return 0;
        }
        if (text.charAt(position = Math.max(Math.min(position, text.length() - 1), 0)) == '\n') {
            return position;
        }
        boolean foundAlphabetic = false;
        for (int i = position; i >= 0; --i) {
            char c = text.charAt(i);
            if (c == '\n') {
                return i + 1;
            }
            if (Character.isAlphabetic(c)) {
                foundAlphabetic = true;
                continue;
            }
            if (!foundAlphabetic) continue;
            return i + 1;
        }
        return 0;
    }

    private int getStartOfNextWord(int position) {
        String text = this.func_146179_b();
        if (text.charAt(position = Math.max(Math.min(position, text.length() - 1), 0)) == '\n') {
            return position;
        }
        boolean foundNonAlphabetic = false;
        for (int i = position; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\n') {
                return i;
            }
            if (!Character.isAlphabetic(c)) {
                foundNonAlphabetic = true;
                continue;
            }
            if (!foundNonAlphabetic) continue;
            return i;
        }
        return text.length();
    }

    public void func_146199_i(int cursorPosition) {
        String text = this.func_146179_b();
        super.func_146199_i(Math.min(Math.max(cursorPosition, 0), text.length()));
        int cursorLine = 0;
        for (int i = 0; i < this.func_146198_h(); ++i) {
            if (text.charAt(i) != '\n') continue;
            ++cursorLine;
        }
        int innerHeight = this.height - 2;
        this.fontRenderer.getClass();
        int cursorRenderY = (cursorLine - this.scrollOffset) * 9 + 2;
        if (cursorRenderY < 0) {
            this.fontRenderer.getClass();
            this.scroll(0, cursorRenderY / 9 - 1);
        } else {
            this.fontRenderer.getClass();
            if (cursorRenderY > innerHeight - 9) {
                this.fontRenderer.getClass();
                this.scroll(0, (cursorRenderY - innerHeight) / 9 + 1);
            }
        }
        this.field_146225_q = 0;
        int innerWidth = this.width - 2;
        int startOfLine = this.getStartOfLine(cursorPosition, 1);
        int endOfLine = this.getEndOfLine(cursorPosition, 1);
        int cursorPositionX = Math.min(this.getLineLength(cursorPosition), cursorPosition - startOfLine);
        String lineText = text.substring(startOfLine, endOfLine);
        this.field_146225_q = Math.max(Math.min(this.field_146225_q, lineText.length()), 0);
        String renderText = this.fontRenderer.func_78269_a(lineText.substring(this.field_146225_q), innerWidth);
        if (cursorPositionX == this.field_146225_q) {
            this.field_146225_q -= renderText.length();
        }
        this.field_146225_q = Math.max(Math.min(this.field_146225_q, lineText.length()), 0);
        int offset = renderText.length() + this.field_146225_q;
        if (cursorPositionX > offset) {
            this.field_146225_q += cursorPositionX - offset;
        } else if (cursorPositionX <= this.field_146225_q) {
            this.field_146225_q -= this.field_146225_q - cursorPositionX;
        }
        this.field_146225_q = Math.max(Math.min(this.field_146225_q, lineText.length()), 0);
    }

    private void scroll(int x, int y) {
        this.field_146225_q = Math.max(this.field_146225_q + x, 0);
        this.scrollOffset = Math.max(Math.min(this.scrollOffset + y, this.getRowCount() - this.getVisibleRows()), 0);
    }

    private void deleteBack(boolean wholeWord) {
        int cursorPosition = Math.max(this.field_146223_s, this.func_146198_h());
        int deleteCount = Math.max(1, this.func_146207_c().length());
        if (wholeWord) {
            deleteCount = cursorPosition - this.getStartOfWord(cursorPosition);
        }
        if (cursorPosition > 0) {
            String text = this.func_146179_b();
            text = text.substring(0, cursorPosition - deleteCount) + text.substring(cursorPosition);
            this.func_146180_a(text);
            this.func_146190_e(cursorPosition - deleteCount);
            this.renderCache = null;
        }
    }

    private void deleteFront(boolean wholeWord) {
        String text;
        int cursorPosition = Math.min(this.field_146223_s, this.func_146198_h());
        int deleteCount = Math.max(1, this.func_146207_c().length());
        if (wholeWord) {
            deleteCount = this.getStartOfNextWord(cursorPosition) - cursorPosition;
        }
        if (cursorPosition < (text = this.func_146179_b()).length()) {
            text = text.substring(0, cursorPosition) + text.substring(cursorPosition + deleteCount);
            this.func_146180_a(text);
            this.func_146190_e(cursorPosition);
            this.renderCache = null;
        }
    }

    public void func_146191_b(String textToWrite) {
        super.func_146191_b(textToWrite);
        this.renderCache = null;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean isInside;
        this.field_212956_h = Screen.hasShiftDown();
        boolean bl = isInside = mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height);
        if (this.isFocused() && isInside && mouseButton == 0) {
            double relX = mouseX - (double)this.x;
            double d = mouseY - (double)this.y;
            this.fontRenderer.getClass();
            double relY = d - 9.0 + 5.0;
            float f = (float)relY;
            this.fontRenderer.getClass();
            int lineNumber = Math.round(f / 9.0f) + this.scrollOffset + 1;
            int startOfLine = this.getStartOfLine(this.getEndOfLine(0, lineNumber), 1);
            int endOfLine = this.getEndOfLine(startOfLine, 1);
            if (startOfLine == endOfLine) {
                this.func_146190_e(startOfLine);
            } else {
                int lineRenderEndIndex;
                int lineRenderStartIndex = Math.max(startOfLine + this.field_146225_q, 0);
                if (lineRenderStartIndex <= (lineRenderEndIndex = Math.max(0, endOfLine))) {
                    String renderText = this.fontRenderer.func_78269_a(this.func_146179_b().substring(lineRenderStartIndex, lineRenderEndIndex), this.width - 2);
                    this.func_146190_e(startOfLine + this.fontRenderer.func_78269_a(renderText, (int)relX).length() + this.field_146225_q);
                } else {
                    this.func_146190_e(endOfLine);
                }
            }
            return true;
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.isFocused()) {
            return false;
        }
        this.field_212956_h = Screen.hasShiftDown();
        String keyName = GLFW.glfwGetKeyName((int)keyCode, (int)scanCode);
        if ("z".equals(keyName) && Screen.hasControlDown() && !Screen.hasShiftDown() && !Screen.hasAltDown()) {
            if (!this.history.isEmpty()) {
                String redoText = this.func_146179_b();
                this.redoHistory.add(redoText);
                this.func_146180_a(this.history.remove(this.history.size() - 1));
            }
        } else if (("z".equals(keyName) && Screen.hasControlDown() && Screen.hasShiftDown() && !Screen.hasAltDown() || "y".equals(keyName) && Screen.hasControlDown() && !Screen.hasShiftDown() && !Screen.hasAltDown()) && !this.redoHistory.isEmpty()) {
            String undoText = this.func_146179_b();
            this.func_146180_a(this.redoHistory.remove(this.redoHistory.size() - 1));
            this.history.add(undoText);
        }
        if (Screen.isPaste((int)keyCode)) {
            String[] lines;
            String clipboardString = Minecraft.func_71410_x().field_195559_v.func_197965_a();
            for (String line : lines = clipboardString.split("\n")) {
                this.func_146191_b(line);
                this.addNewLine();
            }
            return true;
        }
        int cursorPosition = this.func_146198_h();
        switch (keyCode) {
            case 269: {
                if (Screen.hasControlDown()) {
                    this.func_146190_e(this.func_146179_b().length());
                } else {
                    this.func_146190_e(this.getEndOfLine(cursorPosition, 1));
                }
                return true;
            }
            case 268: {
                if (Screen.hasControlDown()) {
                    this.func_146190_e(0);
                } else {
                    this.func_146190_e(this.getStartOfLine(cursorPosition, 1));
                }
                return true;
            }
            case 263: {
                if (Screen.hasControlDown()) {
                    this.func_146190_e(this.getStartOfWord(cursorPosition - 1));
                } else {
                    this.func_146190_e(cursorPosition - 1);
                }
                return true;
            }
            case 262: {
                if (Screen.hasControlDown()) {
                    this.func_146190_e(this.getStartOfNextWord(cursorPosition + 1));
                } else {
                    this.func_146190_e(cursorPosition + 1);
                }
                return true;
            }
            case 265: {
                if (Screen.hasControlDown()) {
                    this.scroll(0, -1);
                } else {
                    int upLine = this.getStartOfLine(cursorPosition, 2);
                    this.func_146190_e(upLine + Math.min(this.getLineLength(upLine), cursorPosition - this.getStartOfLine(cursorPosition, 1)));
                }
                return true;
            }
            case 264: {
                if (Screen.hasControlDown()) {
                    this.scroll(0, 1);
                } else {
                    int downLine = this.getEndOfLine(cursorPosition, 2);
                    this.func_146190_e(this.getStartOfLine(downLine, 1) + Math.min(this.getLineLength(downLine), cursorPosition - this.getStartOfLine(cursorPosition, 1)));
                }
                return true;
            }
            case 257: {
                if (this.active) {
                    this.addNewLine();
                }
                return true;
            }
            case 261: {
                if (this.active) {
                    this.deleteFront(Screen.hasControlDown());
                }
                return true;
            }
            case 259: {
                if (this.active) {
                    this.deleteBack(Screen.hasControlDown());
                }
                return true;
            }
        }
        boolean result = super.keyPressed(keyCode, scanCode, modifiers);
        this.updateHistory();
        return result;
    }

    public boolean charTyped(char charCode, int keyCode) {
        boolean result = super.charTyped(charCode, keyCode);
        this.updateHistory();
        return result;
    }

    private void updateHistory() {
        int historyIntervalSeconds = 5;
        if (this.ticksSinceLastHistory >= (float)(20 * historyIntervalSeconds)) {
            String text;
            String lastHistoryText = null;
            if (!this.history.isEmpty()) {
                lastHistoryText = this.history.get(this.history.size() - 1);
            }
            if (!Objects.equals(lastHistoryText, text = this.func_146179_b())) {
                this.history.add(text);
            }
            this.ticksSinceLastHistory = 0.0f;
        }
    }

    private void addNewLine() {
        this.writeUnfiltered("\n");
    }

    public void func_146178_a() {
        super.func_146178_a();
        this.scrollOffset = Math.max(Math.min(this.scrollOffset, this.getRowCount() - this.getVisibleRows()), 0);
        ++this.cursorCounter;
    }

    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        this.ticksSinceLastHistory += partialTicks;
        if (this.func_146176_q()) {
            MultiLineTextFieldWidget.fill((int)(this.x - 1), (int)(this.y - 1), (int)(this.x + this.width + 1), (int)(this.y + this.height + 1), (int)-1118482);
            MultiLineTextFieldWidget.fill((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)-16777216);
            if (this.renderCache == null) {
                this.renderCache = this.func_146179_b().split("\n", -1);
            }
            for (int i = this.scrollOffset; i < this.renderCache.length; ++i) {
                this.fontRenderer.getClass();
                int y = (i - this.scrollOffset) * 9;
                this.fontRenderer.getClass();
                if (y + 9 >= this.height) break;
                if (this.field_146225_q >= this.renderCache[i].length()) continue;
                String renderText = this.fontRenderer.func_78269_a(this.renderCache[i].substring(this.field_146225_q), this.width - 2);
                this.fontRenderer.func_175063_a(renderText, (float)(this.x + 2), (float)(this.y + 2 + y), this.active ? 0xE0E0E0 : 0x707070);
            }
            int cursorLine = 0;
            int lastLineStartIdx = 0;
            for (int i = 0; i < this.func_146198_h(); ++i) {
                if (this.func_146179_b().charAt(i) != '\n') continue;
                ++cursorLine;
                lastLineStartIdx = i + 1;
            }
            if (this.cursorCounter / 6 % 2 == 0) {
                this.fontRenderer.getClass();
                if ((cursorLine - this.scrollOffset) * 9 >= 0) {
                    int endIndex;
                    int startIndex;
                    this.fontRenderer.getClass();
                    if ((cursorLine - this.scrollOffset + 1) * 9 < this.height + 2 && (startIndex = lastLineStartIdx + this.field_146225_q) <= (endIndex = this.func_146198_h())) {
                        int cursorX = this.x + this.fontRenderer.func_78256_a(this.func_146179_b().substring(startIndex, endIndex)) + 2;
                        this.fontRenderer.getClass();
                        int cursorY = this.y + (cursorLine - this.scrollOffset) * 9 + 2;
                        AbstractGui.fill((int)cursorX, (int)cursorY, (int)(cursorX + 1), (int)(cursorY + 9), (int)-3092272);
                    }
                }
            }
            int selectionStart = Math.min(this.field_146223_s, this.func_146198_h());
            int selectionEnd = Math.max(this.field_146223_s, this.func_146198_h());
            if (selectionEnd != selectionStart) {
                int currentLineStartIndex = 0;
                int lineSelectionStartIndex = selectionStart;
                int linesPassed = 0;
                for (int i = 0; i < selectionEnd; ++i) {
                    char charAt = this.func_146179_b().charAt(i);
                    if (charAt != '\n' && i + 1 != selectionEnd) continue;
                    if (i >= selectionStart && linesPassed < this.scrollOffset + this.getVisibleRows()) {
                        int offsetX = 0;
                        int unselectedScrolledStartIndex = currentLineStartIndex + this.field_146225_q;
                        if (unselectedScrolledStartIndex < selectionStart) {
                            String unselectedLineText = this.func_146179_b().substring(unselectedScrolledStartIndex, selectionStart);
                            offsetX = this.fontRenderer.func_78256_a(unselectedLineText);
                        }
                        int scrolledStartIndex = lineSelectionStartIndex;
                        if (currentLineStartIndex + this.field_146225_q > selectionStart) {
                            scrolledStartIndex += this.field_146225_q;
                        }
                        if (scrolledStartIndex <= i && linesPassed >= this.scrollOffset) {
                            String selectedLineText = this.func_146179_b().substring(scrolledStartIndex, charAt == '\n' ? i : i + 1);
                            int selectedLineWidth = this.fontRenderer.func_78256_a(selectedLineText);
                            int selectionX = this.x + offsetX + 1;
                            int selectionY = this.y + (linesPassed - this.scrollOffset) * 9 + 1;
                            this.func_146188_c(selectionX, selectionY, selectionX + selectedLineWidth + 1, selectionY + 9);
                        }
                        lineSelectionStartIndex = i + 1;
                    }
                    currentLineStartIndex = i + 1;
                    ++linesPassed;
                }
            }
            float debugY = 10.0f;
            for (Map.Entry<String, String> entry : this.debugRenders.entrySet()) {
                this.fontRenderer.func_175063_a(entry.getKey() + ": " + entry.getValue(), 10.0f, debugY, -1);
                debugY += 10.0f;
            }
        }
    }

    public void func_146180_a(String text) {
        int cursorPosition = this.func_146198_h();
        super.func_146180_a(text);
        this.func_146190_e(cursorPosition);
        this.renderCache = null;
    }

    @Override
    public int getVisibleRows() {
        this.fontRenderer.getClass();
        return this.height / 9;
    }

    @Override
    public int getRowCount() {
        if (this.renderCache != null) {
            this.lastRowCount = this.renderCache.length;
        }
        return this.lastRowCount;
    }

    @Override
    public int getCurrentOffset() {
        return this.scrollOffset;
    }

    @Override
    public void setCurrentOffset(int offset) {
        this.scrollOffset = offset;
    }

    public void writeUnfiltered(String inputText) {
        int lvt_7_2_;
        String resultText = "";
        int lvt_4_1_ = Math.min(this.func_146198_h(), this.field_146223_s);
        int lvt_5_1_ = Math.max(this.func_146198_h(), this.field_146223_s);
        int lvt_6_1_ = this.field_146217_k - this.func_146179_b().length() - (lvt_4_1_ - lvt_5_1_);
        if (!this.func_146179_b().isEmpty()) {
            resultText = resultText + this.func_146179_b().substring(0, lvt_4_1_);
        }
        if (lvt_6_1_ < inputText.length()) {
            resultText = resultText + inputText.substring(0, lvt_6_1_);
            lvt_7_2_ = lvt_6_1_;
        } else {
            resultText = resultText + inputText;
            lvt_7_2_ = inputText.length();
        }
        if (!this.func_146179_b().isEmpty() && lvt_5_1_ < this.func_146179_b().length()) {
            resultText = resultText + this.func_146179_b().substring(lvt_5_1_);
        }
        this.func_146180_a(resultText);
        this.func_212422_f(lvt_4_1_ + lvt_7_2_);
        this.func_146199_i(this.func_146198_h());
        this.func_212951_d(this.func_146179_b());
    }

    public void addHistoryEntry(String text) {
        this.history.add(text);
    }
}

