/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.tubesreloaded.common.blocks.tube;

import com.github.commoble.tubesreloaded.common.blocks.extractor.ExtractorBlock;
import com.github.commoble.tubesreloaded.common.blocks.filter.FilterBlock;
import com.github.commoble.tubesreloaded.common.blocks.loader.LoaderBlock;
import com.github.commoble.tubesreloaded.common.blocks.tube.TubeTileEntity;
import com.github.commoble.tubesreloaded.common.registry.TileEntityRegistrar;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.SixWayBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;

public class TubeBlock
extends Block
implements IBucketPickupHandler,
ILiquidContainer {
    public static final Direction[] FACING_VALUES = Direction.values();
    public static final BooleanProperty DOWN = SixWayBlock.field_196489_A;
    public static final BooleanProperty UP = SixWayBlock.field_196496_z;
    public static final BooleanProperty NORTH = SixWayBlock.field_196488_a;
    public static final BooleanProperty SOUTH = SixWayBlock.field_196492_c;
    public static final BooleanProperty WEST = SixWayBlock.field_196495_y;
    public static final BooleanProperty EAST = SixWayBlock.field_196490_b;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected final VoxelShape[] shapes;

    public TubeBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)UP, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.shapes = this.makeShapes();
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return TileEntityRegistrar.TUBE.func_200968_a();
    }

    @Deprecated
    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    @Deprecated
    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean wat) {
        if (!world.field_72995_K) {
            TubeTileEntity.getTubeTEAt(world, pos).ifPresent(te -> te.onPossibleNetworkUpdateRequired());
        }
        super.func_220069_a(state, world, pos, blockIn, fromPos, wat);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (!world.field_72995_K) {
            TubeTileEntity.getTubeTEAt(world, pos).ifPresent(te -> te.onPossibleNetworkUpdateRequired());
        }
        super.func_180633_a(world, pos, state, placer, stack);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        IFluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)super.func_196258_a(context).func_206870_a((IProperty)DOWN, (Comparable)Boolean.valueOf(this.canConnectTo((IBlockReader)world, pos, Direction.DOWN)))).func_206870_a((IProperty)UP, (Comparable)Boolean.valueOf(this.canConnectTo((IBlockReader)world, pos, Direction.UP)))).func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canConnectTo((IBlockReader)world, pos, Direction.NORTH)))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canConnectTo((IBlockReader)world, pos, Direction.SOUTH)))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canConnectTo((IBlockReader)world, pos, Direction.WEST)))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canConnectTo((IBlockReader)world, pos, Direction.EAST)))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    protected boolean canConnectTo(IBlockReader world, BlockPos pos, Direction face) {
        BlockPos newPos = pos.func_177972_a(face);
        BlockState state = world.func_180495_p(newPos);
        Block block = state.func_177230_c();
        if (block instanceof TubeBlock) {
            return this.isTubeCompatible((TubeBlock)block);
        }
        if (block instanceof LoaderBlock && ((Direction)state.func_177229_b((IProperty)LoaderBlock.FACING)).equals((Object)face.func_176734_d())) {
            return true;
        }
        if (block instanceof ExtractorBlock && ((Direction)state.func_177229_b((IProperty)ExtractorBlock.FACING)).equals((Object)face.func_176734_d())) {
            return true;
        }
        if (block instanceof FilterBlock && ((Direction)state.func_177229_b((IProperty)FilterBlock.FACING)).equals((Object)face.func_176734_d())) {
            return true;
        }
        TileEntity te = world.func_175625_s(newPos);
        if (te == null) {
            return false;
        }
        return te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face.func_176734_d()).isPresent();
    }

    public boolean isTubeCompatible(TubeBlock tube) {
        return true;
    }

    public static List<Direction> getConnectedDirections(BlockState state) {
        Block block = state.func_177230_c();
        ArrayList<Direction> dirs = new ArrayList<Direction>();
        if (block instanceof TubeBlock) {
            for (Direction dir : Direction.values()) {
                if (!((Boolean)state.func_177229_b((IProperty)SixWayBlock.field_196491_B.get(dir))).booleanValue()) continue;
                dirs.add(dir);
            }
        }
        return dirs;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{DOWN, UP, NORTH, SOUTH, WEST, EAST, WATERLOGGED});
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return (BlockState)stateIn.func_206870_a((IProperty)SixWayBlock.field_196491_B.get(facing), (Comparable)Boolean.valueOf(this.canConnectTo((IBlockReader)worldIn, currentPos, facing)));
    }

    protected VoxelShape[] makeShapes() {
        double MIN_VOXEL = 0.0;
        double ONE_QUARTER = 4.0;
        double THREE_QUARTERS = 12.0;
        double SIX_SIXTEENTHS = 6.0;
        double TEN_SIXTEENTHS = 10.0;
        double MAX_VOXEL = 16.0;
        VoxelShape[] shapes = new VoxelShape[64];
        VoxelShape core = Block.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
        VoxelShape down = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)12.0, (double)10.0);
        VoxelShape up = Block.func_208617_a((double)6.0, (double)12.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
        VoxelShape north = Block.func_208617_a((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)4.0);
        VoxelShape south = Block.func_208617_a((double)6.0, (double)6.0, (double)12.0, (double)10.0, (double)10.0, (double)16.0);
        VoxelShape west = Block.func_208617_a((double)0.0, (double)6.0, (double)6.0, (double)12.0, (double)10.0, (double)10.0);
        VoxelShape east = Block.func_208617_a((double)12.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
        VoxelShape[] dunswe = new VoxelShape[]{down, up, north, south, west, east};
        for (int i = 0; i < 64; ++i) {
            shapes[i] = core;
            for (int j = 0; j < 6; ++j) {
                if ((i & 1 << j) == 0) continue;
                shapes[i] = VoxelShapes.func_197872_a((VoxelShape)shapes[i], (VoxelShape)dunswe[j]);
            }
        }
        return shapes;
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_196954_c(worldIn, pos);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.func_220053_a(state, worldIn, pos, context);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.shapes[this.getShapeIndex(state)];
    }

    public int getShapeIndex(BlockState state) {
        int index = 0;
        for (int j = 0; j < FACING_VALUES.length; ++j) {
            if (!((Boolean)state.func_177229_b((IProperty)SixWayBlock.field_196491_B.get(FACING_VALUES[j]))).booleanValue()) continue;
            index |= 1 << j;
        }
        return index;
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) == false && fluidIn == Fluids.field_204546_a;
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, IFluidState fluidStateIn) {
        if (!((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue() && fluidStateIn.func_206886_c() == Fluids.field_204546_a) {
            if (!worldIn.func_201670_d()) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
                worldIn.func_205219_F_().func_205360_a(pos, (Object)fluidStateIn.func_206886_c(), fluidStateIn.func_206886_c().func_205569_a((IWorldReader)worldIn));
            }
            return true;
        }
        return false;
    }

    public Fluid func_204508_a(IWorld worldIn, BlockPos pos, BlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
            return Fluids.field_204546_a;
        }
        return Fluids.field_204541_a;
    }

    public IFluidState func_204507_t(BlockState state) {
        HashMap map = new HashMap();
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }
}

