/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.crafting.block;

import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Collections;
import net.darkhax.bookshelf.crafting.block.BlockIngredient;
import net.darkhax.bookshelf.crafting.block.IBlockResolver;
import net.minecraft.block.Block;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockResolver
implements IBlockResolver {
    private final Block block;
    private final Collection<Block> collection;

    public BlockResolver(Block block) {
        this.block = block;
        this.collection = Collections.unmodifiableCollection(Collections.singleton(block));
    }

    @Override
    public JsonObject serialize() {
        JsonObject blockObject = new JsonObject();
        blockObject.addProperty("type", this.getTypeId().toString());
        blockObject.addProperty("block", this.block.getRegistryName().toString());
        return blockObject;
    }

    @Override
    public Collection<Block> resolveBlocks() {
        return this.collection;
    }

    @Override
    public void serialize(PacketBuffer buffer) {
        buffer.func_180714_a(this.getTypeId().toString());
        buffer.func_192572_a(this.block.getRegistryName());
    }

    public static BlockResolver deserialize(JsonObject json) {
        ResourceLocation id = new ResourceLocation(json.get("block").getAsString());
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(id);
        if (block == null) {
            throw new IllegalArgumentException("Failed to find block with ID " + id.toString());
        }
        return new BlockResolver(block);
    }

    public static BlockResolver deserialize(PacketBuffer buffer) {
        ResourceLocation id = buffer.func_192575_l();
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(id);
        if (block == null) {
            throw new IllegalArgumentException("Failed to find block with ID " + id.toString());
        }
        return new BlockResolver(block);
    }

    @Override
    public ResourceLocation getTypeId() {
        return BlockIngredient.TYPE_BLOCK;
    }
}

