/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.client;

import java.util.List;
import javax.annotation.Nullable;
import net.blay09.mods.craftingtweaks.CraftingTweaks;
import net.blay09.mods.craftingtweaks.CraftingTweaksProviderManager;
import net.blay09.mods.craftingtweaks.api.TweakProvider;
import net.blay09.mods.craftingtweaks.client.ClientProvider;
import net.blay09.mods.craftingtweaks.client.CraftingTweaksClient;
import net.blay09.mods.craftingtweaks.client.GuiImageButton;
import net.blay09.mods.craftingtweaks.client.ITooltipProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;

public abstract class GuiTweakButton
extends GuiImageButton
implements ITooltipProvider {
    private final TweakOption tweakOption;
    private final int tweakId;
    private final ContainerScreen<?> parentGui;
    private int lastGuiLeft;
    private int lastGuiTop;

    public GuiTweakButton(@Nullable ContainerScreen<?> parentGui, int xPosition, int yPosition, int texCoordX, int texCoordY, TweakOption tweakOption, int tweakId) {
        super(xPosition, yPosition, texCoordX, texCoordY);
        this.parentGui = parentGui;
        this.tweakOption = tweakOption;
        this.tweakId = tweakId;
    }

    public TweakOption getTweakOption() {
        return this.tweakOption;
    }

    public int getTweakId() {
        return this.tweakId;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int oldX = this.x;
        int oldY = this.y;
        if (this.parentGui != null) {
            this.x += this.lastGuiLeft;
            this.y += this.lastGuiTop;
        }
        boolean result = super.mouseClicked(mouseX, mouseY, button);
        this.x = oldX;
        this.y = oldY;
        return result;
    }

    public void onClick(double mouseX, double mouseY) {
        this.playDownSound(Minecraft.func_71410_x().func_147118_V());
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        Container container = player.field_71070_bA;
        TweakProvider<Container> provider = CraftingTweaksProviderManager.getProvider(container);
        if (provider != null) {
            ClientProvider clientProvider = CraftingTweaks.craftingTweaksClient.map(CraftingTweaksClient::getClientProvider).orElseThrow(() -> new IllegalStateException("Missing CraftingTweaks ClientProvider."));
            this.onTweakButtonClicked((PlayerEntity)player, container, provider, clientProvider);
        }
    }

    protected abstract void onTweakButtonClicked(PlayerEntity var1, Container var2, TweakProvider<Container> var3, ClientProvider var4);

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        int oldX = this.x;
        int oldY = this.y;
        if (this.parentGui != null) {
            this.lastGuiLeft = this.parentGui.getGuiLeft();
            this.lastGuiTop = this.parentGui.getGuiTop();
            this.x += this.lastGuiLeft;
            this.y += this.lastGuiTop;
        }
        int oldTexCoordX = this.texCoordX;
        if (Screen.hasShiftDown()) {
            this.texCoordX += 48;
        }
        super.render(mouseX, mouseY, partialTicks);
        this.texCoordX = oldTexCoordX;
        this.x = oldX;
        this.y = oldY;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        int oldX = this.x;
        int oldY = this.y;
        if (this.parentGui != null) {
            this.lastGuiLeft = this.parentGui.getGuiLeft();
            this.lastGuiTop = this.parentGui.getGuiTop();
            this.x += this.lastGuiLeft;
            this.y += this.lastGuiTop;
        }
        boolean result = super.isMouseOver(mouseX, mouseY);
        this.x = oldX;
        this.y = oldY;
        return result;
    }

    @Override
    public void addInformation(List<String> tooltip) {
        switch (this.tweakOption) {
            case Rotate: {
                tooltip.add(I18n.func_135052_a((String)"tooltip.craftingtweaks.rotate", (Object[])new Object[0]));
                break;
            }
            case Clear: {
                if (Screen.hasShiftDown()) {
                    tooltip.add(I18n.func_135052_a((String)"tooltip.craftingtweaks.forceClear", (Object[])new Object[0]));
                    tooltip.add("\u00a77" + I18n.func_135052_a((String)"tooltip.craftingtweaks.forceClearInfo", (Object[])new Object[0]));
                    break;
                }
                tooltip.add(I18n.func_135052_a((String)"tooltip.craftingtweaks.clear", (Object[])new Object[0]));
                break;
            }
            case Balance: {
                if (Screen.hasShiftDown()) {
                    tooltip.add(I18n.func_135052_a((String)"tooltip.craftingtweaks.spread", (Object[])new Object[0]));
                    break;
                }
                tooltip.add(I18n.func_135052_a((String)"tooltip.craftingtweaks.balance", (Object[])new Object[0]));
            }
        }
    }

    public static enum TweakOption {
        Rotate,
        Balance,
        Clear;

    }
}

