/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.gui.preview;

import com.terraforged.core.cell.Cell;
import com.terraforged.core.world.GeneratorContext;
import com.terraforged.core.world.heightmap.Levels;
import com.terraforged.core.world.terrain.Terrain;
import java.awt.Color;
import me.dags.noise.util.NoiseUtil;

public enum RenderMode {
    BIOME_TYPE,
    TEMPERATURE,
    MOISTURE,
    BIOME_SHAPE;


    public Color color(Cell<Terrain> cell, GeneratorContext context) {
        float baseHeight = Levels.getSeaLevel(context.settings.generator);
        if (cell.value < baseHeight) {
            return new Color(40, 140, 200);
        }
        float bands = 10.0f;
        float alpha = 0.2f;
        float elevation = (cell.value - baseHeight) / (1.0f - baseHeight);
        int band = NoiseUtil.round(elevation * bands);
        float scale = 1.0f - alpha;
        float bias = alpha * ((float)band / bands);
        float saturation = 0.7f;
        float brightness = 0.8f;
        switch (this) {
            case BIOME_SHAPE: {
                return Color.getHSBColor(cell.biome, saturation, brightness);
            }
            case BIOME_TYPE: {
                Color color = cell.biomeType.getColor();
                float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), new float[3]);
                return Color.getHSBColor(hsb[0], hsb[1], hsb[2] * scale + bias);
            }
            case MOISTURE: {
                return Color.getHSBColor(RenderMode.step(cell.moisture, 8) * 0.65f, saturation, brightness);
            }
            case TEMPERATURE: {
                return Color.getHSBColor(RenderMode.step(1.0f - cell.temperature, 8) * 0.65f, saturation, brightness);
            }
        }
        return Color.black;
    }

    private static float step(float value, int steps) {
        return (float)NoiseUtil.round(value * (float)steps) / (float)steps;
    }

    public static int rgba(Color color) {
        return color.getRed() + (color.getGreen() << 8) + (color.getBlue() << 16) + -16777216;
    }
}

