/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.data;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.terraforged.core.world.biome.BiomeType;
import com.terraforged.mod.biome.map.BiomeMap;
import com.terraforged.mod.biome.provider.BiomeHelper;
import com.terraforged.mod.data.DataGen;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;

public class WorldGenBiomes
extends DataGen {
    public static void genBiomeMap(File dataDir) {
        BiomeMap map = BiomeHelper.getDefaultBiomeMap();
        for (BiomeType type : BiomeType.values()) {
            WorldGenBiomes.genBiomes(dataDir, type, map);
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(new File("biome_map.json")));){
            new GsonBuilder().setPrettyPrinting().create().toJson(map.toJson(), (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void genBiomes(File dir, BiomeType type, BiomeMap map) {
        String path = WorldGenBiomes.getJsonPath("tags/biomes", WorldGenBiomes.getName(type));
        WorldGenBiomes.write(new File(dir, path), (Writer writer) -> {
            Set<Biome> biomes = map.getBiomes(type);
            JsonObject root = new JsonObject();
            JsonArray values = new JsonArray();
            root.addProperty("replaceable", Boolean.valueOf(false));
            root.add("values", (JsonElement)values);
            biomes.stream().map(b -> b.getRegistryName() + "").sorted().forEach(arg_0 -> ((JsonArray)values).add(arg_0));
            WorldGenBiomes.write((JsonElement)root, writer);
        });
    }

    private static ResourceLocation getName(BiomeType type) {
        return new ResourceLocation("terraforged", type.name().toLowerCase());
    }
}

