/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.map;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.terraforged.core.util.grid.FixedList;
import com.terraforged.core.util.grid.MappedList;
import com.terraforged.core.world.biome.BiomeType;
import com.terraforged.mod.biome.map.AbstractBiomeMap;
import com.terraforged.mod.biome.map.BiomeGroup;
import com.terraforged.mod.biome.map.BiomeMapBuilder;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;

public class GridBiomeMap
extends AbstractBiomeMap {
    private final BiomeGroup[] biomeTypes;

    GridBiomeMap(BiomeMapBuilder builder) {
        super(builder);
        this.biomeTypes = builder.biomeGroups();
    }

    @Override
    public Biome getBiome(BiomeType type, float temperature, float moisture, float shape) {
        BiomeGroup group = this.biomeTypes[type.ordinal()];
        if (group == null) {
            return Biomes.field_76778_j;
        }
        return group.biomes.get(moisture, temperature, shape);
    }

    @Override
    public List<Biome> getAllBiomes(BiomeType type) {
        BiomeGroup group = this.biomeTypes[type.ordinal()];
        if (group == null) {
            return Collections.emptyList();
        }
        LinkedList<Biome> biomes = new LinkedList<Biome>();
        for (MappedList<FixedList<Biome>> mappedList : group.biomes) {
            for (FixedList fixedList : mappedList) {
                for (Biome biome : fixedList) {
                    biomes.add(biome);
                }
            }
        }
        return biomes;
    }

    @Override
    public Set<Biome> getBiomes(BiomeType type) {
        BiomeGroup group = this.biomeTypes[type.ordinal()];
        if (group == null) {
            return Collections.emptySet();
        }
        HashSet<Biome> biomes = new HashSet<Biome>();
        for (MappedList<FixedList<Biome>> mappedList : group.biomes) {
            for (FixedList fixedList : mappedList) {
                for (Biome biome : fixedList) {
                    biomes.add(biome);
                }
            }
        }
        return biomes;
    }

    @Override
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        for (BiomeType type : BiomeType.values()) {
            BiomeGroup group = this.biomeTypes[type.ordinal()];
            JsonObject grid = new JsonObject();
            if (group != null) {
                int rowCount = 0;
                float maxRow = group.biomes.size() - 1;
                for (MappedList<FixedList<Biome>> mappedList : group.biomes) {
                    int colCount = 0;
                    float maxCol = mappedList.size() - 1;
                    JsonObject rowJson = new JsonObject();
                    for (FixedList fixedList : mappedList) {
                        JsonArray colJson = new JsonArray();
                        for (Biome biome : fixedList.uniqueValues()) {
                            colJson.add(biome.getRegistryName() + "");
                        }
                        float colId = (float)colCount / maxCol;
                        rowJson.add("" + colId, (JsonElement)colJson);
                        ++colCount;
                    }
                    float rowId = (float)rowCount / maxRow;
                    grid.add("" + rowId, (JsonElement)rowJson);
                    ++rowCount;
                }
            }
            root.add(type.name(), (JsonElement)grid);
        }
        return root;
    }
}

