/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod;

import com.terraforged.api.material.WGTags;
import com.terraforged.feature.FeatureManager;
import com.terraforged.mod.Log;
import com.terraforged.mod.TerraWorld;
import com.terraforged.mod.command.TerraCommand;
import com.terraforged.mod.data.DataGen;
import com.terraforged.mod.feature.decorator.poisson.PoissonAtSurface;
import com.terraforged.mod.feature.feature.DiskFeature;
import com.terraforged.mod.feature.tree.SaplingManager;
import com.terraforged.mod.settings.SettingsHelper;
import com.terraforged.mod.util.DataPackFinder;
import com.terraforged.mod.util.Environment;
import java.io.File;
import net.minecraft.resources.IPackFinder;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="terraforged")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TerraForgedMod {
    @SubscribeEvent
    public static void setup(FMLCommonSetupEvent event) {
        Log.info("Common setup", new Object[0]);
        WGTags.init();
        TerraWorld.init();
        SaplingManager.init();
        TerraCommand.init();
        SettingsHelper.moveSettings();
        BiomeDictionary.addTypes((Biome)Biomes.field_222370_aw, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((Biome)Biomes.field_222371_ax, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.OVERWORLD});
    }

    @SubscribeEvent
    public static void complete(FMLLoadCompleteEvent event) {
        if (Environment.isDev()) {
            DataGen.dumpData();
        }
    }

    @SubscribeEvent
    public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
        Log.info("Registering features", new Object[0]);
        FeatureManager.registerTemplates(event);
        event.getRegistry().register((IForgeRegistryEntry)DiskFeature.INSTANCE);
    }

    @SubscribeEvent
    public static void registerDecorators(RegistryEvent.Register<Placement<?>> event) {
        Log.info("Registering decorators", new Object[0]);
        event.getRegistry().register((IForgeRegistryEntry)new PoissonAtSurface());
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ForgeEvents {
        @SubscribeEvent
        public static void serverStart(FMLServerAboutToStartEvent event) {
            Log.info("Adding DataPackFinder", new Object[0]);
            File dir = event.getServer().func_71209_f("config/terraforged/datapacks");
            DataPackFinder dataPackFinder = new DataPackFinder(dir);
            event.getServer().func_195561_aH().func_198982_a((IPackFinder)dataPackFinder);
        }
    }
}

