/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.world.heightmap;

import com.terraforged.core.settings.GeneratorSettings;
import me.dags.noise.util.NoiseUtil;

public class Levels {
    public final int worldHeight;
    public final float unit;
    public final int waterY;
    private final int groundY;
    public final int groundLevel;
    public final int waterLevel;
    public final float ground;
    public final float water;

    public Levels(GeneratorSettings settings) {
        this.worldHeight = Math.max(1, settings.world.worldHeight);
        this.unit = NoiseUtil.div(1, this.worldHeight);
        this.waterLevel = settings.world.seaLevel;
        this.groundLevel = this.waterLevel + 1;
        this.waterY = Math.min(this.waterLevel - 1, this.worldHeight);
        this.groundY = Math.min(this.groundLevel - 1, this.worldHeight);
        this.ground = NoiseUtil.div(this.groundY, this.worldHeight);
        this.water = NoiseUtil.div(this.waterY, this.worldHeight);
    }

    public int scale(float value) {
        if (value >= 1.0f) {
            return this.worldHeight - 1;
        }
        return (int)(value * (float)this.worldHeight);
    }

    public float scale(int level) {
        return NoiseUtil.div(level, this.worldHeight);
    }

    public float water(int amount) {
        return NoiseUtil.div(this.waterY + amount, this.worldHeight);
    }

    public float ground(int amount) {
        return NoiseUtil.div(this.groundY + amount, this.worldHeight);
    }

    public static float getSeaLevel(GeneratorSettings settings) {
        int worldHeight = Math.max(1, settings.world.worldHeight);
        int waterLevel = Math.min(settings.world.seaLevel, worldHeight);
        return NoiseUtil.div(waterLevel, worldHeight);
    }
}

