/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.util.grid;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import me.dags.noise.util.NoiseUtil;

public class FixedList<T>
implements Iterable<T> {
    private final int maxIndex;
    private final T[] elements;

    FixedList(T[] elements) {
        this.maxIndex = elements.length - 1;
        this.elements = elements;
    }

    public T get(int index) {
        if (index < 0) {
            return this.elements[0];
        }
        if (index > this.maxIndex) {
            return this.elements[this.maxIndex];
        }
        return this.elements[index];
    }

    public T get(float value) {
        return this.get(this.indexOf(value));
    }

    public int size() {
        return this.elements.length;
    }

    public int indexOf(float value) {
        return NoiseUtil.round(value * (float)this.maxIndex);
    }

    public Set<T> uniqueValues() {
        HashSet set = new HashSet();
        Collections.addAll(set, this.elements);
        return set;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < FixedList.this.elements.length;
            }

            @Override
            public T next() {
                return FixedList.this.elements[this.index++];
            }
        };
    }

    public static <T> FixedList<T> of(List<T> list) {
        return new FixedList<Object>(list.toArray());
    }
}

