/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.util.concurrent;

import com.terraforged.core.util.concurrent.WorkerFactory;
import com.terraforged.core.util.concurrent.batcher.AsyncBatcher;
import com.terraforged.core.util.concurrent.batcher.Batcher;
import com.terraforged.core.util.concurrent.batcher.SyncBatcher;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;

public class ThreadPool
implements Executor {
    private static final ThreadPool instance = ThreadPool.create("TF", ThreadPool.defaultPoolSize());
    private final ForkJoinPool service;

    private ThreadPool(ForkJoinPool service) {
        this.service = service;
    }

    @Override
    public void execute(Runnable command) {
        this.service.submit(command);
    }

    public ForkJoinTask<?> submit(Runnable runnable) {
        return this.service.submit(runnable);
    }

    public <T> ForkJoinTask<T> submit(Callable<T> callable) {
        return this.service.submit((Callable)callable);
    }

    public Batcher batcher(int size) {
        return new AsyncBatcher(this.service, size);
    }

    public static ThreadPool getPool() {
        return instance;
    }

    public static ThreadPool create(String name, int size) {
        if (size < 2) {
            return new SingleThreadExecutor();
        }
        return new ThreadPool(ThreadPool.createPool(name, size));
    }

    public static ForkJoinPool createPool(String name, int size) {
        return new ForkJoinPool(size, new WorkerFactory.ForkJoin(name), null, true);
    }

    private static int defaultPoolSize() {
        int threads = Runtime.getRuntime().availableProcessors();
        return Math.max(1, (int)((float)threads / 3.0f * 2.0f));
    }

    private static class SingleThreadExecutor
    extends ThreadPool {
        private SingleThreadExecutor() {
            super(null);
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }

        @Override
        public ForkJoinTask<?> submit(Runnable runnable) {
            ForkJoinTask<?> task = ForkJoinTask.adapt(runnable);
            task.invoke();
            return task;
        }

        @Override
        public <T> ForkJoinTask<T> submit(Callable<T> callable) {
            ForkJoinTask<T> task = ForkJoinTask.adapt(callable);
            task.invoke();
            return task;
        }

        @Override
        public Batcher batcher(int size) {
            return new SyncBatcher();
        }
    }
}

