/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.IRelatedUnit;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.units.UnitProperties;

public class RelatedUnit
implements IRelatedUnit {
    private final UnitConfig config;
    private final UnitId id;

    public RelatedUnit(UnitConfig config, UnitId id) {
        this.config = config;
        this.id = UnitConfig.getUnitId(config, this.getClassCategory(), "id", id, "Id is a basic unit (block or item) identifier in <modId:unitName:meta> format.\nModId can be omitted for vanilla items. Meta can be omitted too if it equals 0.\nUnitName must be lowercase, words separated by '_', words order - from private to common (example: black_iron_ore).\nUse '*' char or '[]' as meta value to specify all possible values (all block states).\nTo define multiple block states, you can use block properties. The format is <modId:blockName:[prop1=value1, prop2=value2]>\nAlso you may use tags. The format is <#modId:tagPath> (example: #forge:ores/copper \n");
        this.saveConfig();
    }

    @Override
    public UnitConfig getConfig() {
        return this.config;
    }

    @Override
    public UnitId getRelatedId() {
        return this.id;
    }

    public static class Properties<T extends Properties<T>>
    extends UnitProperties<T> {
        public UnitId id = UnitId.EMPTY;

        protected Properties(Class<T> selfClass) {
            super(selfClass);
        }

        public T id(UnitId id) {
            this.id = id;
            return (T)((Properties)this.self);
        }

        public T id(String id) {
            UnitId unitId = id.isEmpty() ? UnitId.EMPTY : UnitId.from(id);
            return this.id(unitId);
        }

        public T enumId(String metadata) {
            this.id = UnitId.EMPTY.withMetaData(metadata);
            return (T)((Properties)this.self);
        }

        public T ifEmptySetIdFrom(Enum<?> e) {
            if (this.id.isEmpty()) {
                this.id = UnitId.from(e, this.id.getMetaData());
            }
            return (T)((Properties)this.self);
        }
    }
}

