/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.blocks;

import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.data.Names;
import com.endertech.minecraft.forge.items.ForgeBlockItem;
import com.endertech.minecraft.forge.units.IRelatedUnit;
import com.endertech.minecraft.forge.units.RelatedUnit;
import com.endertech.minecraft.forge.units.UnitId;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;

public class RelatedBlock
extends ForgeBlock
implements IRelatedUnit {
    private final UnitId relatedBlockId;

    public RelatedBlock(ForgeMod mod, UnitConfig config, Properties<?> props) {
        super(mod, config, props.name, props.block);
        this.relatedBlockId = props.id;
    }

    @Override
    public UnitId getRelatedId() {
        return this.relatedBlockId;
    }

    @Override
    public String getClassRegName() {
        return "";
    }

    public Material func_149688_o(BlockState state) {
        return this.getRelatedState() != null ? this.getRelatedState().func_185904_a() : super.func_149688_o(state);
    }

    public float func_176195_g(BlockState blockState, IBlockReader worldIn, BlockPos pos) {
        return this.getRelatedState() != null ? this.getRelatedState().func_185887_b(worldIn, pos) : super.func_176195_g(blockState, worldIn, pos);
    }

    public float getExplosionResistance(BlockState state, IWorldReader world, BlockPos pos, Entity exploder, Explosion explosion) {
        return this.getRelatedState() != null ? this.getRelatedState().getExplosionResistance(world, pos, exploder, explosion) : super.getExplosionResistance(state, world, pos, exploder, explosion);
    }

    public MaterialColor func_180659_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return this.getRelatedState() != null ? this.getRelatedState().func_185909_g(worldIn, pos) : super.func_180659_g(state, worldIn, pos);
    }

    @Nullable
    public BlockState getRelatedState() {
        return this.getRelatedId() != null ? this.getRelatedId().getFirstMatchedState() : null;
    }

    public boolean exists() {
        return this.getRelatedState() != null;
    }

    public int func_149750_m(BlockState state) {
        return this.getRelatedState() != null ? this.getRelatedState().func_185906_d() : super.func_149750_m(state);
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return this.getRelatedState() != null ? this.getRelatedState().getLightValue(world, pos) : super.getLightValue(state, world, pos);
    }

    public int func_200011_d(BlockState state, IBlockReader world, BlockPos pos) {
        return super.func_200011_d(state, world, pos);
    }

    public SoundType func_220072_p(BlockState state) {
        return this.getRelatedState() != null ? this.getRelatedState().func_215695_r() : super.func_220072_p(state);
    }

    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, Entity entity) {
        return this.getRelatedState() != null ? this.getRelatedState().getSoundType(world, pos, entity) : super.getSoundType(state, world, pos, entity);
    }

    public static class Item
    extends ForgeBlockItem {
        public Item(Block block, Item.Properties props) {
            super(block, props);
        }

        @Override
        protected boolean func_194125_a(ItemGroup group) {
            RelatedBlock block;
            if (this.func_179223_d() instanceof RelatedBlock && !(block = (RelatedBlock)this.func_179223_d()).exists()) {
                return false;
            }
            return super.func_194125_a(group);
        }
    }

    public static class Properties<T extends Properties<T>>
    extends RelatedUnit.Properties<T> {
        public String name = "";
        public Block.Properties block = Block.Properties.func_200950_a((Block)Blocks.field_150350_a);

        protected Properties(Class<T> selfClass) {
            super(selfClass);
        }

        public static Properties<?> withId(UnitId relatedBlockId) {
            Properties<Properties> props = new Properties<Properties>(Properties.class);
            return ((Properties)((Properties)props.id(relatedBlockId)).name(relatedBlockId.getRegName())).propsFromRelatedBlock();
        }

        public T name(String name) {
            this.name = name;
            return (T)((Properties)this.self);
        }

        public T nameSuffix(String suffix) {
            return this.name(Names.registry().join(this.name, suffix));
        }

        public T block(Block.Properties block) {
            this.block = block;
            return (T)((Properties)this.self);
        }

        public T propsFromRelatedBlock() {
            return this.block(this.id.getBlockProperties());
        }
    }
}

