/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.item;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.silentchaos512.lib.SilentLib;
import net.silentchaos512.lib.util.LootUtils;
import net.silentchaos512.lib.util.PlayerUtils;

public class LootContainerItem
extends Item {
    private static final String NBT_ROOT = "silentlib.LootContainer";
    private static final String NBT_LOOT_TABLE = "LootTable";
    private static final boolean DEFAULT_LIST_ITEMS_RECEIVED = true;
    private final ResourceLocation defaultLootTable;
    private final boolean listItemsReceived;

    public LootContainerItem(ResourceLocation defaultLootTable) {
        this(defaultLootTable, true, new Item.Properties());
    }

    public LootContainerItem(ResourceLocation defaultLootTable, boolean listItemsReceived) {
        this(defaultLootTable, listItemsReceived, new Item.Properties());
    }

    public LootContainerItem(ResourceLocation defaultLootTable, Item.Properties properties) {
        this(defaultLootTable, true, properties);
    }

    public LootContainerItem(ResourceLocation defaultLootTable, boolean listItemsReceived, Item.Properties properties) {
        super(properties);
        this.defaultLootTable = defaultLootTable;
        this.listItemsReceived = listItemsReceived;
    }

    public ItemStack getStack() {
        return this.getStack(this.defaultLootTable);
    }

    public ItemStack getStack(ResourceLocation lootTable) {
        ItemStack result = new ItemStack((IItemProvider)this);
        LootContainerItem.getData(result).func_74778_a(NBT_LOOT_TABLE, lootTable.toString());
        return result;
    }

    protected static CompoundNBT getData(ItemStack stack) {
        return stack.func_190925_c(NBT_ROOT);
    }

    protected ResourceLocation getLootTable(ItemStack stack) {
        String str;
        ResourceLocation table;
        CompoundNBT tags = LootContainerItem.getData(stack);
        if (tags.func_74764_b(NBT_LOOT_TABLE) && (table = ResourceLocation.func_208304_a((String)(str = tags.func_74779_i(NBT_LOOT_TABLE)))) != null) {
            return table;
        }
        return this.defaultLootTable;
    }

    public static void setLootTable(ItemStack stack, ResourceLocation lootTable) {
        LootContainerItem.getData(stack).func_74778_a(NBT_LOOT_TABLE, lootTable.toString());
    }

    protected Collection<ItemStack> getLootDrops(ItemStack heldItem, ServerPlayerEntity player) {
        return LootUtils.gift(this.getLootTable(heldItem), player);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (!flagIn.func_194127_a()) {
            return;
        }
        ITextComponent textTableName = new StringTextComponent(this.getLootTable(stack).toString()).func_211708_a(TextFormatting.WHITE);
        tooltip.add(new TranslationTextComponent("item.silentlib.lootContainer.table", new Object[]{textTableName}).func_211708_a(TextFormatting.BLUE));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack heldItem = playerIn.func_184586_b(handIn);
        if (!(playerIn instanceof ServerPlayerEntity)) {
            return ActionResult.func_226248_a_((Object)heldItem);
        }
        ServerPlayerEntity playerMP = (ServerPlayerEntity)playerIn;
        Collection<ItemStack> lootDrops = this.getLootDrops(heldItem, playerMP);
        if (lootDrops.isEmpty()) {
            SilentLib.LOGGER.warn("LootContainerItem has no drops? {}, table={}", (Object)heldItem, (Object)this.getLootTable(heldItem));
        }
        lootDrops.forEach(stack -> {
            PlayerUtils.giveItem((PlayerEntity)playerMP, stack);
            if (this.listItemsReceived) {
                LootContainerItem.listItemReceivedInChat(playerMP, stack);
            }
        });
        float pitch = ((playerMP.func_70681_au().nextFloat() - playerMP.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f;
        playerMP.field_70170_p.func_184133_a(null, playerMP.func_180425_c(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, pitch);
        heldItem.func_190918_g(1);
        return ActionResult.func_226248_a_((Object)heldItem);
    }

    private static void listItemReceivedInChat(ServerPlayerEntity playerMP, ItemStack stack) {
        TranslationTextComponent itemReceivedText = new TranslationTextComponent("item.silentlib.lootContainer.itemReceived", new Object[]{stack.func_190916_E(), stack.func_200301_q()});
        playerMP.func_145747_a((ITextComponent)itemReceivedText);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)this.getStack());
        }
    }
}

