/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.comforts.data;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BedPart;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.ConstantRange;
import net.minecraft.world.storage.loot.IRandomRange;
import net.minecraft.world.storage.loot.ItemLootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraft.world.storage.loot.StandaloneLootEntry;
import net.minecraft.world.storage.loot.conditions.BlockStateProperty;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.conditions.SurvivesExplosion;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import top.theillusivec4.comforts.common.ComfortsRegistry;

public class ComfortsBlockLootTables
extends BlockLootTables {
    private final Map<ResourceLocation, LootTable.Builder> lootBuilders = Maps.newHashMap();

    private static LootTable.Builder getLootBuilder(Block block) {
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_((IProperty)BedBlock.field_176472_a, (Comparable)BedPart.HEAD)))).func_212840_b_(SurvivesExplosion.func_215968_b())));
    }

    public void accept(BiConsumer<ResourceLocation, LootTable.Builder> lootBuilder) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        blocks.addAll(ComfortsRegistry.SLEEPING_BAGS.values());
        blocks.addAll(ComfortsRegistry.HAMMOCKS.values());
        blocks.forEach(block -> this.func_218522_a((Block)block, ComfortsBlockLootTables::getLootBuilder));
        HashSet set = Sets.newHashSet();
        for (Block block2 : blocks) {
            ResourceLocation resourcelocation = block2.func_220068_i();
            if (resourcelocation == LootTables.field_186419_a || !set.add(resourcelocation)) continue;
            LootTable.Builder loottable$builder = this.lootBuilders.remove(resourcelocation);
            if (loottable$builder == null) {
                throw new IllegalStateException(String.format("Missing loottable '%s' for '%s'", resourcelocation, ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block2)));
            }
            lootBuilder.accept(resourcelocation, loottable$builder);
        }
        if (!this.lootBuilders.isEmpty()) {
            throw new IllegalStateException("Created block loot tables for non-blocks: " + this.lootBuilders.keySet());
        }
    }
}

