/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedpipes.network.fluid;

import com.raoulvdberge.refinedpipes.network.Network;
import com.raoulvdberge.refinedpipes.network.NetworkFactory;
import com.raoulvdberge.refinedpipes.network.fluid.FluidNetwork;
import com.raoulvdberge.refinedpipes.network.pipe.fluid.FluidPipeType;
import com.raoulvdberge.refinedpipes.util.StringUtil;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FluidNetworkFactory
implements NetworkFactory {
    private static final Logger LOGGER = LogManager.getLogger(FluidNetworkFactory.class);
    private final FluidPipeType pipeType;

    public FluidNetworkFactory(FluidPipeType pipeType) {
        this.pipeType = pipeType;
    }

    @Override
    public Network create(BlockPos pos) {
        return new FluidNetwork(pos, StringUtil.randomString(new Random(), 8), this.pipeType);
    }

    @Override
    public Network create(CompoundNBT tag) {
        FluidNetwork network = new FluidNetwork(BlockPos.func_218283_e((long)tag.func_74763_f("origin")), tag.func_74779_i("id"), this.pipeType);
        if (tag.func_74764_b("tank")) {
            network.getFluidTank().readFromNBT(tag.func_74775_l("tank"));
        }
        LOGGER.debug("Deserialized fluid network {} of type {}", (Object)network.getId(), (Object)network.getType().toString());
        return network;
    }
}

