/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor;

import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElement;
import com.raoulvdberge.refinedstorage.api.render.IElementDrawers;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.util.PacketBufferUtils;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class ErrorCraftingMonitorElement
implements ICraftingMonitorElement {
    public static final ResourceLocation ID = new ResourceLocation("error");
    private ICraftingMonitorElement base;
    private String message;

    public ErrorCraftingMonitorElement(ICraftingMonitorElement base, String message) {
        this.base = base;
        this.message = message;
    }

    @Override
    public void draw(int x, int y, IElementDrawers drawers) {
        this.base.draw(x, y, drawers);
        drawers.getErrorDrawer().draw(x, y, null);
    }

    @Override
    @Nullable
    public String getTooltip() {
        return this.base.getTooltip() + "\n" + TextFormatting.RED + I18n.func_135052_a((String)this.message, (Object[])new Object[0]);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public ResourceLocation getBaseId() {
        return this.base.getId();
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.func_192572_a(this.base.getId());
        buf.func_180714_a(this.message);
        this.base.write(buf);
    }

    public static ErrorCraftingMonitorElement read(PacketBuffer buf) {
        ResourceLocation id = buf.func_192575_l();
        String message = PacketBufferUtils.readString(buf);
        return new ErrorCraftingMonitorElement(API.instance().getCraftingMonitorElementRegistry().get(id).apply(buf), message);
    }

    @Override
    public boolean merge(ICraftingMonitorElement element) {
        return this.elementHashCode() == element.elementHashCode() && this.base.merge(((ErrorCraftingMonitorElement)element).base);
    }

    @Override
    public int baseElementHashCode() {
        return this.base.elementHashCode();
    }

    @Override
    public int elementHashCode() {
        return this.base.elementHashCode() ^ this.message.hashCode();
    }

    public void mergeBases(ICraftingMonitorElement element) {
        this.base.merge(element);
    }
}

