/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network.packet;

import net.minecraft.advancements.Advancement;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.helper.AdvancementHelpers;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.cyclopscore.network.packet.SendPlayerAdvancementUnlockedPacket;

public class RequestPlayerAdvancementUnlockedPacket
extends PacketCodec {
    @CodecField
    private String advancementId;

    public RequestPlayerAdvancementUnlockedPacket() {
    }

    public RequestPlayerAdvancementUnlockedPacket(String advancementId) {
        this.advancementId = advancementId;
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(World world, PlayerEntity player) {
    }

    @Override
    public void actionServer(World world, ServerPlayerEntity player) {
        Advancement advancement = AdvancementHelpers.getAdvancement(Dist.DEDICATED_SERVER, new ResourceLocation(this.advancementId));
        if (advancement == null) {
            CyclopsCore.clog(Level.ERROR, "Received an invalid advancement " + this.advancementId + " from " + player.func_200200_C_());
            return;
        }
        CyclopsCore._instance.getPacketHandler().sendToPlayer(new SendPlayerAdvancementUnlockedPacket(this.advancementId, AdvancementHelpers.hasAdvancementUnlocked((PlayerEntity)player, advancement)), player);
    }
}

