/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.block;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;

public class BlockTile
extends ContainerBlock {
    private final Supplier<CyclopsTileEntity> tileEntitySupplier;

    public BlockTile(Block.Properties properties, Supplier<CyclopsTileEntity> tileEntitySupplier) {
        super(properties);
        this.tileEntitySupplier = tileEntitySupplier;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader world) {
        return this.tileEntitySupplier.get();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos blockPos, PlayerEntity player) {
        ItemStack itemStack = this.getDroppedItemStack(state, target, world, blockPos, player, super.getPickBlock(state, target, world, blockPos, player));
        if (this.isPersistNbt()) {
            TileHelpers.getSafeTile(world, blockPos, CyclopsTileEntity.class).ifPresent(tile -> {
                CompoundNBT compoundnbt = this.getDroppedItemStackNbt(state, target, world, blockPos, player, itemStack, (CyclopsTileEntity)tile);
                if (!compoundnbt.isEmpty()) {
                    itemStack.func_77983_a("BlockEntityTag", (INBT)compoundnbt);
                }
            });
        }
        return itemStack;
    }

    public List<ItemStack> func_220076_a(BlockState blockState, LootContext.Builder builder) {
        TileEntity tileEntity = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (tileEntity instanceof CyclopsTileEntity) {
            CyclopsTileEntity cyclopsTileEntity = (CyclopsTileEntity)tileEntity;
        }
        return super.func_220076_a(blockState, builder);
    }

    public void func_176208_a(World world, BlockPos blockPos, BlockState blockState, PlayerEntity player) {
        super.func_176208_a(world, blockPos, blockState, player);
    }

    protected ItemStack getDroppedItemStack(BlockState state, RayTraceResult target, IBlockReader world, BlockPos blockPos, PlayerEntity player, ItemStack originalItemStack) {
        return originalItemStack;
    }

    protected CompoundNBT getDroppedItemStackNbt(BlockState state, RayTraceResult target, IBlockReader world, BlockPos blockPos, PlayerEntity player, ItemStack itemStack, CyclopsTileEntity tile) {
        return tile.writeToItemStack(new CompoundNBT());
    }

    public boolean isPersistNbt() {
        return false;
    }
}

