/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager.menu;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import vswe.stevesfactory.library.gui.layout.FlowLayout;
import vswe.stevesfactory.library.gui.widget.NumberField;
import vswe.stevesfactory.library.gui.widget.RadioButton;
import vswe.stevesfactory.library.gui.widget.RadioController;
import vswe.stevesfactory.library.gui.widget.TextField;
import vswe.stevesfactory.library.gui.widget.TextList;
import vswe.stevesfactory.logic.procedure.RedstoneEmitterProcedure;
import vswe.stevesfactory.ui.manager.editor.FlowComponent;
import vswe.stevesfactory.ui.manager.editor.Menu;

public class EmitterTypeMenu
extends Menu<RedstoneEmitterProcedure> {
    private final TextList paragraph;
    private final NumberField<Integer> valueInput;
    private final Map<RedstoneEmitterProcedure.OperationType, RadioButton> type;

    public EmitterTypeMenu() {
        int y = HEADING_BOX.getPortionHeight() + 2;
        this.paragraph = new TextList(0, 20, new ArrayList<String>());
        this.paragraph.setLocation(4, y);
        this.paragraph.setFontHeight(7);
        this.addChildren(this.paragraph);
        this.valueInput = NumberField.integerFieldRanged(33, 12, 15, 1, 15);
        this.valueInput.alignRight(this.getWidth() - 4);
        this.valueInput.setY(y);
        this.valueInput.setBackgroundStyle(TextField.BackgroundStyle.RED_OUTLINE);
        this.paragraph.setWidth(this.valueInput.getX() - 4 - this.paragraph.getX());
        this.addChildren(this.valueInput);
        RadioController controller = new RadioController();
        this.type = new EnumMap<RedstoneEmitterProcedure.OperationType, RadioButton>(RedstoneEmitterProcedure.OperationType.class);
        for (RedstoneEmitterProcedure.OperationType type : RedstoneEmitterProcedure.OperationType.VALUES) {
            RadioButton box = new RadioButton(controller);
            box.setLabel(I18n.func_135052_a((String)type.nameKey, (Object[])new Object[0]));
            this.addChildren(box);
            this.type.put(type, box);
        }
        FlowLayout.reflow(4, 25, this.getWidth(), this.type);
    }

    @Override
    public void onLinkFlowComponent(FlowComponent<RedstoneEmitterProcedure> flowComponent) {
        super.onLinkFlowComponent(flowComponent);
        RedstoneEmitterProcedure procedure = (RedstoneEmitterProcedure)this.getLinkedProcedure();
        for (Map.Entry<RedstoneEmitterProcedure.OperationType, RadioButton> entry : this.type.entrySet()) {
            RadioButton box = entry.getValue();
            RedstoneEmitterProcedure.OperationType type = entry.getKey();
            box.onChecked = () -> {
                procedure.setOperationType(type);
                this.paragraph.getTexts().clear();
                this.paragraph.addLineSplit(I18n.func_135052_a((String)"menu.sfm.RedstoneEmitter.Type.Info", (Object[])new Object[0]));
            };
        }
        this.type.get((Object)procedure.getOperationType()).check(true);
        this.valueInput.setValue(procedure.getValue());
        this.valueInput.onValueUpdated = procedure::setValue;
    }

    @Override
    public String getHeadingText() {
        return I18n.func_135052_a((String)"menu.sfm.RedstoneEmitter.Type", (Object[])new Object[0]);
    }

    @Override
    public List<String> populateErrors(List<String> errors) {
        return errors;
    }
}

