/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager.menu;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.resources.I18n;
import vswe.stevesfactory.library.gui.RenderingHelper;
import vswe.stevesfactory.library.gui.widget.TextButton;
import vswe.stevesfactory.ui.manager.menu.DirectionButton;

class ActivationButton
extends TextButton {
    private DirectionButton target;

    public ActivationButton(DirectionButton target) {
        this.setTarget(target);
        this.setDimensions(42, 12);
    }

    public void setTarget(DirectionButton target) {
        this.target = target;
        this.updateText();
    }

    @Override
    protected void renderText() {
        RenderSystem.enableTexture();
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)(this.getAbsoluteX() + 3), (float)(this.getAbsoluteY() + 3), (float)0.0f);
        RenderSystem.scalef((float)0.7f, (float)0.7f, (float)1.0f);
        RenderingHelper.fontRenderer().func_211126_b(this.getText(), 0.0f, 0.0f, -11711155);
        RenderSystem.popMatrix();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isEnabled() && button == 0) {
            this.target.toggleSelected();
            this.updateText();
            return super.mouseClicked(mouseX, mouseY, button);
        }
        return false;
    }

    private void updateText() {
        this.text = this.target.isSelected() ? I18n.func_135052_a((String)"menu.sfm.Deactivate", (Object[])new Object[0]) : I18n.func_135052_a((String)"menu.sfm.Activate", (Object[])new Object[0]);
    }

    @Override
    public void render(int mouseX, int mouseY, float particleTicks) {
        if (this.isEnabled()) {
            super.render(mouseX, mouseY, particleTicks);
        }
    }

    public void setEditingState(boolean state) {
        super.setEnabled(state);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(false);
    }

    @Override
    public int getNormalBorderColor() {
        return -11842741;
    }

    @Override
    public int getHoveredBorderColor() {
        return -11842741;
    }

    @Override
    public int getNormalBackgroundColor() {
        return -6052957;
    }

    @Override
    public int getHoveredBackgroundColor() {
        return -4934476;
    }
}

