/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.library.gui.widget;

import java.util.function.Function;
import java.util.function.Predicate;
import vswe.stevesfactory.library.gui.widget.TextField;

public abstract class ValueField<V>
extends TextField {
    private Function<String, V> parser;
    private Function<V, String> stringifier;
    protected V value;

    public static <V> ExceptionBasedValueField<V> exceptionBasedValueField(int width, int height) {
        return ValueField.exceptionBasedValueField(0, 0, width, height);
    }

    public static <V> ExceptionBasedValueField<V> exceptionBasedValueField(int x, int y, int width, int height) {
        return new ExceptionBasedValueField(x, y, width, height);
    }

    public static <V> ValidatorBasedValueField<V> validatorBasedValueField(int width, int height) {
        return ValueField.validatorBasedValueField(0, 0, width, height);
    }

    public static <V> ValidatorBasedValueField<V> validatorBasedValueField(int x, int y, int width, int height) {
        return new ValidatorBasedValueField(x, y, width, height);
    }

    protected ValueField(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public void setValueFormat(Function<String, V> parser, Function<V, String> stringifier) {
        this.parser = parser;
        this.stringifier = stringifier;
    }

    @Override
    protected abstract boolean updateText(String var1);

    protected final void setInternalText(String text) {
        super.updateText(text);
    }

    public V getValue() {
        return this.value;
    }

    public void setValue(V number) {
        this.value = number;
        super.updateText(this.stringifier.apply(number));
    }

    public Function<String, V> getParser() {
        return this.parser;
    }

    public Function<V, String> getStringifier() {
        return this.stringifier;
    }

    public static class ValidatorBasedValueField<V>
    extends ValueField<V> {
        private Predicate<String> formatValidator;

        public ValidatorBasedValueField(int x, int y, int width, int height) {
            super(x, y, width, height);
        }

        @Override
        protected boolean updateText(String text) {
            if (this.formatValidator.test(text)) {
                this.setInternalText(text);
                this.value = this.getParser().apply(this.getText());
                return true;
            }
            return false;
        }

        @Override
        @Deprecated
        public void setValueFormat(Function<String, V> parser, Function<V, String> stringifier) {
            throw new UnsupportedOperationException();
        }

        public void setValueFormat(Predicate<String> formatValidator, Function<String, V> parser, Function<V, String> stringifier) {
            this.formatValidator = formatValidator;
            super.setValueFormat(parser, stringifier);
        }
    }

    public static class ExceptionBasedValueField<V>
    extends ValueField<V> {
        public ExceptionBasedValueField(int x, int y, int width, int height) {
            super(x, y, width, height);
        }

        @Override
        protected boolean updateText(String text) {
            try {
                this.value = this.getParser().apply(text);
                this.setInternalText(text);
                return true;
            }
            catch (RuntimeException runtimeException) {
                return false;
            }
        }

        @Override
        public void onFocusChanged(boolean focus) {
            if (!focus) {
                this.setText(this.getStringifier().apply(this.value));
            }
        }
    }
}

