/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.library.gui.contextmenu;

import java.awt.Dimension;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import vswe.stevesfactory.library.gui.RenderingHelper;
import vswe.stevesfactory.library.gui.contextmenu.ContextMenu;
import vswe.stevesfactory.library.gui.contextmenu.IEntry;
import vswe.stevesfactory.library.gui.debug.RenderEventDispatcher;
import vswe.stevesfactory.library.gui.widget.AbstractWidget;
import vswe.stevesfactory.library.gui.widget.mixin.LeafWidgetMixin;

public class DefaultEntry
extends AbstractWidget
implements IEntry,
LeafWidgetMixin {
    public static final int MARGIN_SIDES = 2;
    public static final int HALF_MARGIN_SIDES = 1;
    public static final int RENDERED_ICON_WIDTH = 8;
    public static final int RENDERED_ICON_HEIGHT = 8;
    private final ResourceLocation icon;
    private final String translationKey;

    public DefaultEntry(@Nullable ResourceLocation icon, String translationKey) {
        this.icon = icon;
        this.translationKey = translationKey;
        Dimension bounds = this.getDimensions();
        bounds.width = this.computeWidth();
        bounds.height = this.computeHeight();
    }

    @Override
    public void render(int mouseX, int mouseY, float particleTicks) {
        ResourceLocation icon;
        RenderEventDispatcher.onPreRender(this, mouseX, mouseY);
        int x = this.getAbsoluteX();
        int y = this.getAbsoluteY();
        int y2 = this.getAbsoluteYBottom();
        if (this.isInside(mouseX, mouseY)) {
            ContextMenu parent = this.getWindow();
            RenderingHelper.drawRect(x, y, parent.getContentX() + parent.getWidth() - parent.getBorderSize() * 2, y2, 59, 134, 255, 255);
        }
        if ((icon = this.getIcon()) != null) {
            int iconX = x + 2;
            int iconY = y + 2;
            RenderingHelper.drawCompleteTexture(iconX, iconY, iconX + 8, iconY + 8, icon);
        }
        int textX = x + 2 + 8 + 2;
        RenderingHelper.drawTextCenteredVertically(this.getText(), textX, y, y2, -1);
        RenderEventDispatcher.onPostRender(this, mouseX, mouseY);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.getWindow().alive = false;
        return true;
    }

    @Override
    @Nullable
    public ResourceLocation getIcon() {
        return this.icon;
    }

    @Override
    public String getTranslationKey() {
        return this.translationKey;
    }

    @Override
    public void attach(ContextMenu contextMenu) {
        this.setWindow(contextMenu);
    }

    @Override
    public ContextMenu getWindow() {
        return (ContextMenu)super.getWindow();
    }

    private int computeWidth() {
        return 12 + RenderingHelper.fontRenderer().func_78256_a(this.getText()) + 2;
    }

    private int computeHeight() {
        return 12;
    }
}

