/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.undo;

import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.BlockSnapshot;
import oreexcavation.core.OreExcavation;

public class BlockHistory {
    public final BlockPos pos;
    public final BlockState state;
    public final CompoundNBT tileData;

    public BlockHistory(BlockPos pos, BlockState state, CompoundNBT tileData) {
        this.pos = pos;
        this.state = state;
        this.tileData = tileData;
    }

    public BlockHistory(BlockSnapshot snapshot) {
        this.pos = snapshot.getPos();
        this.state = snapshot.getReplacedBlock();
        if (snapshot.getTileEntity() != null) {
            this.tileData = new CompoundNBT();
            try {
                snapshot.getTileEntity().func_189515_b(this.tileData);
            }
            catch (Exception e) {
                OreExcavation.logger.error("Unable to save undo state for tile entity: " + snapshot.getTileEntity().toString(), (Throwable)e);
            }
        } else {
            this.tileData = null;
        }
    }

    public BlockHistory(BlockSnapshot snapshot, CompoundNBT tileNBT) {
        this.pos = snapshot.getPos();
        this.state = snapshot.getReplacedBlock();
        this.tileData = tileNBT;
    }

    public void restoreBlock(World world) {
        world.func_180501_a(this.pos, this.state, 2);
        TileEntity tile = world.func_175625_s(this.pos);
        if (tile != null && this.tileData != null) {
            tile.func_145839_a(this.tileData);
        }
    }
}

