/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.melter;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.melter.TileMelter;
import com.lothrazar.cyclic.fluid.FluidBiomassHolder;
import com.lothrazar.cyclic.fluid.FluidHoneyHolder;
import com.lothrazar.cyclic.fluid.FluidMagmaHolder;
import com.lothrazar.cyclic.fluid.FluidSlimeHolder;
import com.lothrazar.cyclic.fluid.FluidXpJuiceHolder;
import com.lothrazar.cyclic.recipe.CyclicRecipe;
import com.lothrazar.cyclic.recipe.CyclicRecipeType;
import com.lothrazar.cyclic.registry.ItemRegistry;
import com.lothrazar.cyclic.util.UtilItemStack;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class RecipeMelter<TileEntityBase>
extends CyclicRecipe {
    public static List<RecipeMelter> RECIPES = new ArrayList<RecipeMelter>();
    private NonNullList<Ingredient> ingredients = NonNullList.func_191196_a();
    private FluidStack outFluid;
    private static Set<String> hashes = new HashSet<String>();

    protected RecipeMelter(ResourceLocation id, ItemStack in, ItemStack inSecond, FluidStack out) {
        super(id);
        this.ingredients.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{in}));
        this.ingredients.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{inSecond}));
        this.outFluid = out;
    }

    public boolean matches(TileEntityBase inv, World worldIn) {
        try {
            TileMelter tile = (TileMelter)inv;
            return this.matches(tile, 0) && this.matches(tile, 1);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public boolean matches(TileMelter tile, int slot) {
        ItemStack current = tile.getStackInputSlot(slot);
        Ingredient ing = (Ingredient)this.ingredients.get(slot);
        for (ItemStack test : ing.func_193365_a()) {
            if (!UtilItemStack.matches(current, test)) continue;
            return true;
        }
        return false;
    }

    public ItemStack[] ingredientAt(int slot) {
        Ingredient ing = (Ingredient)this.ingredients.get(slot);
        return ing.func_193365_a();
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.ingredients;
    }

    @Override
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @Override
    public FluidStack getRecipeFluid() {
        return this.outFluid.copy();
    }

    public IRecipeType<?> func_222127_g() {
        return CyclicRecipeType.MELTER;
    }

    public static void initAllRecipes() {
        hashes = new HashSet<String>();
        RecipeMelter.addRecipe("snowwater", new ItemStack((IItemProvider)Blocks.field_196604_cC), new ItemStack((IItemProvider)Blocks.field_196604_cC), new FluidStack((Fluid)Fluids.field_204546_a, 200));
        RecipeMelter.addRecipe("icetowater", new ItemStack((IItemProvider)Blocks.field_150432_aD), new ItemStack((IItemProvider)Blocks.field_150432_aD), new FluidStack((Fluid)Fluids.field_204546_a, 2000));
        RecipeMelter.addRecipe("fbio", new ItemStack((IItemProvider)ItemRegistry.biomass), new ItemStack((IItemProvider)ItemRegistry.biomass), new FluidStack((Fluid)FluidBiomassHolder.STILL.get(), 1000));
        RecipeMelter.addRecipe("bambooskelp", new ItemStack((IItemProvider)ItemRegistry.biomass), new ItemStack((IItemProvider)Items.field_222068_kQ), new FluidStack((Fluid)FluidBiomassHolder.STILL.get(), 1000));
        RecipeMelter.addRecipe("wheatkelp", new ItemStack((IItemProvider)ItemRegistry.biomass), new ItemStack((IItemProvider)Items.field_151014_N), new FluidStack((Fluid)FluidBiomassHolder.STILL.get(), 1000));
        RecipeMelter.addRecipe("beetrootkelp", new ItemStack((IItemProvider)ItemRegistry.biomass), new ItemStack((IItemProvider)Items.field_185163_cU), new FluidStack((Fluid)FluidBiomassHolder.STILL.get(), 1000));
        RecipeMelter.addRecipe("melonkelp", new ItemStack((IItemProvider)ItemRegistry.biomass), new ItemStack((IItemProvider)Items.field_151081_bc), new FluidStack((Fluid)FluidBiomassHolder.STILL.get(), 1000));
        RecipeMelter.addRecipe("pumpskelp", new ItemStack((IItemProvider)ItemRegistry.biomass), new ItemStack((IItemProvider)Items.field_151080_bb), new FluidStack((Fluid)FluidBiomassHolder.STILL.get(), 1000));
        RecipeMelter.addRecipe("pumpsasdfkelp", new ItemStack((IItemProvider)ItemRegistry.biomass), new ItemStack((IItemProvider)Items.field_222066_kO), new FluidStack((Fluid)FluidBiomassHolder.STILL.get(), 1000));
        RecipeMelter.addRecipe("obsidiansmstonelava", new ItemStack((IItemProvider)Blocks.field_150343_Z), new ItemStack((IItemProvider)Blocks.field_196579_bG), new FluidStack((Fluid)Fluids.field_204547_b, 1000));
        RecipeMelter.addRecipe("obsidiancobblelava", new ItemStack((IItemProvider)Blocks.field_150343_Z), new ItemStack((IItemProvider)Blocks.field_150347_e), new FluidStack((Fluid)Fluids.field_204547_b, 1000));
        RecipeMelter.addRecipe("obsidiangravellava", new ItemStack((IItemProvider)Blocks.field_150343_Z), new ItemStack((IItemProvider)Blocks.field_150351_n), new FluidStack((Fluid)Fluids.field_204547_b, 1000));
        RecipeMelter.addRecipe("slimemagmaball", new ItemStack((IItemProvider)Items.field_151064_bs), new ItemStack((IItemProvider)Items.field_151064_bs), new FluidStack((Fluid)FluidSlimeHolder.STILL.get(), 200));
        RecipeMelter.addRecipe("slimeball", new ItemStack((IItemProvider)Items.field_151123_aH), new ItemStack((IItemProvider)Items.field_151123_aH), new FluidStack((Fluid)FluidSlimeHolder.STILL.get(), 200));
        RecipeMelter.addRecipe("slimeblock", new ItemStack((IItemProvider)Blocks.field_180399_cE), new ItemStack((IItemProvider)Blocks.field_180399_cE), new FluidStack((Fluid)FluidSlimeHolder.STILL.get(), 1800));
        RecipeMelter.addRecipe("doubleexperience_food", new ItemStack((IItemProvider)ItemRegistry.experience_food), new ItemStack((IItemProvider)ItemRegistry.experience_food), new FluidStack((Fluid)FluidXpJuiceHolder.STILL.get(), 2000));
        RecipeMelter.addRecipe("fexperience_food", new ItemStack((IItemProvider)ItemRegistry.experience_food), new ItemStack((IItemProvider)Items.field_151073_bk), new FluidStack((Fluid)FluidXpJuiceHolder.STILL.get(), 1200));
        RecipeMelter.addRecipe("blazeexperience_food", new ItemStack((IItemProvider)ItemRegistry.experience_food), new ItemStack((IItemProvider)Items.field_151072_bj), new FluidStack((Fluid)FluidXpJuiceHolder.STILL.get(), 1100));
        RecipeMelter.addRecipe("witherroseexperience_food", new ItemStack((IItemProvider)ItemRegistry.experience_food), new ItemStack((IItemProvider)Items.field_221690_bg), new FluidStack((Fluid)FluidXpJuiceHolder.STILL.get(), 1150));
        RecipeMelter.addRecipe("fleshexperience_food", new ItemStack((IItemProvider)ItemRegistry.experience_food), new ItemStack((IItemProvider)Items.field_151078_bh), new FluidStack((Fluid)FluidXpJuiceHolder.STILL.get(), 1050));
        RecipeMelter.addRecipe("boneexperience_food", new ItemStack((IItemProvider)ItemRegistry.experience_food), new ItemStack((IItemProvider)Items.field_151103_aS), new FluidStack((Fluid)FluidXpJuiceHolder.STILL.get(), 1020));
        RecipeMelter.addRecipe("honey", new ItemStack((IItemProvider)Items.field_226639_pY_), new ItemStack((IItemProvider)Items.field_226639_pY_), new FluidStack((Fluid)FluidHoneyHolder.STILL.get(), 2000));
        RecipeMelter.addRecipe("honeyb", new ItemStack((IItemProvider)Items.field_226638_pX_), new ItemStack((IItemProvider)Items.field_226638_pX_), new FluidStack((Fluid)FluidHoneyHolder.STILL.get(), 500));
        RecipeMelter.addRecipe("honeyc", new ItemStack((IItemProvider)Items.field_226640_pZ_), new ItemStack((IItemProvider)Items.field_226639_pY_), new FluidStack((Fluid)FluidHoneyHolder.STILL.get(), 5000));
        RecipeMelter.addRecipe("magma", new ItemStack((IItemProvider)Blocks.field_196814_hQ), new ItemStack((IItemProvider)Blocks.field_196814_hQ), new FluidStack((Fluid)FluidMagmaHolder.STILL.get(), 1000));
        RecipeMelter.addRecipe("magmar", new ItemStack((IItemProvider)Blocks.field_196814_hQ), new ItemStack((IItemProvider)Blocks.field_196653_dH), new FluidStack((Fluid)FluidMagmaHolder.STILL.get(), 1000));
        RecipeMelter.addRecipe("magmamelt", new ItemStack((IItemProvider)Blocks.field_196814_hQ), new ItemStack((IItemProvider)Blocks.field_150424_aL), new FluidStack((Fluid)FluidMagmaHolder.STILL.get(), 600));
        ModCyclic.LOGGER.info("Melter Recipes added " + RECIPES.size());
    }

    private static void addRecipe(String name, ItemStack itemStack, ItemStack secnd, FluidStack fluidStack) {
        ResourceLocation id = new ResourceLocation("cyclic", "melter_" + name);
        if (hashes.contains(id.toString())) {
            ModCyclic.LOGGER.error("Duplicate melter recipe id " + id.toString());
        }
        RECIPES.add(new RecipeMelter(new ResourceLocation("cyclic", name), itemStack, secnd, fluidStack));
        hashes.add(id.toString());
    }
}

