/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.gui;

import cofh.core.client.gui.IGuiAccess;
import cofh.core.client.gui.element.ElementBase;
import cofh.core.client.gui.element.panel.PanelBase;
import cofh.core.client.gui.element.panel.PanelTracker;
import cofh.lib.inventory.container.slot.SlotFalseCopy;
import cofh.lib.util.helpers.RenderHelper;
import cofh.lib.util.helpers.StringHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class ContainerScreenCoFH<T extends Container>
extends ContainerScreen<T>
implements IGuiAccess {
    protected int mX;
    protected int mY;
    protected int lastIndex = -1;
    protected String name;
    protected String info;
    protected ResourceLocation texture;
    protected PlayerEntity player;
    protected ArrayList<PanelBase> panels = new ArrayList();
    protected ArrayList<ElementBase> elements = new ArrayList();
    protected List<ITextComponent> tooltip = new LinkedList<ITextComponent>();
    protected boolean drawTitle = true;
    protected boolean drawInventory = true;
    protected boolean showTooltips = true;

    public ContainerScreenCoFH(T container, PlayerInventory inv, ITextComponent titleIn) {
        super(container, inv, titleIn);
        this.player = inv.field_70458_d;
    }

    public void init() {
        super.init();
        this.panels.clear();
        this.elements.clear();
    }

    public void render(int mouseX, int mouseY, float partialTick) {
        this.updatePanelInformation();
        this.updateElementInformation();
        this.mX = mouseX - this.field_147003_i;
        this.mY = mouseY - this.field_147009_r;
        this.renderBackground();
        super.render(mouseX, mouseY, partialTick);
        this.func_191948_b(mouseX, mouseY);
        if (this.showTooltips && this.getMinecraft().field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
            this.drawTooltip();
        }
        this.updatePanels();
        this.updateElements();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        RenderHelper.resetColor();
        RenderHelper.bindTexture(this.texture);
        if (this.field_146999_f > 256 || this.field_147000_g > 256) {
            this.drawTexturedModalRect(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g, 512.0f, 512.0f);
        } else {
            this.drawTexturedModalRect(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        }
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
        this.drawPanels(false);
        this.drawElements(false);
        RenderSystem.popMatrix();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        if (this.drawTitle & this.title != null) {
            this.getFontRenderer().func_211126_b(StringHelper.localize(this.title.func_150254_d()), (float)this.getCenteredOffset(StringHelper.localize(this.title.func_150254_d())), 6.0f, 0x404040);
        }
        if (this.drawInventory) {
            this.getFontRenderer().func_211126_b(StringHelper.localize("container.inventory"), 8.0f, (float)(this.field_147000_g - 96 + 3), 0x404040);
        }
        this.drawPanels(true);
        this.drawElements(true);
    }

    public void drawTooltip() {
        ElementBase element;
        PanelBase panel = this.getPanelAtPosition(this.mX, this.mY);
        if (panel != null) {
            panel.addTooltip(this.tooltip, this.mX, this.mY);
        }
        if ((element = this.getElementAtPosition(this.mX, this.mY)) != null && element.visible()) {
            element.addTooltip(this.tooltip, this.mX, this.mY);
        }
        this.drawTooltipHoveringText(this.tooltip, this.mX + this.field_147003_i, this.mY + this.field_147009_r, this.font);
        this.tooltip.clear();
    }

    protected void drawElements(boolean foreground) {
        if (foreground) {
            for (ElementBase c : this.elements) {
                if (!c.visible()) continue;
                c.drawForeground(this.mX, this.mY);
            }
        } else {
            for (ElementBase c : this.elements) {
                if (!c.visible()) continue;
                c.drawBackground(this.mX, this.mY);
            }
        }
    }

    protected void drawPanels(boolean foreground) {
        int yPosRight = 4;
        int yPosLeft = 4;
        if (foreground) {
            for (PanelBase panel : this.panels) {
                panel.updateSize();
                if (!panel.visible()) continue;
                if (panel.side == 0) {
                    panel.drawForeground(this.mX, this.mY);
                    yPosLeft += panel.height();
                    continue;
                }
                panel.drawForeground(this.mX, this.mY);
                yPosRight += panel.height();
            }
        } else {
            for (PanelBase panel : this.panels) {
                panel.updateSize();
                if (!panel.visible()) continue;
                if (panel.side == 0) {
                    panel.setPosition(0, yPosLeft);
                    panel.drawBackground(this.mX, this.mY);
                    yPosLeft += panel.height();
                    continue;
                }
                panel.setPosition(this.field_146999_f, yPosRight);
                panel.drawBackground(this.mX, this.mY);
                yPosRight += panel.height();
            }
        }
    }

    protected <T> T addElement(ElementBase element) {
        this.elements.add(element);
        return (T)element;
    }

    public final void addElements(ElementBase ... c) {
        this.elements.addAll(Arrays.asList(c));
    }

    protected <T> T addPanel(PanelBase panel) {
        int yOffset = 4;
        for (PanelBase panel1 : this.panels) {
            if (panel1.side != panel.side || !panel1.visible()) continue;
            yOffset += panel1.height();
        }
        panel.setPosition(panel.side == 0 ? 0 : this.field_146999_f, yOffset);
        this.panels.add(panel);
        if (PanelTracker.getOpenedLeft() != null && panel.getClass().equals(PanelTracker.getOpenedLeft())) {
            panel.setFullyOpen();
        } else if (PanelTracker.getOpenedRight() != null && panel.getClass().equals(PanelTracker.getOpenedRight())) {
            panel.setFullyOpen();
        }
        return (T)panel;
    }

    private ElementBase getElementAtPosition(int mouseX, int mouseY) {
        int i = this.elements.size();
        while (i-- > 0) {
            ElementBase element = this.elements.get(i);
            if (!element.intersectsWith(mouseX, mouseY)) continue;
            return element;
        }
        return null;
    }

    private PanelBase getPanelAtPosition(double mouseX, double mouseY) {
        int xShift = 0;
        int yShift = 4;
        for (PanelBase panel : this.panels) {
            if (!panel.visible() || panel.side == 1) continue;
            panel.setShift(xShift, yShift);
            if (panel.intersectsWith(mouseX, mouseY, xShift, yShift)) {
                return panel;
            }
            yShift += panel.height();
        }
        xShift = this.field_146999_f;
        yShift = 4;
        for (PanelBase panel : this.panels) {
            if (!panel.visible() || panel.side == 0) continue;
            panel.setShift(xShift, yShift);
            if (panel.intersectsWith(mouseX, mouseY, xShift, yShift)) {
                return panel;
            }
            yShift += panel.height();
        }
        return null;
    }

    private void updateElements() {
        int i = this.elements.size();
        while (i-- > 0) {
            ElementBase c = this.elements.get(i);
            if (!c.visible() || !c.enabled()) continue;
            c.update(this.mX, this.mY);
        }
    }

    private void updatePanels() {
        int i = this.panels.size();
        while (i-- > 0) {
            PanelBase c = this.panels.get(i);
            if (!c.visible() || !c.enabled()) continue;
            c.update(this.mX, this.mY);
        }
    }

    protected void updateElementInformation() {
    }

    protected void updatePanelInformation() {
    }

    public List<Rectangle2d> getPanelBounds() {
        ArrayList<Rectangle2d> panelBounds = new ArrayList<Rectangle2d>();
        for (PanelBase c : this.panels) {
            panelBounds.add(c.getBoundsOnScreen());
        }
        return panelBounds;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        mouseX -= (double)this.field_147003_i;
        mouseY -= (double)this.field_147009_r;
        int i = this.elements.size();
        while (i-- > 0) {
            ElementBase c = this.elements.get(i);
            if (!c.visible() || !c.enabled() || !c.intersectsWith(mouseX, mouseY) || !c.mouseClicked(mouseX, mouseY, mouseButton)) continue;
            return true;
        }
        PanelBase panel = this.getPanelAtPosition(mouseX, mouseY);
        if (panel != null && !panel.mouseClicked(mouseX, mouseY, mouseButton)) {
            int i2 = this.panels.size();
            while (i2-- > 0) {
                PanelBase other = this.panels.get(i2);
                if (other == panel || !other.open || other.side != panel.side) continue;
                other.toggleOpen();
            }
            panel.toggleOpen();
            return true;
        }
        mouseX += (double)this.field_147003_i;
        mouseY += (double)this.field_147009_r;
        if (panel != null) {
            switch (panel.side) {
                case 0: {
                    this.field_147003_i -= panel.width();
                    break;
                }
                case 1: {
                    this.field_146999_f += panel.width();
                }
            }
        }
        boolean ret = super.mouseClicked(mouseX, mouseY, mouseButton);
        if (panel != null) {
            switch (panel.side) {
                case 0: {
                    this.field_147003_i += panel.width();
                    break;
                }
                case 1: {
                    this.field_146999_f -= panel.width();
                }
            }
        }
        return ret;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        mouseX -= (double)this.field_147003_i;
        mouseY -= (double)this.field_147009_r;
        if (mouseButton >= 0 && mouseButton <= 2) {
            int i = this.elements.size();
            while (i-- > 0) {
                ElementBase c = this.elements.get(i);
                if (!c.visible() || !c.enabled()) continue;
                c.mouseReleased(mouseX, mouseY);
            }
        }
        return super.mouseReleased(mouseX += (double)this.field_147003_i, mouseY += (double)this.field_147009_r, mouseButton);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double unused_1, double unused_2) {
        Slot slot = this.getSlotAtPosition(this.mX, this.mY);
        ItemStack itemstack = this.getMinecraft().field_71439_g.field_71071_by.func_70445_o();
        if (this.field_147007_t && slot != null && !itemstack.func_190926_b() && slot instanceof SlotFalseCopy) {
            if (this.lastIndex != slot.field_75222_d) {
                this.lastIndex = slot.field_75222_d;
                this.func_184098_a(slot, slot.field_75222_d, 0, ClickType.PICKUP);
            }
            return true;
        }
        this.lastIndex = -1;
        return super.mouseDragged(mouseX, mouseY, mouseButton, unused_1, unused_2);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double movement) {
        if (movement != 0.0) {
            int i = this.elements.size();
            while (i-- > 0) {
                ElementBase c = this.elements.get(i);
                if (!c.visible() || !c.enabled() || !c.intersectsWith(this.mX, this.mY) || !c.mouseWheel(this.mX, this.mY, movement)) continue;
                return true;
            }
            PanelBase panel = this.getPanelAtPosition(this.mX, this.mY);
            if (panel != null && panel.mouseWheel(this.mX, this.mY, movement)) {
                return true;
            }
            return this.mouseWheel(this.mX, this.mY, movement);
        }
        return false;
    }

    protected boolean func_195363_d(int keyCode, int scanCode) {
        int i = this.elements.size();
        while (i-- > 0) {
            ElementBase c = this.elements.get(i);
            if (!c.visible() || !c.enabled() || !c.keyTyped(keyCode, scanCode)) continue;
            return true;
        }
        return super.func_195363_d(keyCode, scanCode);
    }

    protected boolean mouseWheel(double mouseX, double mouseY, double movement) {
        return false;
    }

    protected Slot getSlotAtPosition(int xCoord, int yCoord) {
        for (int k = 0; k < this.field_147002_h.field_75151_b.size(); ++k) {
            Slot slot = (Slot)this.field_147002_h.field_75151_b.get(k);
            if (!this.isMouseOverSlot(slot, xCoord, yCoord)) continue;
            return slot;
        }
        return null;
    }

    protected boolean isMouseOverSlot(Slot theSlot, int xCoord, int yCoord) {
        return this.func_195359_a(theSlot.field_75223_e, theSlot.field_75221_f, 16, 16, xCoord, yCoord);
    }

    protected int getCenteredOffset(String string) {
        return this.getCenteredOffset(string, this.field_146999_f / 2);
    }

    protected int getCenteredOffset(String string, int xPos) {
        return (xPos * 2 - this.font.func_78256_a(string)) / 2;
    }

    protected void drawTooltipHoveringText(List<ITextComponent> tooltip, int x, int y, FontRenderer font) {
        int n;
        if (tooltip == null || tooltip.isEmpty()) {
            return;
        }
        ArrayList<String> stringTooltip = new ArrayList<String>(tooltip.size());
        for (ITextComponent iTextComponent : tooltip) {
            stringTooltip.add(iTextComponent.func_150254_d());
        }
        RenderSystem.disableRescaleNormal();
        RenderSystem.disableDepthTest();
        int k = 0;
        for (String s : stringTooltip) {
            int l = font.func_78256_a(s);
            if (l <= k) continue;
            k = l;
        }
        int n2 = x + 12;
        int j1 = y - 12;
        int k1 = 8;
        if (tooltip.size() > 1) {
            k1 += 2 + (tooltip.size() - 1) * 10;
        }
        if (n2 + k > this.width) {
            n = n2 - (28 + k);
        }
        if (j1 + k1 + 6 > this.height) {
            j1 = this.height - k1 - 6;
        }
        this.setBlitOffset(300);
        this.itemRenderer.field_77023_b = 300.0f;
        int l1 = -267386864;
        this.fillGradient(n - 3, j1 - 4, n + k + 3, j1 - 3, l1, l1);
        this.fillGradient(n - 3, j1 + k1 + 3, n + k + 3, j1 + k1 + 4, l1, l1);
        this.fillGradient(n - 3, j1 - 3, n + k + 3, j1 + k1 + 3, l1, l1);
        this.fillGradient(n - 4, j1 - 3, n - 3, j1 + k1 + 3, l1, l1);
        this.fillGradient(n + k + 3, j1 - 3, n + k + 4, j1 + k1 + 3, l1, l1);
        int i2 = 0x505000FF;
        int j2 = (i2 & 0xFEFEFE) >> 1 | i2 & 0xFF000000;
        this.fillGradient(n - 3, j1 - 3 + 1, n - 3 + 1, j1 + k1 + 3 - 1, i2, j2);
        this.fillGradient(n + k + 2, j1 - 3 + 1, n + k + 3, j1 + k1 + 3 - 1, i2, j2);
        this.fillGradient(n - 3, j1 - 3, n + k + 3, j1 - 3 + 1, i2, i2);
        this.fillGradient(n - 3, j1 + k1 + 2, n + k + 3, j1 + k1 + 3, j2, j2);
        MatrixStack matrixstack = new MatrixStack();
        IRenderTypeBuffer.Impl irendertypebuffer$impl = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        matrixstack.func_227861_a_(0.0, 0.0, (double)this.itemRenderer.field_77023_b);
        Matrix4f matrix4f = matrixstack.func_227866_c_().func_227870_a_();
        for (int k2 = 0; k2 < tooltip.size(); ++k2) {
            String s1 = (String)stringTooltip.get(k2);
            if (s1 != null) {
                font.func_228079_a_(s1, (float)n, (float)j1, -1, true, matrix4f, (IRenderTypeBuffer)irendertypebuffer$impl, false, 0, 0xF000F0);
            }
            if (k2 == 0) {
                j1 += 2;
            }
            j1 += 10;
        }
        irendertypebuffer$impl.func_228461_a_();
        this.setBlitOffset(0);
        this.itemRenderer.field_77023_b = 0.0f;
        RenderSystem.enableDepthTest();
        RenderSystem.enableRescaleNormal();
    }

    @Override
    public FontRenderer getFontRenderer() {
        return this.font;
    }

    @Override
    public void handleElementButtonClick(String buttonName, int mouseButton) {
    }

    @Override
    public void drawIcon(TextureAtlasSprite icon, int x, int y) {
        RenderHelper.setBlockTextureSheet();
        RenderHelper.resetColor();
        ContainerScreenCoFH.blit((int)x, (int)y, (int)this.getBlitOffset(), (int)16, (int)16, (TextureAtlasSprite)icon);
    }

    @Override
    public void drawIcon(ResourceLocation location, int x, int y) {
        this.drawIcon(RenderHelper.getTexture(location), x, y);
    }

    @Override
    public void drawSizedRect(int x1, int y1, int x2, int y2, int color) {
        int temp;
        if (x1 < x2) {
            temp = x1;
            x1 = x2;
            x2 = temp;
        }
        if (y1 < y2) {
            temp = y1;
            y1 = y2;
            y2 = temp;
        }
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.disableTexture();
        RenderSystem.color4f((float)r, (float)g, (float)b, (float)a);
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        buffer.func_225582_a_((double)x1, (double)y2, (double)this.getBlitOffset()).func_181675_d();
        buffer.func_225582_a_((double)x2, (double)y2, (double)this.getBlitOffset()).func_181675_d();
        buffer.func_225582_a_((double)x2, (double)y1, (double)this.getBlitOffset()).func_181675_d();
        buffer.func_225582_a_((double)x1, (double)y1, (double)this.getBlitOffset()).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        RenderSystem.enableTexture();
    }

    @Override
    public void drawColoredModalRect(int x1, int y1, int x2, int y2, int color) {
        int temp;
        if (x1 < x2) {
            temp = x1;
            x1 = x2;
            x2 = temp;
        }
        if (y1 < y2) {
            temp = y1;
            y1 = y2;
            y2 = temp;
        }
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.blendFunc((int)GlStateManager.SourceFactor.SRC_ALPHA.field_225655_p_, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.field_225654_o_);
        RenderSystem.color4f((float)r, (float)g, (float)b, (float)a);
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        buffer.func_225582_a_((double)x1, (double)y2, (double)this.getBlitOffset()).func_181675_d();
        buffer.func_225582_a_((double)x2, (double)y2, (double)this.getBlitOffset()).func_181675_d();
        buffer.func_225582_a_((double)x2, (double)y1, (double)this.getBlitOffset()).func_181675_d();
        buffer.func_225582_a_((double)x1, (double)y1, (double)this.getBlitOffset()).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    @Override
    public void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_225582_a_((double)(x + 0), (double)(y + height), (double)this.getBlitOffset()).func_225583_a_((float)(textureX + 0) * 0.00390625f, (float)(textureY + height) * 0.00390625f).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + width), (double)(y + height), (double)this.getBlitOffset()).func_225583_a_((float)(textureX + width) * 0.00390625f, (float)(textureY + height) * 0.00390625f).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + width), (double)(y + 0), (double)this.getBlitOffset()).func_225583_a_((float)(textureX + width) * 0.00390625f, (float)(textureY + 0) * 0.00390625f).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + 0), (double)(y + 0), (double)this.getBlitOffset()).func_225583_a_((float)(textureX + 0) * 0.00390625f, (float)(textureY + 0) * 0.00390625f).func_181675_d();
        tessellator.func_78381_a();
    }

    @Override
    public void drawTexturedModalRect(int x, int y, int u, int v, int width, int height, float texW, float texH) {
        float texU = 1.0f / texW;
        float texV = 1.0f / texH;
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_225582_a_((double)x, (double)(y + height), (double)this.getBlitOffset()).func_225583_a_((float)u * texU, (float)(v + height) * texV).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)(y + height), (double)this.getBlitOffset()).func_225583_a_((float)(u + width) * texU, (float)(v + height) * texV).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)y, (double)this.getBlitOffset()).func_225583_a_((float)(u + width) * texU, (float)v * texV).func_181675_d();
        buffer.func_225582_a_((double)x, (double)y, (double)this.getBlitOffset()).func_225583_a_((float)u * texU, (float)v * texV).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }
}

