/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.tileentity;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.api.network.EnumConnectionType;
import sonar.fluxnetworks.api.network.ITransferHandler;
import sonar.fluxnetworks.api.tiles.IFluxEnergy;
import sonar.fluxnetworks.api.tiles.IFluxStorage;
import sonar.fluxnetworks.api.utils.NBTType;
import sonar.fluxnetworks.common.connection.handler.FluxStorageHandler;
import sonar.fluxnetworks.common.data.FluxNetworkData;
import sonar.fluxnetworks.common.registry.RegistryBlocks;
import sonar.fluxnetworks.common.tileentity.TileFluxCore;

public abstract class TileFluxStorage
extends TileFluxCore
implements IFluxStorage,
IFluxEnergy {
    public final FluxStorageHandler handler = new FluxStorageHandler(this);
    public static final int C = 1000000;
    public static final int D = -10000;
    public int energyStored;
    public int maxEnergyStorage;
    private boolean energyChanged = false;
    public ItemStack stack = ItemStack.field_190927_a;

    public TileFluxStorage(TileEntityType<?> tileEntityTypeIn, int maxEnergyStorage) {
        super(tileEntityTypeIn);
        this.maxEnergyStorage = maxEnergyStorage;
    }

    @Override
    public EnumConnectionType getConnectionType() {
        return EnumConnectionType.STORAGE;
    }

    @Override
    public ITransferHandler getTransferHandler() {
        return this.handler;
    }

    @Override
    public CompoundNBT writeCustomNBT(CompoundNBT tag, NBTType type) {
        super.writeCustomNBT(tag, type);
        tag.func_74768_a("energy", this.energyStored);
        return tag;
    }

    @Override
    public long addEnergy(long amount, boolean simulate) {
        long energyReceived = Math.min((long)(this.maxEnergyStorage - this.energyStored), amount);
        if (!simulate) {
            this.energyStored = (int)((long)this.energyStored + energyReceived);
            this.energyChanged = true;
        }
        return energyReceived;
    }

    @Override
    public long removeEnergy(long amount, boolean simulate) {
        long energyExtracted = Math.min((long)this.energyStored, amount);
        if (!simulate) {
            this.energyStored = (int)((long)this.energyStored - energyExtracted);
            this.energyChanged = true;
        }
        return energyExtracted;
    }

    public void sendPacketIfNeeded() {
        if (this.energyChanged && (this.field_145850_b.func_201675_m().getWorldTime() & 3L) == 0L) {
            this.sendTilePacketToNearby((byte)11);
            this.energyChanged = false;
        }
    }

    @Override
    public long getEnergy() {
        return this.energyStored;
    }

    @Override
    public long getCurrentLimit() {
        return this.disableLimit ? (long)this.maxEnergyStorage : Math.min(this.limit, (long)this.maxEnergyStorage);
    }

    @Override
    public int getPriority() {
        return this.surgeMode ? -10000 : Math.min(this.priority - 1000000, -10000);
    }

    @Override
    public long getMaxTransferLimit() {
        return this.maxEnergyStorage;
    }

    @Override
    public void readCustomNBT(CompoundNBT tag, NBTType type) {
        super.readCustomNBT(tag, type);
        this.energyStored = tag.func_74762_e("energy");
    }

    public ItemStack writeStorageToDisplayStack(ItemStack stack) {
        CompoundNBT tag = new CompoundNBT();
        CompoundNBT subTag = new CompoundNBT();
        subTag.func_74768_a("energy", this.energyStored);
        subTag.func_74768_a(FluxNetworkData.NETWORK_ID, this.networkID);
        tag.func_218657_a("FluxData", (INBT)subTag);
        tag.func_74757_a("GuiColor", true);
        stack.func_77982_d(tag);
        return stack;
    }

    @Override
    public ItemStack getDisplayStack() {
        return this.writeStorageToDisplayStack(this.stack);
    }

    @Override
    public void writePacket(PacketBuffer buf, byte id) {
        super.writePacket(buf, id);
        switch (id) {
            case 5: 
            case 11: {
                buf.writeInt(this.energyStored);
            }
        }
    }

    @Override
    public void readPacket(PacketBuffer buf, byte id) {
        super.readPacket(buf, id);
        switch (id) {
            case 5: 
            case 11: {
                this.energyStored = buf.readInt();
            }
        }
    }

    public static class Gargantuan
    extends TileFluxStorage {
        public Gargantuan() {
            super(RegistryBlocks.GARGANTUAN_FLUX_STORAGE_TILE, FluxConfig.gargantuanCapacity);
            this.customName = "Gargantuan Storage";
            this.limit = FluxConfig.gargantuanTransfer;
            this.stack = new ItemStack((IItemProvider)RegistryBlocks.GARGANTUAN_FLUX_STORAGE);
        }
    }

    public static class Herculean
    extends TileFluxStorage {
        public Herculean() {
            super(RegistryBlocks.HERCULEAN_FLUX_STORAGE_TILE, FluxConfig.herculeanCapacity);
            this.customName = "Herculean Storage";
            this.limit = FluxConfig.herculeanTransfer;
            this.stack = new ItemStack((IItemProvider)RegistryBlocks.HERCULEAN_FLUX_STORAGE);
        }
    }

    public static class Basic
    extends TileFluxStorage {
        public Basic() {
            super(RegistryBlocks.BASIC_FLUX_STORAGE_TILE, FluxConfig.basicCapacity);
            this.customName = "Basic Storage";
            this.limit = FluxConfig.basicTransfer;
            this.stack = new ItemStack((IItemProvider)RegistryBlocks.BASIC_FLUX_STORAGE);
        }
    }
}

