/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.logic.registry;

import mcjty.rftoolsbase.api.control.parameters.Inventory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;

public class InventoryUtil {
    public static void writeBuf(Inventory inv, PacketBuffer buf) {
        buf.func_180714_a(inv.getNodeNameSafe());
        buf.writeByte(inv.getSide().ordinal());
        buf.writeByte(inv.getIntSide() == null ? -1 : inv.getIntSide().ordinal());
    }

    public static Inventory readBuf(PacketBuffer buf) {
        String nodeName = buf.func_150789_c(Short.MAX_VALUE);
        byte sideIdx = buf.readByte();
        Direction side = Direction.values()[sideIdx];
        sideIdx = buf.readByte();
        Direction intSide = sideIdx == -1 ? null : Direction.values()[sideIdx];
        return new Inventory(nodeName, side, intSide);
    }

    public static Inventory readFromNBT(CompoundNBT tag) {
        String nodeName = null;
        if (tag.func_74764_b("node")) {
            nodeName = tag.func_74779_i("node");
        }
        byte sideIdx = tag.func_74771_c("side");
        Direction side = Direction.values()[sideIdx];
        sideIdx = tag.func_74771_c("intside");
        Direction intSide = sideIdx == -1 ? null : Direction.values()[sideIdx];
        return new Inventory(nodeName, side, intSide);
    }

    public static CompoundNBT writeToNBT(Inventory inv) {
        CompoundNBT tag = new CompoundNBT();
        if (inv.hasNodeName()) {
            tag.func_74778_a("node", inv.getNodeName());
        }
        tag.func_74774_a("side", (byte)inv.getSide().ordinal());
        tag.func_74774_a("intside", (byte)(inv.getIntSide() == null ? -1 : inv.getIntSide().ordinal()));
        return tag;
    }
}

