/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.multitank.client;

import mcjty.lib.base.ModBase;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.VerticalAlignment;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.rftoolscontrol.RFToolsControl;
import mcjty.rftoolscontrol.modules.multitank.blocks.MultiTankContainer;
import mcjty.rftoolscontrol.modules.multitank.blocks.MultiTankTileEntity;
import mcjty.rftoolscontrol.modules.multitank.network.PacketGetTankFluids;
import mcjty.rftoolscontrol.modules.multitank.util.MultiTankFluidProperties;
import mcjty.rftoolscontrol.setup.RFToolsCtrlMessages;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class GuiMultiTank
extends GenericGuiContainer<MultiTankTileEntity, MultiTankContainer> {
    public static final int WIDTH = 180;
    public static final int HEIGHT = 87;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftoolscontrol", "textures/gui/tank.png");
    private int listDirty = 0;
    private BlockRender[] liquids = new BlockRender[4];
    private Label[] labels = new Label[4];

    public GuiMultiTank(MultiTankTileEntity te, MultiTankContainer container, PlayerInventory inventory) {
        super((ModBase)RFToolsControl.instance, (GenericTileEntity)te, (Container)container, inventory, ManualEntry.EMPTY);
        this.field_146999_f = 180;
        this.field_147000_g = 87;
    }

    public void init() {
        super.init();
        Panel toplevel = (Panel)Widgets.positional().background(iconLocation);
        toplevel.bounds(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g);
        for (int i = 0; i < 4; ++i) {
            this.liquids[i] = (BlockRender)new BlockRender().hint(10, 9 + i * 18, 16, 16);
            toplevel.children(new Widget[]{this.liquids[i]});
            this.labels[i] = (Label)((Label)Widgets.label((int)32, (int)(9 + i * 18), (int)142, (int)16, (String)"").horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).verticalAlignment(VerticalAlignment.ALIGN_CENTER);
            toplevel.children(new Widget[]{this.labels[i]});
        }
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
    }

    private void requestLists() {
        RFToolsCtrlMessages.INSTANCE.sendToServer((Object)new PacketGetTankFluids(((MultiTankTileEntity)this.tileEntity).func_174877_v()));
    }

    private void requestListsIfNeeded() {
        --this.listDirty;
        if (this.listDirty <= 0) {
            this.requestLists();
            this.listDirty = 10;
        }
    }

    private void updateLiquids() {
        this.requestListsIfNeeded();
        MultiTankFluidProperties[] properties = ((MultiTankTileEntity)this.tileEntity).getProperties();
        for (int i = 0; i < 4; ++i) {
            FluidStack stack;
            if (i < properties.length && properties[i] != null && !(stack = properties[i].getContents()).isEmpty()) {
                this.liquids[i].renderItem((Object)stack);
                this.labels[i].text(stack.getDisplayName().func_150254_d() + " (" + stack.getAmount() + "mb)");
                continue;
            }
            this.liquids[i].renderItem(null);
            this.labels[i].text("");
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.updateLiquids();
        this.drawWindow();
    }
}

