/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import java.util.Arrays;
import java.util.List;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.upgrade.UpgradeCache;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.items.ItemStackHandler;

public class UpgradableItemUtils {
    public static final String NBT_CREATIVE = "CreativeUpgrade";
    public static final String NBT_UPGRADE_TAG = "UpgradeInventory";
    public static final int UPGRADE_INV_SIZE = 9;
    private static final String NBT_UPGRADE_CACHE_TAG = "UpgradeInventoryCached";

    public static void addUpgradeInformation(ItemStack iStack, List<ITextComponent> textList, ITooltipFlag flag) {
        ItemStack[] inventoryStacks = UpgradableItemUtils.getUpgradeStacks(iStack);
        boolean isItemEmpty = true;
        for (ItemStack stack : inventoryStacks) {
            if (stack.func_190926_b()) continue;
            isItemEmpty = false;
            break;
        }
        if (isItemEmpty) {
            if (!(iStack.func_77973_b() instanceof BlockItem)) {
                textList.add(PneumaticCraftUtils.xlate("gui.tooltip.upgrades.empty", new Object[0]).func_211708_a(TextFormatting.DARK_GREEN));
            }
        } else {
            textList.add(PneumaticCraftUtils.xlate("gui.tooltip.upgrades.not_empty", new Object[0]).func_211708_a(TextFormatting.GREEN));
            PneumaticCraftUtils.sortCombineItemStacksAndToString(textList, inventoryStacks);
        }
    }

    public static void setUpgrades(ItemStack stack, ItemStackHandler handler) {
        stack.func_196082_o().func_218657_a(NBT_UPGRADE_TAG, (INBT)handler.serializeNBT());
        UpgradeCache cache = new UpgradeCache(() -> handler);
        stack.func_77978_p().func_218657_a(NBT_UPGRADE_CACHE_TAG, (INBT)cache.toNBT());
        stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).ifPresent(h -> {
            if (h.getPressure() > h.maxPressure()) {
                int maxAir = (int)((float)h.getVolume() * h.maxPressure());
                h.addAir(maxAir - h.getAir());
            }
        });
    }

    public static ItemStack[] getUpgradeStacks(ItemStack stack) {
        CompoundNBT tag = UpgradableItemUtils.getSerializedUpgrades(stack);
        Object[] inventoryStacks = new ItemStack[9];
        Arrays.fill(inventoryStacks, ItemStack.field_190927_a);
        ListNBT itemList = tag.func_150295_c("Items", 10);
        for (int i = 0; i < itemList.size(); ++i) {
            CompoundNBT slotEntry = itemList.func_150305_b(i);
            byte j = slotEntry.func_74771_c("Slot");
            if (j < 0 || j >= 9) continue;
            inventoryStacks[j] = ItemStack.func_199557_a((CompoundNBT)slotEntry);
        }
        return inventoryStacks;
    }

    public static ItemStackHandler getUpgrades(ItemStack stack) {
        ItemStackHandler handler = new ItemStackHandler(9);
        CompoundNBT tag = UpgradableItemUtils.getSerializedUpgrades(stack);
        if (!tag.isEmpty()) {
            handler.deserializeNBT(tag);
        }
        return handler;
    }

    public static int getUpgrades(ItemStack stack, EnumUpgrade upgrade) {
        CompoundNBT tag = UpgradableItemUtils.getSerializedUpgrades(stack);
        if (!tag.isEmpty()) {
            int[] upgrades = stack.func_77978_p().func_74759_k(NBT_UPGRADE_CACHE_TAG);
            if (upgrades.length != EnumUpgrade.values().length) {
                UpgradableItemUtils.fixUpgradeCache(stack, tag);
                upgrades = stack.func_77978_p().func_74759_k(NBT_UPGRADE_CACHE_TAG);
            }
            return upgrades[upgrade.ordinal()];
        }
        return 0;
    }

    public static boolean hasCreativeUpgrade(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n(NBT_CREATIVE);
    }

    private static CompoundNBT getSerializedUpgrades(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return new CompoundNBT();
        }
        if (stack.func_77978_p().func_74764_b("BlockEntityTag")) {
            return stack.func_179543_a("BlockEntityTag").func_74775_l(NBT_UPGRADE_TAG);
        }
        return stack.func_77978_p().func_74775_l(NBT_UPGRADE_TAG);
    }

    private static void fixUpgradeCache(ItemStack stack, CompoundNBT tag) {
        ItemStackHandler handler = new ItemStackHandler();
        handler.deserializeNBT(tag);
        UpgradeCache cache = new UpgradeCache(() -> handler);
        stack.func_77978_p().func_218657_a(NBT_UPGRADE_CACHE_TAG, (INBT)cache.toNBT());
    }
}

