/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.inventory.ContainerAmadron;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.commons.lang3.Validate;

public class PacketAmadronInvSync {
    private static final int INV_SIZE = 16;
    private final List<ItemStack> items = new ArrayList<ItemStack>(16);

    public PacketAmadronInvSync() {
    }

    public PacketAmadronInvSync(List<ItemStack> items) {
        Validate.isTrue((items.size() == 16 ? 1 : 0) != 0, (String)("invalid list size: expected 16, got " + items.size()), (Object[])new Object[0]);
        this.items.addAll(items);
    }

    PacketAmadronInvSync(PacketBuffer buffer) {
        for (int i = 0; i < 16; ++i) {
            this.items.add(buffer.func_150791_c());
        }
    }

    public void toBytes(PacketBuffer buf) {
        PacketBuffer pb = new PacketBuffer((ByteBuf)buf);
        this.items.forEach(arg_0 -> ((PacketBuffer)pb).func_150788_a(arg_0));
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player.field_71070_bA instanceof ContainerAmadron) {
                ContainerAmadron container = (ContainerAmadron)player.field_71070_bA;
                for (int i = 0; i < this.items.size(); ++i) {
                    container.setStack(i, this.items.get(i));
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

