/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import me.desht.pneumaticcraft.common.ai.DroneAIImExBase;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.progwidgets.ISidedWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetEnergyExport;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class DroneAIEnergyExport
extends DroneAIImExBase<ProgWidgetEnergyExport> {
    public DroneAIEnergyExport(IDroneBase drone, ProgWidgetEnergyExport widget) {
        super(drone, widget);
    }

    @Override
    protected boolean doBlockInteraction(BlockPos pos, double distToBlock) {
        return this.exportEnergy(pos, false) && super.doBlockInteraction(pos, distToBlock);
    }

    @Override
    protected boolean isValidPosition(BlockPos pos) {
        return this.exportEnergy(pos, true);
    }

    private boolean exportEnergy(BlockPos pos, boolean simulate) {
        boolean didWork = false;
        int energy = (Integer)this.drone.getCapability(CapabilityEnergy.ENERGY).map(IEnergyStorage::getEnergyStored).orElseThrow(RuntimeException::new);
        if (energy == 0) {
            this.abort();
        } else {
            TileEntity te = this.drone.world().func_175625_s(pos);
            if (te != null) {
                Direction face;
                Direction[] directionArray = Direction.field_199792_n;
                int n = directionArray.length;
                for (int i = 0; !(i >= n || ISidedWidget.checkSide((ISidedWidget)((Object)this.progWidget), face = directionArray[i]) && (didWork = this.tryExportToSide(te, face, simulate))); ++i) {
                }
            }
        }
        return didWork;
    }

    private boolean tryExportToSide(TileEntity te, Direction face, boolean simulate) {
        return (Boolean)te.getCapability(CapabilityEnergy.ENERGY, face).map(tileHandler -> {
            int receivable = tileHandler.receiveEnergy(((ProgWidgetEnergyExport)this.progWidget).useCount() ? this.getRemainingCount() : Integer.MAX_VALUE, true);
            int toTransfer = this.extractFromDrone(receivable, true);
            if (toTransfer > 0) {
                if (!simulate) {
                    this.decreaseCount(toTransfer);
                    this.extractFromDrone(toTransfer, false);
                    tileHandler.receiveEnergy(toTransfer, false);
                }
                return true;
            }
            return false;
        }).orElse((Object)false);
    }

    private int extractFromDrone(int maxEnergy, boolean simulate) {
        return (Integer)this.drone.getCapability(CapabilityEnergy.ENERGY).map(h -> h.extractEnergy(maxEnergy, simulate)).orElseThrow(RuntimeException::new);
    }
}

