/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.util;

import me.desht.pneumaticcraft.client.gui.GuiSecurityStationBase;
import net.minecraft.inventory.container.Slot;

public class ProgressingLine {
    public double startX;
    public double startY;
    public double startZ;
    public double endX;
    public double endY;
    public double endZ;
    protected float progress = 0.0f;

    public ProgressingLine() {
    }

    public ProgressingLine(double startX, double startY, double startZ, double endX, double endY, double endZ) {
        this.startX = startX;
        this.startY = startY;
        this.startZ = startZ;
        this.endX = endX;
        this.endY = endY;
        this.endZ = endZ;
    }

    public ProgressingLine(double startX, double startY, double endX, double endY) {
        this(startX, startY, 0.0, endX, endY, 0.0);
    }

    public ProgressingLine(ProgressingLine copy) {
        this(copy.startX, copy.startY, copy.startZ, copy.endX, copy.endY, copy.endZ);
        this.progress = copy.progress;
    }

    public boolean hasLineSameProperties(double startX, double startY, double startZ, double endX, double endY, double endZ) {
        return Math.abs(startX - this.startX) < 0.01 && Math.abs(startY - this.startY) < 0.01 && Math.abs(startZ - this.startZ) < 0.01 && Math.abs(endX - this.endX) < 0.01 && Math.abs(endY - this.endY) < 0.01 && Math.abs(endZ - this.endZ) < 0.01;
    }

    public float getProgress() {
        return this.progress;
    }

    public ProgressingLine setProgress(float progress) {
        this.progress = progress;
        return this;
    }

    public boolean incProgress(float increment) {
        this.progress += increment;
        if (this.progress > 1.0f) {
            this.progress = 1.0f;
            return true;
        }
        if (this.progress < 0.0f) {
            this.progress = 0.0f;
            return true;
        }
        return false;
    }

    public boolean incProgressByDistance(double distance) {
        double totalDistance = Math.sqrt(Math.pow(this.endX - this.startX, 2.0) + Math.pow(this.endY - this.startY, 2.0) + Math.pow(this.endZ - this.startZ, 2.0));
        this.progress = (float)((double)this.progress + distance / totalDistance);
        if (this.progress > 1.0f) {
            this.progress = 1.0f;
            return true;
        }
        if (this.progress < 0.0f) {
            this.progress = 0.0f;
            return true;
        }
        return false;
    }

    public int getPointedSlotNumber(GuiSecurityStationBase gui) {
        Slot slot = gui.getSlotAtPosition((int)this.endX, (int)this.endY);
        return slot != null ? slot.field_75222_d : 0;
    }
}

